/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.services.core.messages.Messages;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceCategory;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelEvent;
import org.eclipse.ptp.services.core.IServiceModelEventListener;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ProjectNotConfiguredException;
import org.eclipse.ptp.services.core.ServiceProvider;
import org.eclipse.ptp.services.internal.core.Service;
import org.eclipse.ptp.services.internal.core.ServiceCategory;
import org.eclipse.ptp.services.internal.core.ServiceConfiguration;
import org.eclipse.ptp.services.internal.core.ServiceModelEvent;
import org.eclipse.ptp.services.internal.core.ServiceModelEventManager;
import org.eclipse.ptp.services.internal.core.ServiceProviderDescriptor;
import org.eclipse.ptp.services.internal.core.ServicesCorePlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceModelManager
extends PlatformObject
implements IServiceModelManager {
    private static final String SERVICE_EXTENSION_ID = "services";
    private static final String PROVIDER_EXTENSION_ID = "providers";
    private static final String CATEGORY_EXTENSION_ID = "serviceCategories";
    private static final String SERVICE_ELEMENT_NAME = "service";
    private static final String NATURE_ELEMENT_NAME = "nature";
    private static final String PROVIDER_ELEMENT_NAME = "provider";
    private static final String CATEGORY_ELEMENT_NAME = "category";
    private static final String DISABLED_PROVIDERS_ELEMENT_NAME = "disabledProviders";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PRIORITY = "priority";
    private static final String ATTR_SERVICE_ID = "serviceId";
    private static final String ATTR_CATEGORY_ID = "categoryId";
    private static final String ATTR_NULL_PROVIDER_CLASS = "nullProviderClass";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ACTIVE = "active";
    private static final String SERVICE_MODEL_ELEMENT_NAME = "service-model";
    private static final String PROJECT_ELEMENT_NAME = "project";
    private static final String SERVICE_CONFIGURATION_ELEMENT_NAME = "service-configuration";
    private static final String PROVIDER_CONFIGURATION_ELEMENT_NAME = "provider-configuration";
    private static final String ATTR_PROVIDER_ID = "provider-id";
    private static final String DEFAULT_SAVE_FILE_NAME = "service_model.xml";
    private final IPath defaultSaveFile;
    private final Map<String, IServiceConfiguration> fConfigurations = new HashMap<String, IServiceConfiguration>();
    private final Map<IProject, Map<String, IServiceConfiguration>> fProjectConfigurations = new HashMap<IProject, Map<String, IServiceConfiguration>>();
    private final Map<IProject, IServiceConfiguration> fActiveConfigurations = new HashMap<IProject, IServiceConfiguration>();
    private final Map<IProject, Set<IService>> fProjectServices = new HashMap<IProject, Set<IService>>();
    private Map<String, Service> fServices = null;
    private Map<String, ServiceCategory> fCategories;
    private Set<IService> fServiceSet = null;
    private Map<String, Set<IService>> fNatureServices = null;
    private IServiceConfiguration fDefaultServiceConfiguration = null;
    private final ServiceModelEventManager fEventManager = new ServiceModelEventManager();
    private boolean fModelLoaded = false;
    private boolean fEventsEnabled = true;
    private static ServiceModelManager fInstance;

    private static <T> T getConf(Map<IProject, T> map, IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        T value = map.get(project);
        if (value == null) {
            throw new ProjectNotConfiguredException(project.getName());
        }
        return value;
    }

    private static void saveConfigurations(IMemento memento, IServiceConfiguration[] configs) {
        IServiceConfiguration[] iServiceConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IServiceConfiguration config = iServiceConfigurationArray[n2];
            String configurationId = config.getId();
            String configurationName = config.getName();
            IMemento configMemento = memento.createChild(SERVICE_CONFIGURATION_ELEMENT_NAME);
            configMemento.putString(ATTR_ID, configurationId);
            configMemento.putString(ATTR_NAME, configurationName);
            Set<IService> services = config.getServices();
            for (IService service : services) {
                Set<IServiceProvider> disabledProviders;
                if (!config.isDisabled(service)) {
                    IServiceProvider provider = config.getServiceProvider(service);
                    IMemento serviceMemento = configMemento.createChild(SERVICE_ELEMENT_NAME);
                    serviceMemento.putString(ATTR_ID, service.getId());
                    serviceMemento.putString(ATTR_PROVIDER_ID, provider.getId());
                    ServiceModelManager.saveProviderState(provider, serviceMemento);
                }
                if (!(config instanceof ServiceConfiguration) || (disabledProviders = ((ServiceConfiguration)config).getFormerServiceProviders(service)).isEmpty()) continue;
                IMemento disabledMemento = configMemento.createChild(DISABLED_PROVIDERS_ELEMENT_NAME);
                disabledMemento.putString(ATTR_ID, service.getId());
                for (IServiceProvider disabledProvider : disabledProviders) {
                    IMemento providerMemento = disabledMemento.createChild(PROVIDER_ELEMENT_NAME);
                    providerMemento.putString(ATTR_PROVIDER_ID, disabledProvider.getId());
                    ServiceModelManager.saveProviderState(disabledProvider, providerMemento);
                }
            }
            ++n2;
        }
    }

    private static void saveModelConfiguration(Map<String, IServiceConfiguration> configs, Map<IProject, Map<String, IServiceConfiguration>> projectConfigs, Map<IProject, IServiceConfiguration> activeConfigs, Writer writer) throws IOException {
        XMLMemento rootMemento = XMLMemento.createWriteRoot((String)SERVICE_MODEL_ELEMENT_NAME);
        ServiceModelManager.saveConfigurations((IMemento)rootMemento, configs.values().toArray(new IServiceConfiguration[0]));
        for (Map.Entry<IProject, Map<String, IServiceConfiguration>> entry : projectConfigs.entrySet()) {
            IProject project = entry.getKey();
            if (!project.exists()) continue;
            String projectName = project.getName();
            IMemento projectMemento = rootMemento.createChild(PROJECT_ELEMENT_NAME);
            projectMemento.putString(ATTR_NAME, projectName);
            Map<String, IServiceConfiguration> configurations = entry.getValue();
            for (IServiceConfiguration config : configurations.values()) {
                String configurationId = config.getId();
                IMemento configMemento = projectMemento.createChild(SERVICE_CONFIGURATION_ELEMENT_NAME);
                configMemento.putString(ATTR_ID, configurationId);
                IServiceConfiguration active = activeConfigs.get(project);
                configMemento.putBoolean(ATTR_ACTIVE, active != null);
            }
        }
        rootMemento.save(writer);
    }

    private static void saveProviderState(IServiceProvider provider, IMemento parentMemento) {
        if (provider instanceof ServiceProvider) {
            IMemento providerConfigMemento = parentMemento.createChild(PROVIDER_CONFIGURATION_ELEMENT_NAME);
            ((ServiceProvider)provider).saveState(providerConfigMemento);
        }
    }

    public static synchronized ServiceModelManager getInstance() {
        if (fInstance == null) {
            fInstance = new ServiceModelManager();
        }
        return fInstance;
    }

    private ServiceModelManager() {
        this.defaultSaveFile = ServicesCorePlugin.getDefault().getStateLocation().append(DEFAULT_SAVE_FILE_NAME);
    }

    @Override
    public void addConfiguration(IProject project, IServiceConfiguration conf) {
        this.checkAndLoadModel();
        if (project == null || conf == null) {
            throw new NullPointerException();
        }
        Map<String, IServiceConfiguration> confs = this.fProjectConfigurations.get(project);
        if (confs == null) {
            confs = new HashMap<String, IServiceConfiguration>();
            this.fProjectConfigurations.put(project, confs);
            this.fActiveConfigurations.put(project, conf);
        }
        confs.put(conf.getId(), conf);
        Set<IService> services = this.fProjectServices.get(project);
        if (services == null) {
            services = new HashSet<IService>();
            this.fProjectServices.put(project, services);
        }
        for (IServiceConfiguration config : confs.values()) {
            for (IService service : config.getServices()) {
                services.add(service);
            }
        }
        this.addConfiguration(conf);
    }

    @Override
    public void addConfiguration(IServiceConfiguration conf) {
        this.checkAndLoadModel();
        if (this.fConfigurations.put(conf.getId(), conf) == null) {
            this.notifyListeners(new ServiceModelEvent(conf, 1));
        }
    }

    @Override
    public void addEventListener(IServiceModelEventListener listener, int type) {
        this.fEventManager.addEventListener(listener, type);
    }

    @Override
    public boolean exportConfigurations(String filename, IServiceConfiguration[] configs) throws InvocationTargetException {
        File file = new File(filename);
        if (!file.exists()) {
            BufferedWriter writer;
            try {
                writer = new BufferedWriter(new FileWriter(file));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                try {
                    XMLMemento rootMemento = XMLMemento.createWriteRoot((String)SERVICE_MODEL_ELEMENT_NAME);
                    ServiceModelManager.saveConfigurations((IMemento)rootMemento, configs);
                    rootMemento.save((Writer)writer);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        return false;
    }

    @Override
    public IServiceConfiguration getActiveConfiguration() {
        this.checkAndLoadModel();
        return this.fDefaultServiceConfiguration;
    }

    @Override
    public IServiceConfiguration getActiveConfiguration(IProject project) {
        this.checkAndLoadModel();
        return ServiceModelManager.getConf(this.fActiveConfigurations, project);
    }

    @Override
    public Set<IServiceCategory> getCategories() {
        this.checkAndLoadModel();
        return new HashSet<IServiceCategory>(this.fCategories.values());
    }

    @Override
    public IServiceConfiguration getConfiguration(IProject project, String name) {
        this.checkAndLoadModel();
        Map<String, IServiceConfiguration> confMap = ServiceModelManager.getConf(this.fProjectConfigurations, project);
        for (IServiceConfiguration conf : confMap.values()) {
            if (!conf.getName().equals(name)) continue;
            return conf;
        }
        return null;
    }

    @Override
    public IServiceConfiguration getConfiguration(String id) {
        this.checkAndLoadModel();
        return this.fConfigurations.get(id);
    }

    @Override
    public Set<IServiceConfiguration> getConfigurations() {
        this.checkAndLoadModel();
        return new HashSet<IServiceConfiguration>(this.fConfigurations.values());
    }

    @Override
    public Set<IServiceConfiguration> getConfigurations(IProject project) {
        this.checkAndLoadModel();
        return new HashSet<IServiceConfiguration>(ServiceModelManager.getConf(this.fProjectConfigurations, project).values());
    }

    @Override
    public Set<IProject> getProjectsForConfiguration(IServiceConfiguration serviceConfiguration) {
        this.checkAndLoadModel();
        Set<IProject> projects = this.fProjectConfigurations.keySet();
        HashSet<IProject> projectsForConfig = new HashSet<IProject>();
        for (IProject project : projects) {
            Set<IServiceConfiguration> configs = this.getConfigurations(project);
            for (IServiceConfiguration config : configs) {
                if (config != serviceConfiguration) continue;
                projectsForConfig.add(project);
            }
        }
        return projectsForConfig;
    }

    @Override
    public IService getService(String id) {
        this.loadServicesFromExtensionRegistry();
        return this.fServices.get(id);
    }

    /*
     * Loose catch block
     */
    @Override
    public IServiceProvider getServiceProvider(IServiceProviderDescriptor desc) {
        this.fEventsEnabled = false;
        try {
            IExtensionPoint extensionPoint;
            if (desc != null && (extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.services.core", PROVIDER_EXTENSION_ID)) != null) {
                IExtension[] iExtensionArray = extensionPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String attr;
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (element.getName().equals(PROVIDER_ELEMENT_NAME) && (attr = element.getAttribute(ATTR_ID)) != null && attr.equals(desc.getId())) {
                            try {
                                IServiceProvider provider = (IServiceProvider)element.createExecutableExtension(ATTR_CLASS);
                                provider.setDescriptor(desc);
                                IServiceProvider iServiceProvider = provider;
                                return iServiceProvider;
                            }
                            catch (Exception e) {
                                ServicesCorePlugin.getDefault().log(e);
                                this.fEventsEnabled = true;
                                return null;
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return null;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.fEventsEnabled = true;
        }
    }

    @Override
    public Set<IService> getServices() {
        this.loadServicesFromExtensionRegistry();
        return this.fServiceSet;
    }

    @Override
    public Set<IService> getServices(IProject project) {
        this.checkAndLoadModel();
        return ServiceModelManager.getConf(this.fProjectServices, project);
    }

    @Override
    public Set<IService> getServices(String natureId) {
        this.loadServicesFromExtensionRegistry();
        return this.fNatureServices.get(natureId);
    }

    @Override
    public IServiceConfiguration[] importConfigurations(String filename) throws InvocationTargetException {
        File file = new File(filename);
        if (file.exists()) {
            BufferedReader reader;
            try {
                reader = new BufferedReader(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                throw new InvocationTargetException(e);
            }
            try {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)reader);
                this.setEnableEvents(false);
                IServiceConfiguration[] iServiceConfigurationArray = this.doLoadConfigurations((IMemento)rootMemento, true);
                return iServiceConfigurationArray;
            }
            catch (WorkbenchException e) {
                throw new InvocationTargetException(e);
            }
            finally {
                this.setEnableEvents(true);
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isConfigured(IProject project) {
        this.checkAndLoadModel();
        return this.fProjectConfigurations.containsKey(project);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isValidConfigurationFile(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 39[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadModelConfiguration() throws IOException, CoreException {
        this.loadServicesFromExtensionRegistry();
        File file = this.defaultSaveFile.toFile();
        if (file.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                this.loadModelConfiguration(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        this.notifyListeners(new ServiceModelEvent(this, 32));
    }

    public void loadModelConfiguration(Reader reader) throws IOException, CoreException {
        this.fModelLoaded = true;
        this.initialize();
        XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)reader);
        IServiceConfiguration[] iServiceConfigurationArray = this.doLoadConfigurations((IMemento)rootMemento, false);
        int n = iServiceConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServiceConfiguration config = iServiceConfigurationArray[n2];
            this.addConfiguration(config);
            ++n2;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMemento[] iMementoArray = rootMemento.getChildren(PROJECT_ELEMENT_NAME);
        int n3 = iMementoArray.length;
        n = 0;
        while (n < n3) {
            IMemento projectMemento = iMementoArray[n];
            String projectName = projectMemento.getString(ATTR_NAME);
            IProject project = root.getProject(projectName);
            if (project.exists()) {
                IMemento[] iMementoArray2 = projectMemento.getChildren(SERVICE_CONFIGURATION_ELEMENT_NAME);
                int n4 = iMementoArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    IMemento configMemento = iMementoArray2[n5];
                    String configId = configMemento.getString(ATTR_ID);
                    IServiceConfiguration config = this.fConfigurations.get(configId);
                    if (config != null) {
                        this.addConfiguration(project, config);
                        Boolean active = configMemento.getBoolean(ATTR_ACTIVE);
                        if (active != null && active.booleanValue()) {
                            this.setActiveConfiguration(project, config);
                        }
                    }
                    ++n5;
                }
            }
            ++n;
        }
    }

    @Override
    public IServiceConfiguration newServiceConfiguration(String name) {
        return this.newServiceConfiguration(UUID.randomUUID().toString(), name);
    }

    public void notifyListeners(IServiceModelEvent event) {
        if (this.fEventsEnabled) {
            this.fEventManager.notifyListeners(event);
        }
    }

    public void printServiceModel() {
        System.out.println("Service Model: ");
        if (this.fProjectConfigurations.isEmpty()) {
            System.out.println("  Service Model is empty");
        }
        for (Map.Entry<IProject, Map<String, IServiceConfiguration>> entry : this.fProjectConfigurations.entrySet()) {
            IProject project = entry.getKey();
            System.out.println("  Project: " + project.getName());
            for (IServiceConfiguration conf : entry.getValue().values()) {
                System.out.println("      " + conf);
            }
        }
    }

    @Override
    public void remap(IProject removedProject, IProject addedProject) {
        if (removedProject == null || addedProject == null) {
            throw new NullPointerException();
        }
        if (this.isConfigured(removedProject)) {
            this.fProjectConfigurations.put(addedProject, this.fProjectConfigurations.remove(removedProject));
            this.fActiveConfigurations.put(addedProject, this.fActiveConfigurations.remove(removedProject));
            this.fProjectServices.put(addedProject, this.fProjectServices.remove(removedProject));
        }
    }

    @Override
    public void remove(IProject project) {
        this.checkAndLoadModel();
        if (project == null) {
            throw new NullPointerException();
        }
        this.fProjectConfigurations.remove(project);
        this.fActiveConfigurations.remove(project);
        this.fProjectServices.remove(project);
    }

    @Override
    public void remove(IServiceConfiguration conf) {
        this.checkAndLoadModel();
        for (IProject project : this.fProjectConfigurations.keySet()) {
            this.removeConfiguration(project, conf);
            if (!conf.equals(this.getActiveConfiguration(project))) continue;
            this.fActiveConfigurations.remove(project);
        }
        this.fConfigurations.remove(conf.getId());
        this.notifyListeners(new ServiceModelEvent(conf, 2));
    }

    @Override
    public void removeConfiguration(IProject project, IServiceConfiguration conf) {
        this.checkAndLoadModel();
        Map<String, IServiceConfiguration> confs = ServiceModelManager.getConf(this.fProjectConfigurations, project);
        if (confs != null) {
            confs.remove(conf.getId());
        }
    }

    @Override
    public void removeEventListener(IServiceModelEventListener listener) {
        this.fEventManager.removeEventListener(listener);
    }

    public void saveModelConfiguration() throws IOException {
        this.checkAndLoadModel();
        File file = this.defaultSaveFile.toFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            this.saveModelConfiguration(writer);
        }
        finally {
            writer.close();
        }
    }

    public void saveModelConfiguration(Writer writer) throws IOException {
        if (writer == null) {
            throw new NullPointerException();
        }
        ServiceModelManager.saveModelConfiguration(this.fConfigurations, this.fProjectConfigurations, this.fActiveConfigurations, writer);
        this.notifyListeners(new ServiceModelEvent(this, 16));
    }

    @Override
    public void setActiveConfiguration(IProject project, IServiceConfiguration configuration) {
        this.checkAndLoadModel();
        Map<String, IServiceConfiguration> confs = ServiceModelManager.getConf(this.fProjectConfigurations, project);
        if (!confs.containsKey(configuration.getId())) {
            throw new IllegalArgumentException();
        }
        this.fActiveConfigurations.put(project, configuration);
    }

    @Override
    public void setActiveConfiguration(IServiceConfiguration config) {
        this.fDefaultServiceConfiguration = config;
        this.notifyListeners(new ServiceModelEvent(config, 8));
    }

    private void checkAndLoadModel() {
        if (!this.fModelLoaded) {
            try {
                this.loadModelConfiguration();
            }
            catch (Exception e) {
                ServicesCorePlugin.getDefault().log(e);
            }
        }
    }

    private IServiceConfiguration[] doLoadConfigurations(IMemento rootMemento, boolean importing) {
        HashSet<ServiceConfiguration> configs = new HashSet<ServiceConfiguration>();
        IMemento[] iMementoArray = rootMemento.getChildren(SERVICE_CONFIGURATION_ELEMENT_NAME);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IService service;
            String serviceId;
            IMemento configMemento = iMementoArray[n2];
            String configId = configMemento.getString(ATTR_ID);
            if (importing) {
                configId = UUID.randomUUID().toString();
            }
            String configName = configMemento.getString(ATTR_NAME);
            ServiceConfiguration config = this.newServiceConfiguration(configId, configName);
            IMemento[] iMementoArray2 = configMemento.getChildren(SERVICE_ELEMENT_NAME);
            int n3 = iMementoArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento serviceMemento = iMementoArray2[n4];
                serviceId = serviceMemento.getString(ATTR_ID);
                service = this.getService(serviceId);
                IServiceProvider provider = this.loadServiceProvider(serviceMemento, service);
                config.setServiceProvider(service, provider);
                ++n4;
            }
            iMementoArray2 = configMemento.getChildren(DISABLED_PROVIDERS_ELEMENT_NAME);
            n3 = iMementoArray2.length;
            n4 = 0;
            while (n4 < n3) {
                IMemento disabledMemento = iMementoArray2[n4];
                serviceId = disabledMemento.getString(ATTR_ID);
                service = this.getService(serviceId);
                IMemento[] iMementoArray3 = disabledMemento.getChildren(PROVIDER_ELEMENT_NAME);
                int n5 = iMementoArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    IMemento providerMemento = iMementoArray3[n6];
                    IServiceProvider provider = this.loadServiceProvider(providerMemento, service);
                    config.addFormerServiceProvider(service, provider);
                    ++n6;
                }
                ++n4;
            }
            configs.add(config);
            ++n2;
        }
        return configs.toArray(new IServiceConfiguration[0]);
    }

    private void initialize() {
        this.fActiveConfigurations.clear();
        this.fProjectConfigurations.clear();
        this.fProjectServices.clear();
        this.fConfigurations.clear();
    }

    private IServiceProvider loadServiceProvider(IMemento providerMemento, IService service) {
        if (service == null) {
            return null;
        }
        String providerId = providerMemento.getString(ATTR_PROVIDER_ID);
        IServiceProviderDescriptor descriptor = service.getProviderDescriptor(providerId);
        if (descriptor != null) {
            IServiceProvider provider = this.getServiceProvider(descriptor);
            if (provider != null) {
                if (provider instanceof ServiceProvider) {
                    IMemento providerConfigMemento = providerMemento.getChild(PROVIDER_CONFIGURATION_ELEMENT_NAME);
                    ((ServiceProvider)provider).restoreState(providerConfigMemento);
                }
                return provider;
            }
            ServicesCorePlugin.getDefault().logErrorMessage(Messages.ServiceModelManager_2);
        } else {
            ServicesCorePlugin.getDefault().logErrorMessage(String.valueOf(Messages.ServiceModelManager_0) + providerId);
        }
        return null;
    }

    private void loadServicesFromExtensionRegistry() {
        String priority;
        String name;
        String id;
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        int n3;
        int n4;
        IExtension[] iExtensionArray;
        if (this.fServices != null) {
            return;
        }
        this.fServices = new HashMap<String, Service>();
        this.fCategories = new HashMap<String, ServiceCategory>();
        this.fServiceSet = new HashSet<IService>();
        this.fNatureServices = new HashMap<String, Set<IService>>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.services.core", CATEGORY_EXTENSION_ID);
        if (extensionPoint != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                extension = iExtensionArray[n3];
                iConfigurationElementArray = extension.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(CATEGORY_ELEMENT_NAME)) {
                        id = element.getAttribute(ATTR_ID);
                        name = element.getAttribute(ATTR_NAME);
                        ServiceCategory category = new ServiceCategory(id, name);
                        this.fCategories.put(id, category);
                    }
                    ++n;
                }
                ++n3;
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.services.core", SERVICE_EXTENSION_ID)) != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                extension = iExtensionArray[n3];
                iConfigurationElementArray = extension.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(SERVICE_ELEMENT_NAME)) {
                        ServiceCategory category;
                        id = element.getAttribute(ATTR_ID);
                        name = element.getAttribute(ATTR_NAME);
                        priority = element.getAttribute(ATTR_PRIORITY);
                        String categoryId = element.getAttribute(ATTR_CATEGORY_ID);
                        IConfigurationElement[] natureConf = element.getChildren(NATURE_ELEMENT_NAME);
                        HashSet<String> natures = new HashSet<String>();
                        if (natureConf != null) {
                            IConfigurationElement[] iConfigurationElementArray2 = natureConf;
                            int n5 = natureConf.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement nature = iConfigurationElementArray2[n6];
                                String natureId = nature.getAttribute(ATTR_ID);
                                if (workspace.getNatureDescriptor(natureId) != null) {
                                    natures.add(natureId);
                                }
                                ++n6;
                            }
                        }
                        Service service = new Service(id, name, priority, natures);
                        this.fServiceSet.add(service);
                        this.fServices.put(id, service);
                        for (String nature : natures) {
                            Set<IService> svcs = this.fNatureServices.get(nature);
                            if (svcs == null) {
                                svcs = new HashSet<IService>();
                                this.fNatureServices.put(nature, svcs);
                            }
                            svcs.add(service);
                        }
                        if (element.getAttribute(ATTR_NULL_PROVIDER_CLASS) != null) {
                            try {
                                IServiceProvider nullProvider = (IServiceProvider)element.createExecutableExtension(ATTR_NULL_PROVIDER_CLASS);
                                if (nullProvider instanceof ServiceProvider) {
                                    String providerId = String.valueOf(service.getId()) + ".nullProvider";
                                    ServiceProviderDescriptor descriptor = new ServiceProviderDescriptor(providerId, Messages.ServiceModelManager_3, service.getId(), "0");
                                    ((ServiceProvider)nullProvider).setDescriptor(descriptor);
                                }
                                service.setNullServiceProvider(nullProvider);
                            }
                            catch (CoreException e) {
                                ServicesCorePlugin.getDefault().log(e);
                            }
                        }
                        if ((category = this.fCategories.get(categoryId)) != null) {
                            category.addService(service);
                            service.setCategory(category);
                        }
                    }
                    ++n;
                }
                ++n3;
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.services.core", PROVIDER_EXTENSION_ID)) != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                extension = iExtensionArray[n3];
                iConfigurationElementArray = extension.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(PROVIDER_ELEMENT_NAME)) {
                        id = element.getAttribute(ATTR_ID);
                        name = element.getAttribute(ATTR_NAME);
                        priority = element.getAttribute(ATTR_PRIORITY);
                        String serviceId = element.getAttribute(ATTR_SERVICE_ID);
                        ServiceProviderDescriptor desc = new ServiceProviderDescriptor(id, name, serviceId, priority);
                        Service service = this.fServices.get(serviceId);
                        if (service != null) {
                            service.addServiceProvider(desc);
                        } else {
                            ServicesCorePlugin.getDefault().logErrorMessage(NLS.bind((String)Messages.Services_invalidServiceId, (Object)serviceId));
                        }
                    }
                    ++n;
                }
                ++n3;
            }
        }
    }

    private ServiceConfiguration newServiceConfiguration(String id, String name) {
        return new ServiceConfiguration(id, name);
    }

    private void setEnableEvents(boolean enable) {
        this.fEventsEnabled = enable;
    }

    private boolean validateServiceProvider(IMemento providerMemento, IService service) {
        String providerId = providerMemento.getString(ATTR_PROVIDER_ID);
        if (providerId == null) {
            return false;
        }
        IServiceProviderDescriptor descriptor = service.getProviderDescriptor(providerId);
        if (descriptor == null) {
            return false;
        }
        IMemento providerConfigMemento = providerMemento.getChild(PROVIDER_CONFIGURATION_ELEMENT_NAME);
        return providerConfigMemento != null;
    }
}

