/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.widgets;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ptp.internal.services.ui.messages.Messages;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.dialogs.ServiceProviderConfigurationDialog;
import org.eclipse.ptp.services.ui.widgets.ServiceConfigurationSelectionWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddServiceConfigurationWidget
extends Composite
implements ISelectionProvider {
    private final Text fNewConfigNameText;
    private final Button fNewConfigButton;
    private final Button fExistingConfigButton;
    private final Button fAdvancedButton;
    private ISelection fSelection = null;
    private IServiceConfiguration fDefaultConfig = null;
    private IServiceConfiguration fServiceConfig = null;
    private final ServiceConfigurationSelectionWidget fServiceConfigWidget;
    private final ListenerList fSelectionListeners = new ListenerList();

    public AddServiceConfigurationWidget(Composite parent, int style) {
        this(parent, style, null, null, false);
    }

    public AddServiceConfigurationWidget(Composite parent, int style, Set<IServiceConfiguration> excluded, Set<IService> services, boolean enableButtons) {
        super(parent, style);
        GridLayout bodyLayout = new GridLayout(1, false);
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        this.setLayout((Layout)bodyLayout);
        this.fNewConfigButton = new Button((Composite)this, 16);
        this.fNewConfigButton.setText(Messages.AddServiceConfigurationWidget_0);
        this.fNewConfigButton.setLayoutData((Object)new GridData());
        this.fNewConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddServiceConfigurationWidget.this.doSelectionUpdate();
                AddServiceConfigurationWidget.this.notifySelection((ISelection)new ConfigurationSelectionEvent());
            }
        });
        this.fNewConfigButton.setEnabled(false);
        Composite newComp = new Composite((Composite)this, 0);
        newComp.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 10;
        newComp.setLayout((Layout)layout);
        Label label = new Label(newComp, 0);
        label.setText(Messages.AddServiceConfigurationWidget_1);
        label.setLayoutData((Object)new GridData());
        this.fNewConfigNameText = new Text(newComp, 2048);
        GridData data = new GridData(4, 128, true, false);
        this.fNewConfigNameText.setLayoutData((Object)data);
        this.fNewConfigNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddServiceConfigurationWidget.this.fDefaultConfig.setName(AddServiceConfigurationWidget.this.fNewConfigNameText.getText());
            }
        });
        this.fExistingConfigButton = new Button((Composite)this, 16);
        this.fExistingConfigButton.setText(Messages.AddServiceConfigurationWidget_2);
        this.fExistingConfigButton.setLayoutData((Object)new GridData());
        this.fExistingConfigButton.setEnabled(this.configurationCount(excluded) != 0);
        Composite existingComp = new Composite((Composite)this, 0);
        layout = new GridLayout(1, false);
        layout.marginLeft = 10;
        existingComp.setLayoutData((Object)new GridData(4, 4, true, true));
        existingComp.setLayout((Layout)layout);
        this.fServiceConfigWidget = new ServiceConfigurationSelectionWidget(existingComp, 0, excluded, services, enableButtons);
        data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.fServiceConfigWidget.setLayoutData(data);
        this.fServiceConfigWidget.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddServiceConfigurationWidget.this.fServiceConfig = AddServiceConfigurationWidget.this.fServiceConfigWidget.getSelectedConfiguration();
                AddServiceConfigurationWidget.this.fAdvancedButton.setEnabled(!event.getSelection().isEmpty());
                AddServiceConfigurationWidget.this.notifySelection(event.getSelection());
            }
        });
        this.fServiceConfigWidget.setEnabled(false);
        this.fAdvancedButton = new Button((Composite)this, 8);
        data = new GridData(0x1000008, 128, true, true);
        this.fAdvancedButton.setLayoutData((Object)data);
        this.fAdvancedButton.setText(Messages.AddServiceConfigurationWidget_3);
        this.fAdvancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServiceProviderConfigurationDialog dialog = new ServiceProviderConfigurationDialog(AddServiceConfigurationWidget.this.getShell(), AddServiceConfigurationWidget.this.getServiceConfiguration());
                dialog.open();
            }
        });
        this.updateButtons(true);
    }

    private int configurationCount(Set<IServiceConfiguration> excluded) {
        Set configs = ServiceModelManager.getInstance().getConfigurations();
        if (excluded != null) {
            configs.removeAll(excluded);
        }
        return configs.size();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public IServiceConfiguration getServiceConfiguration() {
        return this.fServiceConfig;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setDefaultConfiguration(IServiceConfiguration config) {
        if (config != null) {
            this.fDefaultConfig = config;
            this.fNewConfigNameText.setText(config.getName());
            this.fNewConfigButton.setEnabled(true);
            this.doSelectionUpdate();
        }
    }

    public void setSelection(boolean newButtonSelected) {
        if (this.fDefaultConfig != null) {
            this.updateButtons(newButtonSelected);
            this.doSelectionUpdate();
            this.notifySelection((ISelection)new ConfigurationSelectionEvent());
        }
    }

    public void setSelection(ISelection selection) {
        this.fSelection = selection;
    }

    private void doSelectionUpdate() {
        this.fNewConfigNameText.setEnabled(this.fNewConfigButton.getSelection());
        this.fServiceConfigWidget.setEnabled(!this.fNewConfigButton.getSelection());
        if (this.fNewConfigButton.getSelection()) {
            this.fServiceConfig = this.fDefaultConfig;
            this.fAdvancedButton.setEnabled(true);
        } else {
            this.fServiceConfig = this.fServiceConfigWidget.getSelectedConfiguration();
            this.fAdvancedButton.setEnabled(this.fServiceConfigWidget.getSelectedConfiguration() != null);
        }
    }

    private void notifySelection(ISelection selection) {
        this.setSelection(selection);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(event);
            ++n2;
        }
    }

    private void updateButtons(boolean newSelected) {
        if (this.fExistingConfigButton.isEnabled()) {
            this.fNewConfigButton.setSelection(newSelected);
            this.fExistingConfigButton.setSelection(!newSelected);
        } else {
            this.fNewConfigButton.setSelection(true);
        }
    }

    private class ConfigurationSelectionEvent
    implements IStructuredSelection {
        private final Object selection;

        private ConfigurationSelectionEvent() {
            this.selection = AddServiceConfigurationWidget.this.getServiceConfiguration();
        }

        public Object getFirstElement() {
            return this.isEmpty() ? null : this.toArray()[0];
        }

        public boolean isEmpty() {
            return this.toArray().length == 0;
        }

        public Iterator iterator() {
            return this.toList().iterator();
        }

        public int size() {
            return this.toArray().length;
        }

        public Object[] toArray() {
            Object[] objectArray;
            if (this.selection == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.selection;
            }
            return objectArray;
        }

        public List toList() {
            return Arrays.asList(this.selection);
        }
    }
}

