/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.widgets;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.internal.services.ui.messages.Messages;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.IServiceProviderContributor;
import org.eclipse.ptp.services.ui.ServiceModelUIManager;
import org.eclipse.ptp.services.ui.dialogs.ServiceSelectionDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceModelWidget {
    protected static final String PROVIDER_KEY = "provider-id";
    protected static final String SERVICE_KEY = "service-id";
    protected IServiceConfiguration fServiceConfiguration;
    protected Map<String, String> fServiceIDToSelectedProviderID;
    protected Map<String, IServiceProvider> fProviderIDToProviderMap;
    protected Table fTable;
    protected Button fConfigureButton;
    protected Button fAddButton;
    protected Button fRemoveButton;
    protected Listener fConfigChangeListener = null;
    private Shell fShell;

    public ServiceModelWidget() {
        this.fServiceIDToSelectedProviderID = new HashMap<String, String>();
        this.fProviderIDToProviderMap = new HashMap<String, IServiceProvider>();
    }

    public ServiceModelWidget(IServiceConfiguration serviceConfiguration) {
        this.fServiceConfiguration = serviceConfiguration;
        this.fServiceIDToSelectedProviderID = new HashMap<String, String>();
        this.fProviderIDToProviderMap = new HashMap<String, IServiceProvider>();
    }

    private void addTableRow(IService service, IServiceProvider provider) {
        TableItem item = new TableItem(this.fTable, 0);
        item.setText(0, service.getName());
        item.setData(SERVICE_KEY, (Object)service);
        item.setText(1, provider.getName());
        item.setData(PROVIDER_KEY, (Object)provider);
        item.setText(2, provider.getConfigurationString());
        this.fServiceIDToSelectedProviderID.put(service.getId(), provider.getId());
        if (this.fConfigChangeListener != null) {
            this.fConfigChangeListener.handleEvent(null);
        }
    }

    public Control createContents(Composite parent) {
        this.fShell = parent.getShell();
        Composite canvas = new Composite(parent, 0);
        GridLayout canvasLayout = new GridLayout(2, false);
        canvas.setLayout((Layout)canvasLayout);
        Composite tableParent = new Composite(canvas, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable = new Table(tableParent, 67842);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        TableColumnLayout layout = new TableColumnLayout();
        String[] titles = new String[]{Messages.ServiceModelWidget_0, Messages.ServiceModelWidget_1, Messages.ServiceModelWidget_3};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.fTable, 0);
            column.setText(titles[i]);
            int width = 20;
            switch (i) {
                case 0: {
                    width = 100;
                    break;
                }
                case 1: {
                    width = 250;
                    break;
                }
                case 2: {
                    width = 100;
                }
            }
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, width, true));
            ++i;
        }
        tableParent.setLayout((Layout)layout);
        this.fTable.setLayout((Layout)new FillLayout());
        this.createTableContent();
        this.fTable.setVisible(true);
        final TableEditor editor = new TableEditor(this.fTable);
        editor.horizontalAlignment = 1;
        editor.grabHorizontal = true;
        this.fTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int selectionIndex = ServiceModelWidget.this.fTable.getSelectionIndex();
                if (selectionIndex == -1) {
                    ServiceModelWidget.this.fConfigureButton.setEnabled(false);
                    return;
                }
                final TableItem item = ServiceModelWidget.this.fTable.getItem(selectionIndex);
                IService service = (IService)item.getData(ServiceModelWidget.SERVICE_KEY);
                IServiceProvider provider = (IServiceProvider)item.getData(ServiceModelWidget.PROVIDER_KEY);
                ServiceModelWidget.this.updateConfigureButton((IServiceProviderDescriptor)provider);
                final CCombo combo = new CCombo((Composite)ServiceModelWidget.this.fTable, 8);
                int index = 0;
                final LinkedList<IServiceProviderDescriptor> providerIds = new LinkedList<IServiceProviderDescriptor>();
                SortedSet providers = service.getProvidersByPriority();
                for (IServiceProviderDescriptor descriptor : providers) {
                    combo.add(descriptor.getName(), index);
                    providerIds.add(descriptor);
                    if (descriptor.getId().equals(provider.getId())) {
                        combo.select(index);
                    }
                    ++index;
                }
                combo.setFocus();
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.type) {
                            case 16: {
                                combo.dispose();
                                break;
                            }
                            case 13: {
                                int selection = combo.getSelectionIndex();
                                if (selection == -1) {
                                    return;
                                }
                                IServiceProviderDescriptor descriptor = (IServiceProviderDescriptor)providerIds.get(selection);
                                IServiceProvider provider = ServiceModelWidget.this.getServiceProvider(descriptor);
                                item.setText(1, provider.getName());
                                item.setData(ServiceModelWidget.PROVIDER_KEY, (Object)provider);
                                ServiceModelWidget.this.updateConfigureButton(descriptor);
                                item.setText(2, provider.getConfigurationString());
                                IService service = (IService)item.getData(ServiceModelWidget.SERVICE_KEY);
                                (this).ServiceModelWidget.this.fServiceIDToSelectedProviderID.put(service.getId(), descriptor.getId());
                                ServiceModelWidget.this.getServiceConfiguration().setServiceProvider(service, provider);
                                if ((this).ServiceModelWidget.this.fConfigChangeListener != null) {
                                    (this).ServiceModelWidget.this.fConfigChangeListener.handleEvent(null);
                                }
                                combo.dispose();
                            }
                        }
                    }
                };
                combo.addListener(16, listener);
                combo.addListener(13, listener);
                editor.setEditor((Control)combo, item, 1);
            }
        });
        Composite buttonParent = new Composite(canvas, 0);
        GridLayout buttonLayout = new GridLayout(1, true);
        buttonParent.setLayout((Layout)buttonLayout);
        buttonParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fConfigureButton = new Button(buttonParent, 8);
        this.fConfigureButton.setEnabled(false);
        this.fConfigureButton.setText(Messages.ServiceModelWidget_2);
        this.fConfigureButton.setLayoutData((Object)new GridData(768));
        Listener configureListener = this.getConfigureListener();
        this.fConfigureButton.addListener(13, configureListener);
        this.fAddButton = new Button(buttonParent, 8);
        this.fAddButton.setEnabled(true);
        this.fAddButton.setText(Messages.ServiceModelWidget_6);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        Listener addListener = this.getAddListener();
        this.fAddButton.addListener(13, addListener);
        this.fRemoveButton = new Button(buttonParent, 8);
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.setText(Messages.ServiceModelWidget_7);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        Listener removeListener = this.getRemoveListener();
        this.fRemoveButton.addListener(13, removeListener);
        this.updateAddRemoveButtons();
        return canvas;
    }

    protected void createTableContent() {
        this.fTable.removeAll();
        if (this.getServiceConfiguration() != null) {
            for (IService service : this.getServiceConfiguration().getServices()) {
                this.addTableRow(service, this.getServiceConfiguration().getServiceProvider(service));
            }
        }
    }

    protected Listener getAddListener() {
        return new AddListener();
    }

    public Listener getConfigChangeListener() {
        return this.fConfigChangeListener;
    }

    protected Listener getConfigureListener() {
        return new ConfigureListener();
    }

    protected Set<IService> getContributedServices(IProject project) {
        ServiceModelManager modelManager = ServiceModelManager.getInstance();
        LinkedHashSet<IService> allApplicableServices = new LinkedHashSet<IService>();
        if (project != null) {
            String[] natureIds = new String[]{};
            try {
                natureIds = project.getDescription().getNatureIds();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < natureIds.length) {
                String natureId = natureIds[i];
                Set services = modelManager.getServices(natureId);
                if (services != null) {
                    allApplicableServices.addAll(services);
                }
                ++i;
            }
        }
        return allApplicableServices;
    }

    public Map<String, IServiceProvider> getProviderIDToProviderMap() {
        return this.fProviderIDToProviderMap;
    }

    protected Listener getRemoveListener() {
        return new RemoveListener();
    }

    public IServiceConfiguration getServiceConfiguration() {
        return this.fServiceConfiguration;
    }

    public Map<String, String> getServiceIDToSelectedProviderID() {
        return this.fServiceIDToSelectedProviderID;
    }

    private IServiceProvider getServiceProvider(IServiceProviderDescriptor descriptor) {
        IServiceProvider serviceProvider = this.getProviderIDToProviderMap().get(descriptor.getId());
        if (serviceProvider == null) {
            serviceProvider = ServiceModelManager.getInstance().getServiceProvider(descriptor);
            this.getProviderIDToProviderMap().put(descriptor.getId(), serviceProvider);
        }
        return serviceProvider;
    }

    private Shell getShell() {
        return this.fShell;
    }

    public Table getTable() {
        return this.fTable;
    }

    public boolean isConfigured() {
        return this.isConfigured(null, this.fServiceIDToSelectedProviderID, this.getProviderIDToProviderMap());
    }

    protected boolean isConfigured(IProject project, Map<String, String> serviceIDToSelectedProviderID, Map<String, IServiceProvider> providerIDToProviderMap) {
        Set<IService> allApplicableServices = this.getContributedServices(project);
        Iterator<IService> iterator = allApplicableServices.iterator();
        boolean configured = true;
        while (iterator.hasNext()) {
            String providerID = serviceIDToSelectedProviderID.get(iterator.next().getId());
            if (providerID == null) {
                return false;
            }
            IServiceProvider provider = providerIDToProviderMap.get(providerID);
            if (provider == null) {
                return false;
            }
            boolean bl = configured = configured && provider.isConfigured();
        }
        return configured;
    }

    public void setConfigChangeListener(Listener configChangeListener) {
        this.fConfigChangeListener = configChangeListener;
    }

    public void setProviderIDToProviderMap(Map<String, IServiceProvider> providerIDToProviderMap) {
        this.fProviderIDToProviderMap = providerIDToProviderMap;
    }

    public void setServiceConfiguration(IServiceConfiguration config) {
        this.fServiceConfiguration = config;
        if (config != null) {
            this.createTableContent();
        }
    }

    public void setServiceIDToSelectedProviderID(Map<String, String> serviceIDToSelectedProviderID) {
        this.fServiceIDToSelectedProviderID = serviceIDToSelectedProviderID;
    }

    public void setTable(Table table) {
        this.fTable = table;
    }

    protected void updateAddRemoveButtons() {
        Set services = ServiceModelManager.getInstance().getServices();
        this.fAddButton.setEnabled(services.size() > this.fTable.getItemCount());
        this.fRemoveButton.setEnabled(this.fTable.getItemCount() > 0);
    }

    protected void updateConfigureButton(IServiceProviderDescriptor descriptor) {
        IServiceProviderContributor config = ServiceModelUIManager.getInstance().getServiceProviderContributor(descriptor);
        this.fConfigureButton.setEnabled(config != null);
    }

    public class AddListener
    implements Listener {
        public void handleEvent(Event event) {
            HashSet<IService> displaySet = new HashSet<IService>();
            Set configServices = ServiceModelWidget.this.getServiceConfiguration().getServices();
            for (IService service : ServiceModelManager.getInstance().getServices()) {
                if (configServices.contains(service) || service.getProviders().size() <= 0) continue;
                displaySet.add(service);
            }
            ServiceSelectionDialog dialog = new ServiceSelectionDialog(ServiceModelWidget.this.getShell(), displaySet.toArray(new IService[0]));
            if (dialog.open() == 0) {
                IService[] selectedServices;
                IService[] iServiceArray = selectedServices = dialog.getSelectedServices();
                int n = selectedServices.length;
                int n2 = 0;
                while (n2 < n) {
                    IService service = iServiceArray[n2];
                    SortedSet providers = service.getProvidersByPriority();
                    IServiceProvider provider = ServiceModelManager.getInstance().getServiceProvider((IServiceProviderDescriptor)providers.iterator().next());
                    ServiceModelWidget.this.addTableRow(service, provider);
                    ServiceModelWidget.this.getServiceConfiguration().setServiceProvider(service, provider);
                    ++n2;
                }
                ServiceModelWidget.this.updateAddRemoveButtons();
            }
        }
    }

    public class ConfigureListener
    implements Listener {
        public void handleEvent(Event event) {
            TableItem[] selection = ServiceModelWidget.this.fTable.getSelection();
            if (selection.length == 0) {
                return;
            }
            TableItem item = selection[0];
            IServiceProvider provider = (IServiceProvider)item.getData(ServiceModelWidget.PROVIDER_KEY);
            IServiceProviderContributor config = ServiceModelUIManager.getInstance().getServiceProviderContributor((IServiceProviderDescriptor)provider);
            IWizard wizard = config.getWizard(provider, null);
            WizardDialog dialog = new WizardDialog(ServiceModelWidget.this.getShell(), wizard);
            dialog.open();
            String configString = provider.getConfigurationString();
            if (configString == null) {
                configString = Messages.ServiceModelWidget_4;
            }
            item.setText(2, configString);
            if (ServiceModelWidget.this.fConfigChangeListener != null) {
                ServiceModelWidget.this.fConfigChangeListener.handleEvent(null);
            }
        }
    }

    public class RemoveListener
    implements Listener {
        public void handleEvent(Event event) {
            TableItem[] items = ServiceModelWidget.this.fTable.getSelection();
            if (items.length == 0) {
                return;
            }
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                IService service = (IService)item.getData(ServiceModelWidget.SERVICE_KEY);
                if (service != null) {
                    ServiceModelWidget.this.getServiceConfiguration().disable(service);
                }
                ServiceModelWidget.this.fTable.remove(ServiceModelWidget.this.fTable.indexOf(item));
                ++n2;
            }
            ServiceModelWidget.this.updateAddRemoveButtons();
        }
    }
}

