/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ptp.internal.remote.rse.core.RSEConnection;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.SystemChildrenContentsType;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.internal.ui.view.SystemViewFilterReferenceAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEUIFileManager
implements IRemoteUIFileManager {
    private final IRemoteConnectionManager connMgr;
    private IRemoteConnection connection = null;
    private IHost connHost = null;
    private boolean onlyConnection = true;

    public RSEUIFileManager(IRemoteServices services) {
        this.connMgr = services.getConnectionManager();
    }

    public String browseDirectory(Shell shell, String message, String filterPath, int flags) {
        SystemRemoteFolderDialog dlg = new SystemRemoteFolderDialog(shell, message, this.connHost);
        dlg.setDefaultSystemConnection(this.connHost, this.onlyConnection);
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0) {
            this.connHost = dlg.getSelectedConnection();
            this.connection = this.connMgr.getConnection(this.connHost.getName());
            Object retObj = dlg.getSelectedObject();
            if (retObj instanceof IRemoteFile) {
                IRemoteFile selectedFile = (IRemoteFile)retObj;
                return selectedFile.getAbsolutePath();
            }
            if (retObj instanceof ISystemFilterReference) {
                Object[] con;
                ISystemFilterReference selectedFile = (ISystemFilterReference)retObj;
                RSEUIPlugin plugin = RSEUIPlugin.getDefault();
                if (selectedFile.getContents((ISystemContentsType)SystemChildrenContentsType.getInstance()) == null) {
                    IAdapterFactory factory = plugin.getSystemViewAdapterFactory();
                    SystemViewFilterReferenceAdapter adapter = (SystemViewFilterReferenceAdapter)factory.getAdapter((Object)selectedFile, ISystemFilterReference.class);
                    adapter.getChildren((Object)selectedFile);
                }
                if ((con = selectedFile.getContents((ISystemContentsType)SystemChildrenContentsType.getInstance())) != null && con[0] instanceof IRemoteFile) {
                    IRemoteFile file = (IRemoteFile)con[0];
                    if (file.getParentPath() == null) {
                        return file.getAbsolutePath();
                    }
                    return file.getParentPath();
                }
            }
        }
        return null;
    }

    public String browseFile(Shell shell, String message, String filterPath, int flags) {
        SystemRemoteFileDialog dlg = new SystemRemoteFileDialog(shell, message, this.connHost);
        dlg.setDefaultSystemConnection(this.connHost, this.onlyConnection);
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0) {
            this.connHost = dlg.getSelectedConnection();
            this.connection = this.connMgr.getConnection(this.connHost.getName());
            Object retObj = dlg.getSelectedObject();
            if (retObj instanceof IRemoteFile) {
                IRemoteFile selectedFile = (IRemoteFile)retObj;
                return selectedFile.getAbsolutePath();
            }
        }
        return null;
    }

    public List<String> browseFiles(Shell shell, String message, String filterPath, int flags) {
        SystemRemoteFileDialog dlg = new SystemRemoteFileDialog(shell, message, this.connHost);
        dlg.setDefaultSystemConnection(this.connHost, this.onlyConnection);
        dlg.setBlockOnOpen(true);
        dlg.setMultipleSelectionMode(true);
        if (dlg.open() == 0) {
            this.connHost = dlg.getSelectedConnection();
            this.connection = this.connMgr.getConnection(this.connHost.getName());
            Object[] retObj = dlg.getSelectedObjects();
            ArrayList<String> selections = new ArrayList<String>(retObj.length);
            Object[] objectArray = retObj;
            int n = retObj.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IRemoteFile) {
                    selections.add(((IRemoteFile)element).getAbsolutePath());
                }
                ++n2;
            }
            return selections;
        }
        return null;
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IRemoteConnection connection) {
        this.connection = connection;
        this.connHost = ((RSEConnection)connection).getHost();
    }

    public void showConnections(boolean enable) {
        this.onlyConnection = !enable;
    }
}

