/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RSEUtils {
    public static String DEFAULT_CONFIG_DIR_NAME = ".eclipse";

    private RSEUtils() {
    }

    public static IHost getConnection(String hostName) {
        IHost[] connections;
        if (hostName == null) {
            return null;
        }
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IHost[] iHostArray = connections = sr.getHosts();
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFileSubSystem fss;
            IHost con = iHostArray[n2];
            if (hostName.equalsIgnoreCase(con.getHostName()) && (fss = RSEUtils.getRemoteFileSubSystem(con)) != null && fss.isConnected()) {
                return con;
            }
            ++n2;
        }
        return null;
    }

    public static IHost getConnection(URI uri) {
        if (!"rse".equals(uri.getScheme())) {
            return null;
        }
        String hostName = uri.getHost();
        return RSEUtils.getConnection(hostName);
    }

    public static IHost getAnyConnection(URI uri) {
        IHost[] connections;
        if (!"rse".equals(uri.getScheme())) {
            return null;
        }
        String hostName = uri.getHost();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IHost[] iHostArray = connections = sr.getHosts();
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IHost con = iHostArray[n2];
            if (hostName.equalsIgnoreCase(con.getHostName())) {
                return con;
            }
            ++n2;
        }
        return null;
    }

    public static IFileServiceSubSystem getFileServiceSubSystem(IHost host) {
        IRemoteFileSubSystem[] fileSubsystems;
        IRemoteFileSubSystem[] iRemoteFileSubSystemArray = fileSubsystems = RemoteFileUtility.getFileSubSystems((IHost)host);
        int n = fileSubsystems.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFileSubSystem subsystem = iRemoteFileSubSystemArray[n2];
            if (subsystem instanceof IFileServiceSubSystem && subsystem.isConnected()) {
                return (IFileServiceSubSystem)subsystem;
            }
            ++n2;
        }
        return null;
    }

    public static IRemoteFileSubSystem getRemoteFileSubSystem(IHost host) {
        IRemoteFileSubSystem[] fileSubsystems;
        IRemoteFileSubSystem[] iRemoteFileSubSystemArray = fileSubsystems = RemoteFileUtility.getFileSubSystems((IHost)host);
        int n = fileSubsystems.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFileSubSystem subsystem = iRemoteFileSubSystemArray[n2];
            if (subsystem != null && subsystem.isConnected()) {
                return subsystem;
            }
            ++n2;
        }
        return null;
    }

    private static IHostFile getUserHome(IHost host) {
        IFileServiceSubSystem fileSubsystem = RSEUtils.getFileServiceSubSystem(host);
        return fileSubsystem == null ? null : fileSubsystem.getFileService().getUserHome();
    }

    public static String getUserHomeDirectory(IHost host) {
        IHostFile userHome = RSEUtils.getUserHome(host);
        return userHome == null ? null : userHome.getAbsolutePath();
    }

    public static String getDefaultConfigDirectory(IHost host) {
        IHostFile userHome;
        IFileServiceSubSystem fileSubsystem = RSEUtils.getFileServiceSubSystem(host);
        try {
            fileSubsystem.connect(false, null);
        }
        catch (Exception exception) {
            return null;
        }
        if (fileSubsystem != null && (userHome = fileSubsystem.getFileService().getUserHome()) != null) {
            return String.valueOf(userHome.getAbsolutePath()) + fileSubsystem.getSeparator() + DEFAULT_CONFIG_DIR_NAME;
        }
        return null;
    }

    public static VerifyResult verifyRemoteConfigDirectory(IHost host, String path) {
        IRemoteFileSubSystem fileSubsystem = RSEUtils.getRemoteFileSubSystem(host);
        if (fileSubsystem == null) {
            return VerifyResult.ERROR;
        }
        try {
            IRemoteFile dir = fileSubsystem.getRemoteFileObject(path, (IProgressMonitor)new NullProgressMonitor());
            if (dir != null && dir.isDirectory() && dir.canWrite()) {
                return VerifyResult.VERIFIED;
            }
            return VerifyResult.INVALID;
        }
        catch (SystemMessageException systemMessageException) {
            return VerifyResult.ERROR;
        }
    }

    public static enum VerifyResult {
        VERIFIED,
        INVALID,
        ERROR;

    }
}

