/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.callhierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.rdt.ui.callhierarchy.RemoteCHViewPart;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Display;

public class CHDropTargetListener
implements DropTargetListener {
    private RemoteCHViewPart fCallHierarchy;
    private ICElement fInput;
    private boolean fEnabled = true;

    public CHDropTargetListener(RemoteCHViewPart view) {
        this.fCallHierarchy = view;
    }

    public void setEnabled(boolean val) {
        this.fEnabled = val;
    }

    public void dragEnter(DropTargetEvent event) {
        this.fInput = null;
        this.checkOperation(event);
        if (event.detail != 0 && LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            this.fInput = this.checkLocalSelection();
            if (!CallHierarchyUI.isRelevantForCallHierarchy((ICElement)this.fInput)) {
                event.detail = 0;
                this.fInput = null;
            }
        }
    }

    private ICElement checkLocalSelection() {
        ISelection sel = LocalSelectionTransfer.getTransfer().getSelection();
        if (sel instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)sel) {
                ICElement adapter;
                if (element instanceof ICElement) {
                    return (ICElement)element;
                }
                if (!(element instanceof IAdaptable) || (adapter = (ICElement)((IAdaptable)element).getAdapter(ICElement.class)) == null) continue;
                return adapter;
            }
        }
        return null;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.checkOperation(event);
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (this.fInput == null) {
            Display.getCurrent().beep();
        } else {
            this.fCallHierarchy.setInput(this.fInput);
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private void checkOperation(DropTargetEvent event) {
        event.detail = this.fEnabled && (event.operations & 1) != 0 ? 1 : 0;
    }
}

