/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.util;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.IncludePathsSettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.MacroSettingsProcessor;
import org.eclipse.core.runtime.Path;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ScannerConfigExporter {
    protected static final String NONE = "";
    protected static final String CDATA = "CDATA";
    private static IncludePathsSettingsProcessor includePathsSettingsProcessor = new IncludePathsSettingsProcessor();
    protected static final String INCLUDE_PATH_SECTION_NAME = includePathsSettingsProcessor.getSectionName();
    private static final String INCLUDE_PATH_ELEMENT = "includepath";
    private static MacroSettingsProcessor macroSettingsProcessor = new MacroSettingsProcessor();
    protected static final String MACRO_SECTION_NAME = macroSettingsProcessor.getSectionName();
    private static final String MACRO_ELEMENT = "macro";
    private static final String NAME_ELEMENT = "name";
    private static final String VALUE_ELEMENT = "value";
    private static final String C_LINKAGE_ELEMENT_NAME = "C Source File";
    private static final String CPP_LINKAGE_ELEMENT_NAME = "C++ Source File";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String LANGUAGE_ELEMENT = "language";

    public static boolean exportScannerConfiguration(String exportFileName, Map<String, IScannerInfo> scannerInfoMapByLinkage) {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = null;
        FileWriter writer = null;
        try {
            handler = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            return false;
        }
        Path path = new Path(exportFileName);
        if (!"xml".equals(path.getFileExtension())) {
            path.addFileExtension("xml");
        }
        try {
            writer = new FileWriter(path.toFile());
        }
        catch (IOException iOException) {
            return false;
        }
        handler.setResult(new StreamResult(writer));
        Transformer transformer = handler.getTransformer();
        transformer.setOutputProperty("encoding", "ISO-8859-1");
        transformer.setOutputProperty("indent", "yes");
        new AttributesImpl();
        try {
            handler.startDocument();
            ScannerConfigExporter.newline(handler);
            handler.startElement(NONE, NONE, "cdtprojectproperties", null);
            ScannerConfigExporter.newline(handler);
            ScannerConfigExporter.writeSectionXML(INCLUDE_PATH_SECTION_NAME, scannerInfoMapByLinkage, handler);
            ScannerConfigExporter.writeSectionXML(MACRO_SECTION_NAME, scannerInfoMapByLinkage, handler);
            handler.endElement(NONE, NONE, "cdtprojectproperties");
            ScannerConfigExporter.newline(handler);
            handler.endDocument();
            ScannerConfigExporter.newline(handler);
        }
        catch (SAXException sAXException) {
            return false;
        }
        return true;
    }

    private static void writeSectionXML(String sectionName, Map<String, IScannerInfo> scannerInfoMapByLinkage, TransformerHandler handler) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.clear();
        attributes.addAttribute(NONE, NONE, "name", CDATA, sectionName);
        handler.startElement(NONE, NONE, "section", attributes);
        ScannerConfigExporter.newline(handler);
        Set<String> linkages = scannerInfoMapByLinkage.keySet();
        for (String linkageidStr : linkages) {
            int linkageid = Integer.parseInt(linkageidStr);
            String languageElementName = null;
            if (linkageid == 2) {
                languageElementName = C_LINKAGE_ELEMENT_NAME;
            } else if (linkageid == 1) {
                languageElementName = CPP_LINKAGE_ELEMENT_NAME;
            }
            if (languageElementName == null) continue;
            attributes.clear();
            attributes.addAttribute(NONE, NONE, "name", CDATA, languageElementName);
            handler.startElement(NONE, NONE, LANGUAGE_ELEMENT, attributes);
            ScannerConfigExporter.newline(handler);
            IScannerInfo projScannerInfo = scannerInfoMapByLinkage.get(linkageidStr);
            if (sectionName.equals(INCLUDE_PATH_SECTION_NAME)) {
                ScannerConfigExporter.writeIncludeSettings(projScannerInfo.getIncludePaths(), handler);
            } else if (sectionName.equals(MACRO_SECTION_NAME)) {
                ScannerConfigExporter.writeMacroSettings(projScannerInfo.getDefinedSymbols(), handler);
            }
            ScannerConfigExporter.newline(handler);
            handler.endElement(NONE, NONE, LANGUAGE_ELEMENT);
            ScannerConfigExporter.newline(handler);
        }
        handler.endElement(NONE, NONE, "section");
        ScannerConfigExporter.newline(handler);
    }

    private static void writeIncludeSettings(String[] includePaths, TransformerHandler handler) throws SAXException {
        String[] stringArray = includePaths;
        int n = includePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String includePath = stringArray[n2];
            if (includePath != null) {
                handler.startElement(NONE, NONE, INCLUDE_PATH_ELEMENT, null);
                handler.characters(includePath.toCharArray(), 0, includePath.length());
                handler.endElement(NONE, NONE, INCLUDE_PATH_ELEMENT);
                ScannerConfigExporter.newline(handler);
            }
            ++n2;
        }
    }

    private static void writeMacroSettings(Map<String, String> macros, TransformerHandler handler) throws SAXException {
        for (String macroKey : macros.keySet()) {
            String macroValue;
            if (macroKey == null || (macroValue = macros.get(macroKey)) == null) continue;
            handler.startElement(NONE, NONE, MACRO_ELEMENT, null);
            ScannerConfigExporter.newline(handler);
            handler.startElement(NONE, NONE, "name", null);
            handler.characters(macroKey.toCharArray(), 0, macroKey.length());
            handler.endElement(NONE, NONE, "name");
            handler.startElement(NONE, NONE, VALUE_ELEMENT, null);
            handler.characters(macroValue.toCharArray(), 0, macroValue.length());
            handler.endElement(NONE, NONE, VALUE_ELEMENT);
            ScannerConfigExporter.newline(handler);
            handler.endElement(NONE, NONE, MACRO_ELEMENT);
            ScannerConfigExporter.newline(handler);
        }
    }

    private static void newline(ContentHandler handler) throws SAXException {
        handler.ignorableWhitespace("\n".toCharArray(), 0, 1);
    }
}

