/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.rdt.sync.core.services.SynchronizeServiceRegistry;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeServiceDescriptor;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddSyncConfigWizardPage
extends WizardPage {
    private Text fProjectLocationText;
    private Text fConfigNameText;
    private RemoteConnectionWidget fRemoteConnectioWidget;
    private Combo fSyncProviderCombo;
    private String fConfigName;
    private String fProjectLocation;
    private IRemoteConnection fSelectedConnection;
    private ISynchronizeServiceDescriptor[] fProviders;
    private ISynchronizeServiceDescriptor fSyncProvider;
    private final IProject fProject;

    public AddSyncConfigWizardPage(String pageName, IProject project) {
        super(pageName);
        this.fProject = project;
    }

    private void checkConnection() {
        IRemoteUIConnectionManager mgr = this.getUIConnectionManager();
        if (mgr != null) {
            mgr.openConnectionWithProgress(this.fRemoteConnectioWidget.getShell(), null, this.fSelectedConnection);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.AddSyncConfigWizardPage_Configuration_name);
        this.fConfigNameText = new Text(composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fConfigNameText.setLayoutData((Object)gd);
        this.fConfigNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddSyncConfigWizardPage.this.fConfigName = AddSyncConfigWizardPage.this.fConfigNameText.getText().trim();
                if (AddSyncConfigWizardPage.this.fConfigName.equals("")) {
                    AddSyncConfigWizardPage.this.fConfigName = null;
                }
                AddSyncConfigWizardPage.this.setPageComplete(AddSyncConfigWizardPage.this.validatePage());
            }
        });
        this.fRemoteConnectioWidget = new RemoteConnectionWidget(composite, 0, null, RemoteConnectionWidget.FLAG_NO_LOCAL_SELECTION);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fRemoteConnectioWidget.setLayoutData((Object)gd);
        this.fRemoteConnectioWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSyncConfigWizardPage.this.fSelectedConnection = AddSyncConfigWizardPage.this.fRemoteConnectioWidget.getConnection();
                AddSyncConfigWizardPage.this.setPageComplete(AddSyncConfigWizardPage.this.validatePage());
            }
        });
        Label projectLocationLabel = new Label(composite, 16384);
        projectLocationLabel.setText(Messages.AddSyncConfigWizardPage_Project_location);
        this.fProjectLocationText = new Text(composite, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 250;
        this.fProjectLocationText.setLayoutData((Object)gd);
        this.fProjectLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddSyncConfigWizardPage.this.fProjectLocation = AddSyncConfigWizardPage.this.fProjectLocationText.getText().trim();
                if (AddSyncConfigWizardPage.this.fProjectLocation.equals("")) {
                    AddSyncConfigWizardPage.this.fProjectLocation = null;
                }
                AddSyncConfigWizardPage.this.setPageComplete(AddSyncConfigWizardPage.this.validatePage());
            }
        });
        Button fBrowseButton = new Button(composite, 8);
        fBrowseButton.setText(Messages.AddSyncConfigWizardPage_Browse);
        fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddSyncConfigWizardPage.this.fSelectedConnection != null) {
                    IRemoteUIFileManager fileMgr;
                    IRemoteUIServices remoteUIServices;
                    AddSyncConfigWizardPage.this.checkConnection();
                    if (AddSyncConfigWizardPage.this.fSelectedConnection.isOpen() && (remoteUIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)AddSyncConfigWizardPage.this.fSelectedConnection.getRemoteServices())) != null && (fileMgr = remoteUIServices.getUIFileManager()) != null) {
                        fileMgr.setConnection(AddSyncConfigWizardPage.this.fSelectedConnection);
                        String correctPath = AddSyncConfigWizardPage.this.fProjectLocationText.getText();
                        String selectedPath = fileMgr.browseDirectory(AddSyncConfigWizardPage.this.fProjectLocationText.getShell(), NLS.bind((String)Messages.AddSyncConfigWizardPage_browse_message, (Object)AddSyncConfigWizardPage.this.fSelectedConnection.getName()), correctPath, 0);
                        if (selectedPath != null) {
                            AddSyncConfigWizardPage.this.fProjectLocationText.setText(selectedPath);
                        }
                    }
                }
            }
        });
        Label syncProviderLabel = new Label(composite, 16384);
        syncProviderLabel.setText(Messages.AddSyncConfigWizardPage_Synchronize_provider);
        this.fSyncProviderCombo = new Combo(composite, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fSyncProviderCombo.setLayoutData((Object)gd);
        this.fSyncProviderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AddSyncConfigWizardPage.this.fSyncProviderCombo.getSelectionIndex();
                if (index >= 0) {
                    AddSyncConfigWizardPage.this.fSyncProvider = AddSyncConfigWizardPage.this.fProviders[index];
                } else {
                    AddSyncConfigWizardPage.this.fSyncProvider = null;
                }
                AddSyncConfigWizardPage.this.setPageComplete(AddSyncConfigWizardPage.this.validatePage());
            }
        });
        this.initializeSyncProviders();
        this.fSyncProviderCombo.select(0);
        this.fSyncProvider = this.fProviders[0];
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    public SyncConfig getSyncConfig() {
        if (this.isPageComplete()) {
            SyncConfig config = SyncConfigManager.newConfig((String)this.fConfigName, (String)this.fSyncProvider.getId(), (String)this.fSelectedConnection.getRemoteServices().getId(), (String)this.fSelectedConnection.getName(), (String)this.fProjectLocation);
            config.setProject(this.fProject);
            return config;
        }
        return null;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        if (this.fSelectedConnection == null) {
            return null;
        }
        IRemoteUIConnectionManager connectionManager = RemoteUIServices.getRemoteUIServices((IRemoteServices)this.fSelectedConnection.getRemoteServices()).getUIConnectionManager();
        return connectionManager;
    }

    private void initializeSyncProviders() {
        ISynchronizeServiceDescriptor[] iSynchronizeServiceDescriptorArray = this.fProviders = SynchronizeServiceRegistry.getSynchronizeServiceDescriptors();
        int n = this.fProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizeServiceDescriptor provider = iSynchronizeServiceDescriptorArray[n2];
            this.fSyncProviderCombo.add(provider.getName());
            ++n2;
        }
    }

    private boolean validatePage() {
        if (this.fConfigName != null) {
            if (SyncConfigManager.getConfig((IProject)this.fProject, (String)this.fConfigName) != null) {
                this.setErrorMessage(Messages.AddSyncConfigWizardPage_Name_already_exists);
                return false;
            }
        } else {
            this.setErrorMessage(Messages.AddSyncConfigWizardPage_Name_must_be_specified);
            return false;
        }
        if (this.fProjectLocation == null || this.fSelectedConnection == null) {
            this.setErrorMessage(Messages.AddSyncConfigWizardPage_Connection_and_location_must_be_sepecified);
            return false;
        }
        if (this.fSyncProvider == null) {
            this.setErrorMessage(Messages.AddSyncConfigWizardPage_Provider_must_be_selected);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

