/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.server.dstore.core;

import java.util.Hashtable;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.rdt.server.dstore.core.Activator;
import org.osgi.framework.BundleContext;

public class ServerDebugOptions
implements DebugOptionsListener {
    public static final String DEBUG_SERVER_TRACING = "/debug/tracing";
    private static DebugTrace fDebugTrace;
    private static DebugOptions fDebugOptions;
    private static ServerDebugOptions fServerDebugOptions;

    public static void configure(BundleContext context) {
        if (fServerDebugOptions == null) {
            fServerDebugOptions = new ServerDebugOptions(context);
        }
    }

    private ServerDebugOptions(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", "org.eclipse.ptp.rdt.server.dstore");
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void optionsChanged(DebugOptions options) {
        fDebugOptions = options;
        fDebugTrace = options.newDebugTrace("org.eclipse.ptp.rdt.server.dstore");
    }

    public static boolean isDebugging() {
        return Activator.getDefault().isDebugging();
    }

    public static boolean isDebugging(String option) {
        if (fDebugOptions == null) {
            return false;
        }
        return fDebugOptions.getBooleanOption("org.eclipse.ptp.rdt.server.dstore" + option, false);
    }

    public static void setDebugging(String option, boolean value) {
        if (fDebugOptions != null) {
            if (value) {
                fDebugOptions.setDebugEnabled(true);
            }
            fDebugOptions.setOption(option, Boolean.toString(value));
        }
    }

    public static void trace(String message) {
        ServerDebugOptions.trace(null, message, new String[0]);
    }

    public static void trace(String option, String message, String ... arguments) {
        String traceMsg = message;
        if (arguments.length > 0) {
            traceMsg = NLS.bind((String)message, (Object[])arguments);
        }
        if (option != null && ServerDebugOptions.isDebugging(option) || ServerDebugOptions.isDebugging()) {
            System.out.println(traceMsg);
            if (fDebugTrace != null) {
                fDebugTrace.trace(option, traceMsg, null);
            }
        }
    }
}

