/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ptp.internal.remote.terminal.Activator;
import org.eclipse.ptp.internal.remote.terminal.IRemoteSettings;
import org.eclipse.ptp.internal.remote.terminal.RemoteConnection;
import org.eclipse.ptp.internal.remote.terminal.RemoteSettings;
import org.eclipse.ptp.internal.remote.terminal.RemoteSettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class RemoteConnector
extends TerminalConnectorImpl {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private RemoteConnection fConnection;
    private final RemoteSettings fSettings;

    public RemoteConnector() {
        this(new RemoteSettings());
    }

    public RemoteConnector(RemoteSettings settings) {
        this.fSettings = settings;
    }

    public void initialize() throws Exception {
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        this.fConnection = new RemoteConnection(this, control);
        this.fConnection.start();
    }

    public IProject getProject() {
        String projectName = this.fSettings.getProjectName();
        if (projectName != null && !"".equals(projectName.trim())) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return root.getProject(projectName);
        }
        return null;
    }

    public synchronized void doDisconnect() {
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                Activator.log(exception);
            }
        }
        if (this.getTerminalToRemoteStream() != null) {
            try {
                this.getTerminalToRemoteStream().close();
            }
            catch (Exception exception) {
                Activator.log(exception);
            }
        }
    }

    public void setTerminalSize(int newWidth, int newHeight) {
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public IRemoteSettings getSshSettings() {
        return this.fSettings;
    }

    public ISettingsPage makeSettingsPage() {
        return new RemoteSettingsPage(this.fSettings);
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }
}

