/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.builder.AbstractMarkupDocumentBuilder;

public class MarkdownDocumentBuilder
extends AbstractMarkupDocumentBuilder {
    private static final Pattern PATTERN_LINE_BREAK = Pattern.compile("(.*(\r\n|\r|\n)?)?");
    private final Map<String, String> entityToLiteral = new HashMap<String, String>();

    public MarkdownDocumentBuilder(Writer out) {
        super(out);
        this.entityToLiteral.put("amp", "&");
        this.entityToLiteral.put("lt", "<");
        this.entityToLiteral.put("gt", ">");
        this.currentBlock = null;
    }

    protected AbstractMarkupDocumentBuilder.Block computeBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        switch (type) {
            case PARAGRAPH: {
                return new ContentBlock(type, "", "\n\n");
            }
            case QUOTE: {
                return new PrefixedLineContentBlock(type, "> ", "\n");
            }
            case NUMERIC_LIST: 
            case BULLETED_LIST: {
                return new ListBlock(type, "", "\n");
            }
            case LIST_ITEM: {
                if (this.computeCurrentListType() == DocumentBuilder.BlockType.NUMERIC_LIST) {
                    return new ListItemBlock("1. ", "\n");
                }
                return new ListItemBlock("* ", "\n");
            }
            case CODE: {
                return new PrefixedLineContentBlock(type, "    ", "\n\n");
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock(type, "", "\n\n");
    }

    protected AbstractMarkupDocumentBuilder.Block computeSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        switch (type) {
            case LINK: {
                if (attributes instanceof LinkAttributes) {
                    return new LinkBlock((LinkAttributes)attributes);
                }
                return new ContentBlock("<", ">");
            }
            case EMPHASIS: 
            case ITALIC: {
                return new ContentBlock("*", "*");
            }
            case STRONG: 
            case BOLD: {
                return new ContentBlock("**", "**");
            }
            case CODE: {
                return new CodeSpan();
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock("", "");
    }

    protected AbstractMarkupDocumentBuilder.Block computeHeading(int level, Attributes attributes) {
        return new ContentBlock(String.valueOf(this.computePrefix('#', level)) + " ", "\n\n");
    }

    public void characters(String text) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void entityReference(String entity) {
        this.assertOpenBlock();
        String literal = this.entityToLiteral.get(entity);
        if (literal == null) {
            literal = "&" + entity + ";";
        }
        try {
            this.currentBlock.write(literal);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void image(Attributes attributes, String url) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(this.computeImage(attributes, url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String computeImage(Attributes attributes, String url) {
        String altText = "";
        String title = "";
        if (attributes instanceof ImageAttributes) {
            ImageAttributes imageAttr = (ImageAttributes)attributes;
            altText = Strings.nullToEmpty((String)imageAttr.getAlt());
        }
        if (!Strings.isNullOrEmpty((String)attributes.getTitle())) {
            title = " \"" + attributes.getTitle() + '\"';
        }
        return "![" + altText + "](" + Strings.nullToEmpty((String)url) + title + ')';
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.assertOpenBlock();
        LinkAttributes linkAttr = new LinkAttributes();
        linkAttr.setTitle(attributes.getTitle());
        linkAttr.setHref(hrefOrHashName);
        this.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)linkAttr);
        this.characters(text);
        this.endSpan();
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.link(linkAttributes, href, this.computeImage(imageAttributes, imageUrl));
    }

    public void acronym(String text, String definition) {
        throw new UnsupportedOperationException();
    }

    public void lineBreak() {
        this.assertOpenBlock();
        try {
            if (this.currentBlock instanceof MarkdownBlock) {
                ((MarkdownBlock)this.currentBlock).lineBreak();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractMarkupDocumentBuilder.Block createImplicitParagraphBlock() {
        return new ImplicitParagraphBlock();
    }

    private class CodeSpan
    extends ContentBlock {
        private CodeSpan() {
            super("`", "`");
        }

        @Override
        protected void emitContent(String content) throws IOException {
            if (content.contains("`")) {
                this.prefix = "`` ";
                this.suffix = " ``";
            }
            super.emitContent(content);
        }
    }

    private class ContentBlock
    extends AbstractMarkupDocumentBuilder.Block
    implements MarkdownBlock {
        protected String prefix;
        protected String suffix;

        ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix) {
            super((AbstractMarkupDocumentBuilder)MarkdownDocumentBuilder.this, blockType);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        ContentBlock(String prefix, String suffix) {
            this(null, prefix, suffix);
        }

        public void write(int c) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(c);
        }

        public void write(String s) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(s);
        }

        @Override
        public void lineBreak() throws IOException {
            this.write("  \n");
        }

        public void open() throws IOException {
            super.open();
            MarkdownDocumentBuilder.this.pushWriter(new StringWriter());
        }

        public void close() throws IOException {
            Writer thisContent = MarkdownDocumentBuilder.this.popWriter();
            String content = thisContent.toString();
            if (content.length() > 0) {
                this.emitContent(content);
            }
            super.close();
        }

        protected void emitContent(String content) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(this.prefix);
            MarkdownDocumentBuilder.this.emitContent(content);
            MarkdownDocumentBuilder.this.emitContent(this.suffix);
        }
    }

    private class ImplicitParagraphBlock
    extends ContentBlock {
        ImplicitParagraphBlock() {
            super(DocumentBuilder.BlockType.PARAGRAPH, "", "\n\n");
        }

        protected boolean isImplicitBlock() {
            return true;
        }
    }

    private class LinkBlock
    extends ContentBlock {
        private final LinkAttributes attributes;

        LinkBlock(LinkAttributes attributes) {
            super("", "");
            this.attributes = attributes;
        }

        @Override
        protected void emitContent(String content) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(91);
            MarkdownDocumentBuilder.this.emitContent(content);
            MarkdownDocumentBuilder.this.emitContent(93);
            MarkdownDocumentBuilder.this.emitContent(40);
            MarkdownDocumentBuilder.this.emitContent(this.attributes.getHref());
            if (!Strings.isNullOrEmpty((String)this.attributes.getTitle())) {
                MarkdownDocumentBuilder.this.emitContent(" \"");
                MarkdownDocumentBuilder.this.emitContent(this.attributes.getTitle());
                MarkdownDocumentBuilder.this.emitContent(34);
            }
            MarkdownDocumentBuilder.this.emitContent(41);
        }
    }

    private class ListBlock
    extends ContentBlock {
        private int count;

        ListBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix) {
            super(blockType, prefix, suffix);
            this.count = 0;
        }

        @Override
        protected void emitContent(String content) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(this.prefix);
            MarkdownDocumentBuilder.this.emitContent(content);
            if (!content.endsWith("\n\n")) {
                MarkdownDocumentBuilder.this.emitContent(this.suffix);
            }
        }

        protected void addListItem(ListItemBlock item) {
            Preconditions.checkNotNull((Object)item);
            ++this.count;
        }

        protected int getCount() {
            return this.count;
        }
    }

    private class ListItemBlock
    extends ContentBlock {
        private int count;

        private ListItemBlock(String prefix, String suffix) {
            super(DocumentBuilder.BlockType.LIST_ITEM, prefix, suffix);
        }

        @Override
        public void open() throws IOException {
            super.open();
            if (this.getPreviousBlock() instanceof ListBlock) {
                ListBlock list = (ListBlock)this.getPreviousBlock();
                list.addListItem(this);
                this.count = list.getCount();
            }
        }

        @Override
        protected void emitContent(String content) throws IOException {
            if (this.getPreviousBlock().getBlockType() == DocumentBuilder.BlockType.NUMERIC_LIST) {
                this.prefix = String.valueOf(this.count) + ". ";
            }
            MarkdownDocumentBuilder.this.emitContent(this.prefix);
            Matcher matcher = PATTERN_LINE_BREAK.matcher(content);
            int lines = 0;
            while (matcher.find()) {
                String line = matcher.group(0);
                if (lines > 0 && !line.trim().isEmpty()) {
                    line = "    " + line;
                }
                MarkdownDocumentBuilder.this.emitContent(line);
                ++lines;
            }
            if (!content.endsWith(this.suffix)) {
                MarkdownDocumentBuilder.this.emitContent(this.suffix);
            }
        }
    }

    private static interface MarkdownBlock {
        public void lineBreak() throws IOException;
    }

    private class PrefixedLineContentBlock
    extends ContentBlock {
        PrefixedLineContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix) {
            super(blockType, prefix, suffix);
        }

        @Override
        protected void emitContent(String content) throws IOException {
            char lastChar = MarkdownDocumentBuilder.this.getLastChar();
            if (lastChar != '\n' && lastChar != '\r' && lastChar != '\u0000') {
                MarkdownDocumentBuilder.this.emitContent(10);
            }
            Matcher matcher = PATTERN_LINE_BREAK.matcher(content);
            while (matcher.find()) {
                String line = matcher.group(0);
                if (!line.trim().isEmpty()) {
                    MarkdownDocumentBuilder.this.emitContent(this.prefix);
                }
                MarkdownDocumentBuilder.this.emitContent(line);
            }
            if (!content.endsWith(this.suffix)) {
                MarkdownDocumentBuilder.this.emitContent(this.suffix);
            }
        }
    }
}

