/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.ui.module;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.linuxtools.tmf.analysis.xml.ui.module.TmfXmlAnalysisOutputSource;
import org.eclipse.linuxtools.tmf.ui.analysis.TmfAnalysisViewOutput;
import org.w3c.dom.Element;

public class TmfXmlViewOutput
extends TmfAnalysisViewOutput {
    private String fLabel = null;
    @NonNull
    private final TmfXmlAnalysisOutputSource.ViewType fViewType;

    public TmfXmlViewOutput(String viewid) {
        this(viewid, TmfXmlAnalysisOutputSource.ViewType.TIME_GRAPH_VIEW);
    }

    public TmfXmlViewOutput(String viewid, @NonNull TmfXmlAnalysisOutputSource.ViewType viewType) {
        super(viewid);
        this.fViewType = viewType;
    }

    public String getName() {
        if (this.fLabel == null) {
            return super.getName();
        }
        return this.fLabel;
    }

    public void setOutputProperty(@NonNull String key, String value, boolean immediate) {
        super.setOutputProperty(key, value, immediate);
        if (key.equals("xmlOutputData")) {
            String filePath;
            String[] idFile = value.split(";;;");
            String viewId = idFile.length > 0 ? idFile[0] : null;
            String string = filePath = idFile.length > 1 ? idFile[1] : null;
            if (viewId == null || filePath == null) {
                return;
            }
            Element viewElement = XmlUtils.getElementInFile((String)filePath, (String)this.fViewType.getXmlElem(), (String)viewId);
            if (viewElement == null) {
                return;
            }
            List heads = XmlUtils.getChildElements((Element)viewElement, (String)"head");
            if (heads.size() != 1) {
                return;
            }
            Element headElement = (Element)heads.get(0);
            List label = XmlUtils.getChildElements((Element)headElement, (String)"label");
            if (label.isEmpty()) {
                return;
            }
            Element labelElement = (Element)label.get(0);
            this.fLabel = labelElement.getAttribute("value");
        }
    }
}

