/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.commands;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.mylyn.internal.wikitext.ui.commands.Messages;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.ServiceLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class WikiMarkupGenerationContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    protected IContributionItem[] getContributionItems() {
        TreeMap<String, CommandContributionItem> items = new TreeMap<String, CommandContributionItem>();
        for (MarkupLanguage markupLanguage : ServiceLocator.getInstance().getAllMarkupLanguages()) {
            try {
                markupLanguage.createDocumentBuilder((Writer)new StringWriter());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
            String commandId = "org.eclipse.mylyn.wikitext.ui.convertToMarkupCommand";
            String id = String.valueOf(commandId) + '.' + markupLanguage.getName().replaceAll("\\W", "_");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("org.eclipse.mylyn.wikitext.ui.targetLanguage", markupLanguage.getName());
            CommandContributionItemParameter parameters = new CommandContributionItemParameter(this.serviceLocator, id, commandId, 8);
            parameters.label = NLS.bind((String)Messages.WikiMarkupGenerationContribution_generate_markup, (Object)markupLanguage.getName());
            parameters.parameters = args;
            items.put(markupLanguage.getName(), new CommandContributionItem(parameters));
        }
        return items.values().toArray(new IContributionItem[items.size()]);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

