/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.widgets;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.files.ui.widgets.SystemQualifiedRemoteFolderCombo;
import org.eclipse.rse.internal.files.ui.actions.SystemSelectFileTypesAction;
import org.eclipse.rse.internal.files.ui.widgets.SystemFileTreeAndListGroup;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemViewLabelAndContentProvider;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileRoot;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemSelectRemoteFilesForm
extends Composite {
    private SystemQualifiedRemoteFolderCombo dirCombo = null;
    private SystemFileTreeAndListGroup fileSelector = null;
    private RemoteFileRoot rootElement = null;
    private Button selectTypesButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private String historyKey = null;
    private boolean showSelectTypesButton;
    private boolean showSelectAllButtons = false;
    private ISystemMessageLine msgLine = null;
    private List selectedTypes = new ArrayList();
    private String filterString = null;
    private SystemSelectFileTypesAction typesAction = null;
    private SystemViewLabelAndContentProvider folderProvider;
    private SystemViewLabelAndContentProvider fileProvider;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;

    public SystemSelectRemoteFilesForm(Composite parent, int style, boolean showSelectTypesButton, boolean showSelectAllButtons, String key) {
        super(parent, style);
        this.showSelectTypesButton = showSelectTypesButton;
        this.showSelectAllButtons = showSelectAllButtons;
        this.historyKey = key;
        this.prepareComposite(1);
        this.createFolderPrompt(this);
        this.createFilesSelectorGroup(this);
        if (showSelectTypesButton || showSelectAllButtons) {
            this.createButtons(this, showSelectTypesButton, showSelectAllButtons);
        }
        this.addOurQualifiedFolderSelectionListener();
    }

    public SystemSelectRemoteFilesForm(Composite parent, int style, boolean showSelectTypesButton, boolean showSelectAllButtons) {
        this(parent, style, showSelectTypesButton, showSelectAllButtons, null);
    }

    public SystemSelectRemoteFilesForm(Composite parent, int style) {
        this(parent, style, true, true, null);
    }

    public void setMessageLine(ISystemMessageLine msgLine) {
        this.msgLine = msgLine;
    }

    public ISystemMessageLine getMessageLine() {
        return this.msgLine;
    }

    public void setSystemTypes(IRSESystemType[] systemTypes) {
        this.dirCombo.setSystemTypes(systemTypes);
    }

    public void setSystemType(IRSESystemType systemType) {
        if (systemType == null) {
            this.setSystemTypes(null);
        } else {
            this.setSystemTypes(new IRSESystemType[]{systemType});
        }
    }

    public void setFilterString(String filterString) {
        this.fileProvider.setFilterString(filterString);
        this.folderProvider.setFilterString(filterString);
        this.refresh();
    }

    public String getFilterString() {
        return this.filterString;
    }

    public SystemQualifiedRemoteFolderCombo getFolderCombo() {
        return this.dirCombo;
    }

    public void setEnabled(boolean enabled) {
        this.dirCombo.setEnabled(enabled);
        this.fileSelector.getListTable().setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.dirCombo.setFocus();
    }

    public void clearAll() {
        this.fileSelector.clearAll();
        this.enableButtonGroup(false);
    }

    public void setRootFolder(IRemoteFile rootFolder) {
        this.rootElement.setRootFile(rootFolder);
        this.fileSelector.setRoot(this.rootElement);
        this.enableButtonGroup(true);
    }

    public void refresh() {
        this.folderProvider.flushCache();
        this.fileProvider.flushCache();
        this.fileSelector.refresh();
    }

    public void addCheckStateListener(ICheckStateListener l) {
        this.fileSelector.addCheckStateListener(l);
    }

    public void removeCheckStateListener(ICheckStateListener l) {
        this.fileSelector.removeCheckStateListener(l);
    }

    public IRemoteFile[] getSelectedFiles() {
        List list = this.fileSelector.getAllCheckedListItems();
        IRemoteFile[] files = new IRemoteFile[list.size()];
        Iterator i = list.iterator();
        int idx = 0;
        while (i.hasNext()) {
            files[idx++] = (IRemoteFile)i.next();
        }
        return files;
    }

    protected Composite prepareComposite(int numColumns) {
        SystemSelectRemoteFilesForm composite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData(data);
        return composite;
    }

    protected void createFolderPrompt(Composite parent) {
        this.dirCombo = new SystemQualifiedRemoteFolderCombo(parent, 0, this.historyKey);
    }

    protected void createFilesSelectorGroup(Composite parent) {
        this.folderProvider = new SystemViewLabelAndContentProvider(true, false);
        this.fileProvider = new SystemViewLabelAndContentProvider(false, true);
        this.rootElement = new RemoteFileRoot();
        this.fileSelector = new SystemFileTreeAndListGroup(parent, (ITreeContentProvider)this.folderProvider, (ILabelProvider)this.folderProvider, (IStructuredContentProvider)this.fileProvider, (ILabelProvider)this.fileProvider, 0, 400, 150);
    }

    protected void createButtons(Composite parent, boolean showSelectTypes, boolean showSelectAll) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = showSelectTypes && showSelectAll ? 3 : (showSelectTypes ? 1 : 2);
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        if (showSelectTypes) {
            this.selectTypesButton = SystemSelectRemoteFilesForm.createPushButton(buttonComposite, SystemResources.RESID_SELECTFILES_SELECTTYPES_BUTTON_ROOT_LABEL, SystemResources.RESID_SELECTFILES_SELECTTYPES_BUTTON_ROOT_TOOLTIP);
            this.addSelectTypesButtonSelectionListener();
        }
        if (showSelectAll) {
            this.selectAllButton = SystemSelectRemoteFilesForm.createPushButton(buttonComposite, SystemResources.RESID_SELECTFILES_SELECTALL_BUTTON_ROOT_LABEL);
            this.deselectAllButton = SystemSelectRemoteFilesForm.createPushButton(buttonComposite, SystemResources.RESID_SELECTFILES_DESELECTALL_BUTTON_ROOT_TOOLTIP);
            this.addSelectAllButtonSelectionListener();
            this.addDeselectAllButtonSelectionListener();
        }
        this.enableButtonGroup(false);
    }

    protected static Button createPushButton(Composite group, String label, String tooltip) {
        Button button = SystemSelectRemoteFilesForm.createPushButton(group, label);
        button.setToolTipText(tooltip);
        return button;
    }

    public static Button createPushButton(Composite group, String label) {
        Button button = new Button(group, 8);
        button.setText(label);
        GridData data = new GridData(768);
        button.setLayoutData((Object)data);
        return button;
    }

    protected void addOurQualifiedFolderSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemSelectRemoteFilesForm.this.clearErrorMessage();
                IRemoteFile selectedFolder = null;
                try {
                    selectedFolder = SystemSelectRemoteFilesForm.this.dirCombo.getFolder();
                    if (selectedFolder == null) {
                        SystemSelectRemoteFilesForm.this.clearAll();
                    } else {
                        SystemSelectRemoteFilesForm.this.setRootFolder(selectedFolder);
                    }
                }
                catch (Exception exc) {
                    String msg = exc.getMessage();
                    if (msg == null || msg.length() == 0) {
                        msg = "Exception: " + exc.getClass().getName();
                        SystemSelectRemoteFilesForm.this.displayExceptionMessage(exc);
                    } else {
                        SystemSelectRemoteFilesForm.this.displayErrorMessage(msg);
                    }
                    SystemSelectRemoteFilesForm.this.clearAll();
                }
            }
        };
        this.dirCombo.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void addSelectTypesButtonSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemSelectRemoteFilesForm.this.handleTypesEditButtonPressed();
            }
        };
        this.selectTypesButton.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void addSelectAllButtonSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemSelectRemoteFilesForm.this.fileSelector.setAllSelections(true);
            }
        };
        this.selectAllButton.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void addDeselectAllButtonSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemSelectRemoteFilesForm.this.fileSelector.setAllSelections(false);
            }
        };
        this.deselectAllButton.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void handleTypesEditButtonPressed() {
        SystemSelectFileTypesAction typesAction = this.getSelectTypesAction();
        typesAction.setTypes(this.selectedTypes);
        typesAction.run();
        if (!typesAction.wasCancelled()) {
            this.selectedTypes = typesAction.getTypes();
            this.setupSelectionsBasedOnSelectedTypes();
        }
    }

    private SystemSelectFileTypesAction getSelectTypesAction() {
        if (this.typesAction == null) {
            this.typesAction = new SystemSelectFileTypesAction(this.getShell());
        }
        return this.typesAction;
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
        Hashtable selectionMap = new Hashtable();
        IRemoteFile[] filesList = this.getSelectedFiles();
        int idx = 0;
        while (idx < filesList.length) {
            IRemoteFile file = filesList[idx];
            String extension = file.getExtension();
            if (this.isExportableExtension(extension)) {
                List<Object> elements = new ArrayList<IRemoteFile>();
                IRemoteFile parent = file.getParentRemoteFile();
                if (selectionMap.containsKey(parent)) {
                    elements = (List)selectionMap.get(parent);
                }
                elements.add(file);
                selectionMap.put(parent, elements);
            }
            ++idx;
        }
        this.fileSelector.updateSelections(selectionMap);
    }

    protected boolean isExportableExtension(String extension) {
        if (this.selectedTypes == null) {
            return true;
        }
        Iterator enumer = this.selectedTypes.iterator();
        while (enumer.hasNext()) {
            if (!extension.equalsIgnoreCase((String)enumer.next())) continue;
            return true;
        }
        return false;
    }

    protected void enableButtonGroup(boolean enable) {
        if (!this.showSelectTypesButton && !this.showSelectAllButtons) {
            return;
        }
        if (this.selectTypesButton != null) {
            this.selectTypesButton.setEnabled(enable);
        }
        if (this.selectAllButton != null) {
            this.selectAllButton.setEnabled(enable);
        }
        if (this.deselectAllButton != null) {
            this.deselectAllButton.setEnabled(enable);
        }
    }

    protected void clearErrorMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearErrorMessage();
        }
    }

    protected void displayErrorMessage(String msgText) {
        if (this.msgLine != null) {
            this.msgLine.setErrorMessage(msgText);
        } else {
            SystemMessageDialog.displayErrorMessage((Shell)this.getShell(), (String)msgText);
        }
    }

    protected void displayErrorMessage(SystemMessage msg) {
        if (this.msgLine != null) {
            this.msgLine.setErrorMessage(msg);
        } else {
            SystemMessageDialog.displayErrorMessage((Shell)this.getShell(), (SystemMessage)msg);
        }
    }

    protected void displayExceptionMessage(Exception exc) {
        if (this.msgLine != null) {
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1003", 4, CommonMessages.MSG_EXCEPTION_OCCURRED, (Throwable)exc);
            this.msgLine.setErrorMessage((SystemMessage)msg);
        } else {
            SystemMessageDialog.displayExceptionMessage((Shell)this.getShell(), (Throwable)exc);
        }
    }
}

