/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.files.ui.actions.SystemNewFileFilterAction;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;
import org.eclipse.rse.ui.filters.dialogs.SystemNewFilterWizard;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemNewFileFilterFromFolderAction
extends SystemNewFileFilterAction {
    private RemoteFile _selected;

    public SystemNewFileFilterFromFolderAction(Shell parent) {
        super(null, null, parent);
        this.setHelp("org.eclipse.rse.ui.actn0112");
    }

    public void run() {
        IRemoteFileSubSystem fileSubsystem = this._selected.getParentRemoteFileSubSystem();
        ISystemFilterPool defaultFilterPool = ((SubSystem)fileSubsystem).getConnectionPrivateFilterPool(true);
        if (defaultFilterPool == null) {
            ISystemFilterPoolManager mgr = fileSubsystem.getFilterPoolReferenceManager().getDefaultSystemFilterPoolManager();
            defaultFilterPool = mgr.getFirstDefaultSystemFilterPool();
        }
        this.setParentFilterPool(defaultFilterPool);
        this.setAllowFilterPoolSelection(fileSubsystem.getFilterPoolReferenceManager().getReferencedSystemFilterPools());
        super.run();
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = false;
        Iterator e = selection.iterator();
        Object selected = e.next();
        if (selected != null && selected instanceof IRemoteFile) {
            this._selected = (RemoteFile)selected;
            enable = true;
        }
        return enable;
    }

    public ISystemFilterPoolReferenceManagerProvider getSystemFilterPoolReferenceManagerProvider() {
        return this._selected.getParentRemoteFileSubSystem().getFilterPoolReferenceManager().getProvider();
    }

    protected void configureNewFilterWizard(SystemNewFilterWizard wizard) {
        super.configureNewFilterWizard(wizard);
        String[] filters = new String[1];
        ISystemRemoteElementAdapter adapter = (ISystemRemoteElementAdapter)this._selected.getAdapter(ISystemRemoteElementAdapter.class);
        filters[0] = adapter.getFilterStringFor((Object)this._selected);
        wizard.setDefaultFilterStrings(filters);
    }
}

