/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.lttng2.control.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs.INewConnectionDialog;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NewConnectionDialog
extends Dialog
implements INewConnectionDialog {
    private static final String TARGET_NEW_CONNECTION_ICON_FILE = "icons/elcl16/target_add.gif";
    private static final String PROVIDERS_ICON_FILE = "icons/obj16/providers.gif";
    private static final String CONNECTION_ICON_FILE = "icons/obj16/target_connected.gif";
    private TreeViewer fConnectionTree = null;
    private Button fNewButton = null;
    private Button fEditButton = null;
    private IRemoteConnection fConnection;

    public NewConnectionDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_NewDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(TARGET_NEW_CONNECTION_ICON_FILE));
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.fConnectionTree.setAutoExpandLevel(2);
        this.fConnectionTree.setInput((Object)this);
        List providers = ConnectionContentProvider.getProviders();
        if (!providers.isEmpty()) {
            IRemoteServices provider = (IRemoteServices)providers.get(0);
            IRemoteConnection[] connections = ConnectionContentProvider.getConnections(provider);
            if (connections.length > 0) {
                this.fConnectionTree.setSelection((ISelection)new StructuredSelection((Object)connections[0]));
            } else {
                this.fConnectionTree.setSelection((ISelection)new StructuredSelection((Object)provider));
            }
        } else {
            this.onSelectionChanged();
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        dialogComposite.setLayout((Layout)layout);
        dialogComposite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(dialogComposite, 0);
        label.setText(Messages.TraceControl_NewNodeExistingConnectionGroupName);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        gd.widthHint = label.computeSize((int)-1, (int)-1).x + this.convertWidthInCharsToPixels(4);
        this.fConnectionTree = new TreeViewer(dialogComposite);
        gd = new GridData(4, 4, true, true);
        this.fConnectionTree.getTree().setLayoutData((Object)gd);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        this.fConnectionTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IRemoteConnection) {
                    IRemoteConnection rc = (IRemoteConnection)element;
                    if (rc.getRemoteServices() == RemoteServices.getLocalServices()) {
                        return rc.getName();
                    }
                    return MessageFormat.format("{0} [{1}]", rc.getName(), rc.getAddress());
                }
                if (element instanceof IRemoteServices) {
                    IRemoteServices rs = (IRemoteServices)element;
                    return rs.getName();
                }
                return Messages.TraceControl_UnknownNode;
            }

            public Image getImage(Object element) {
                if (element instanceof IRemoteConnection) {
                    return Activator.getDefault().loadIcon(NewConnectionDialog.CONNECTION_ICON_FILE);
                }
                return Activator.getDefault().loadIcon(NewConnectionDialog.PROVIDERS_ICON_FILE);
            }
        });
        this.fConnectionTree.setContentProvider((IContentProvider)new ConnectionContentProvider());
        this.fConnectionTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewConnectionDialog.this.onSelectionChanged();
            }
        });
        this.fConnectionTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NewConnectionDialog.this.okPressed();
            }
        });
        Composite buttons = new Composite(dialogComposite, 0);
        layout = new GridLayout(3, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        new Label(buttons, 0);
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(Messages.TraceControl_NewNodeEditButtonName);
        this.setButtonLayoutData(this.fEditButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConnectionDialog.this.onEditConnection();
            }
        });
        this.fNewButton = new Button(buttons, 8);
        this.fNewButton.setText(Messages.TraceControl_NewNodeCreateButtonText);
        this.setButtonLayoutData(this.fNewButton);
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConnectionDialog.this.onNewConnection();
            }
        });
        return dialogComposite;
    }

    private void onSelectionChanged() {
        this.setConnection();
        this.getButton(0).setEnabled(this.fConnection != null);
        this.fEditButton.setEnabled(NewConnectionDialog.canEdit(this.fConnection));
        this.fNewButton.setEnabled(this.getServiceForCreation() != null);
    }

    private IRemoteServices getServiceForCreation() {
        Object o = ((IStructuredSelection)this.fConnectionTree.getSelection()).getFirstElement();
        IRemoteServices result = null;
        if (o instanceof IRemoteServices) {
            result = (IRemoteServices)o;
        } else if (o instanceof IRemoteConnection) {
            result = ((IRemoteConnection)o).getRemoteServices();
        } else {
            return null;
        }
        if ((result.getCapabilities() & 1) == 0) {
            return null;
        }
        return result;
    }

    private static boolean canEdit(IRemoteConnection conn) {
        if (conn == null) {
            return false;
        }
        IRemoteServices rs = conn.getRemoteServices();
        return (rs.getCapabilities() & 2) != 0;
    }

    private void onNewConnection() {
        IRemoteConnection conn;
        IRemoteConnectionWorkingCopy wc;
        IRemoteUIConnectionWizard wiz;
        IRemoteUIServices uiService;
        IRemoteServices rs = this.getServiceForCreation();
        if (rs != null && (uiService = RemoteUIServices.getRemoteUIServices((IRemoteServices)rs)) != null && (wiz = uiService.getUIConnectionManager().getConnectionWizard(this.getShell())) != null && (wc = wiz.open()) != null && (conn = wc.save()) != null) {
            this.fConnectionTree.refresh();
            this.fConnectionTree.setSelection((ISelection)new StructuredSelection((Object)conn), true);
        }
    }

    private void onEditConnection() {
        IRemoteUIConnectionManager connManager;
        IRemoteUIServices ui;
        this.setConnection();
        if (this.fConnection != null && (ui = RemoteUIServices.getRemoteUIServices((IRemoteServices)this.fConnection.getRemoteServices())) != null && (connManager = ui.getUIConnectionManager()) != null) {
            IRemoteUIConnectionWizard wiz = connManager.getConnectionWizard(this.getShell());
            wiz.setConnection(this.fConnection.getWorkingCopy());
            IRemoteConnectionWorkingCopy result = wiz.open();
            if (result != null) {
                result.save();
                this.fConnectionTree.refresh();
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        this.setConnection();
        if (this.fConnection != null) {
            super.okPressed();
        }
    }

    private void setConnection() {
        Object o = ((IStructuredSelection)this.fConnectionTree.getSelection()).getFirstElement();
        this.fConnection = o instanceof IRemoteConnection ? (IRemoteConnection)o : null;
    }

    @Override
    public IRemoteConnection getConnection() {
        return this.fConnection;
    }

    private static final class ConnectionContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_CHILDREN = new Object[0];
        private static List<IRemoteServices> fProviders;

        private ConnectionContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IRemoteServices> children = new ArrayList<IRemoteServices>();
            children.addAll(RemoteServices.getLocalServices().getConnectionManager().getConnections());
            List<IRemoteServices> result = ConnectionContentProvider.getProviders();
            children.addAll(result);
            return children.toArray();
        }

        private static List<IRemoteServices> getProviders() {
            if (fProviders == null) {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.remote.core", "remoteServices");
                ArrayList<IRemoteServices> result = new ArrayList<IRemoteServices>();
                if (extensionPoint != null) {
                    HashSet<String> handled = new HashSet<String>();
                    handled.add(RemoteServices.getLocalServices().getId());
                    IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
                    int n = iConfigurationElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRemoteServices service;
                        IConfigurationElement ce = iConfigurationElementArray[n2];
                        String id = ce.getAttribute("id");
                        if (handled.add(id) && (service = RemoteServices.getRemoteServices((String)id)) != null) {
                            result.add(service);
                        }
                        ++n2;
                    }
                    Collections.sort(result);
                }
                fProviders = Collections.unmodifiableList(result);
            }
            return fProviders;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IRemoteServices) {
                return ConnectionContentProvider.getConnections((IRemoteServices)parentElement);
            }
            return NO_CHILDREN;
        }

        private static IRemoteConnection[] getConnections(IRemoteServices parentElement) {
            List connectionList = parentElement.getConnectionManager().getConnections();
            Object[] result = connectionList.toArray(new IRemoteConnection[connectionList.size()]);
            Arrays.sort(result);
            return result;
        }

        public Object getParent(Object element) {
            if (element instanceof IRemoteConnection) {
                return ((IRemoteConnection)element).getRemoteServices();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }
}

