/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.linuxtools.internal.lttng2.control.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.dialogs.ISelectCommandScriptDialog;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class OpenCommandScriptDialog
extends Dialog
implements ISelectCommandScriptDialog {
    public static final String CREATE_SESSION_ICON_FILE = "icons/elcl16/add_button.gif";
    private static final String DIALOG_SETTINGS_SECTION = "OpenCommandScriptDialog";
    private static final String FILE_NAME_ID = "STORE_FILE_NAME_ID";
    private static final int COMBO_HISTORY_LENGTH = 5;
    private Control fControl = null;
    private Composite fDialogComposite = null;
    private Button fBrowseButton;
    private Label fFileNameLabel = null;
    private Combo fFileNameCombo = null;
    private List<String> fCommands = null;

    public OpenCommandScriptDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    @NonNull
    public List<String> getCommands() {
        if (this.fCommands != null) {
            return this.fCommands;
        }
        return new ArrayList<String>();
    }

    protected Control createContents(Composite parent) {
        this.fControl = super.createContents(parent);
        Point clientArea = this.fControl.computeSize(-1, -1);
        Rectangle trim = this.getShell().computeTrim(0, 0, clientArea.x, clientArea.y);
        this.getShell().setMinimumSize(trim.width, trim.height);
        return this.fControl;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_ExecuteScriptDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(CREATE_SESSION_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        Group sessionGroup = new Group(this.fDialogComposite, 32);
        sessionGroup.setLayoutData((Object)new GridData(768));
        sessionGroup.setLayout((Layout)new GridLayout(6, true));
        this.fFileNameLabel = new Label((Composite)sessionGroup, 131072);
        this.fFileNameLabel.setText(Messages.TraceControl_ExecuteScriptSelectLabel);
        this.fFileNameCombo = new Combo((Composite)sessionGroup, 2048);
        this.fBrowseButton = new Button((Composite)sessionGroup, 8);
        this.fBrowseButton.setText(Messages.TraceControl_ExecuteScriptBrowseText);
        this.fBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OpenCommandScriptDialog.this.handleFilePathBrowseButtonPressed(4096);
            }
        });
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = false;
        this.fFileNameLabel.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 4;
        this.fFileNameCombo.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.fCommands = new ArrayList<String>();
        this.restoreWidgetValues();
        return this.fDialogComposite;
    }

    private void restoreWidgetValues() {
        String[] fileNames;
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        if ((fileNames = settings.getArray(FILE_NAME_ID)) != null && fileNames.length != 0) {
            int i = 0;
            while (i < fileNames.length) {
                this.fFileNameCombo.add(fileNames[i]);
                ++i;
            }
        }
    }

    private void saveWidgetValues() {
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (settings != null) {
            String[] fileNames = settings.getArray(FILE_NAME_ID);
            if (fileNames == null) {
                fileNames = new String[]{};
            }
            fileNames = OpenCommandScriptDialog.addToHistory(fileNames, this.fFileNameCombo.getText().trim());
            settings.put(FILE_NAME_ID, fileNames);
        }
    }

    private static String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(history));
        list.remove(newEntry);
        list.add(0, newEntry);
        if (list.size() > 5) {
            list.remove(5);
        }
        String[] r = new String[list.size()];
        list.toArray(r);
        return r;
    }

    private void handleFilePathBrowseButtonPressed(int fileDialogStyle) {
        FileDialog dialog = new FileDialog(this.getShell(), fileDialogStyle | 0x10000000);
        dialog.setFilterExtensions(new String[]{"*.*", "*.*"});
        dialog.setText(Messages.TraceControl_ExecuteScriptDialogTitle);
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.fFileNameCombo.setText(selectedFileName);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        String sessionPath = this.fFileNameCombo.getText();
        if (!"".equals(sessionPath)) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(sessionPath, "r");){
                    String line = rafile.getNextLine();
                    while (line != null) {
                        builder.add((Object)line);
                        line = rafile.getNextLine();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)new Status(4, "org.eclipse.linuxtools.lttng2.control.ui", 4, e.getLocalizedMessage(), (Throwable)e));
                return;
            }
            this.saveWidgetValues();
            this.fCommands = builder.build();
            super.okPressed();
        }
    }
}

