/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.ui.views.service;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.IFieldInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.ISnapshotInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.IUstProviderInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.impl.BaseEventInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.impl.DomainInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.impl.FieldInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.impl.SessionInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.impl.SnapshotInfo;
import org.eclipse.linuxtools.internal.lttng2.control.core.model.impl.UstProviderInfo;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.handlers.XmlMiValidationErrorHandler;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.ICommandResult;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.service.LTTngControlService;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.service.LTTngControlServiceConstants;
import org.eclipse.linuxtools.internal.lttng2.control.ui.views.service.LttngVersion;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LTTngControlServiceMI
extends LTTngControlService {
    private final DocumentBuilder fDocumentBuilder;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$linuxtools$internal$lttng2$control$core$model$TraceEventType;

    public LTTngControlServiceMI(ICommandShell shell, URL xsdUrl) throws ExecutionException {
        super(shell);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        try {
            this.fDocumentBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ExecutionException(Messages.TraceControl_XmlDocumentBuilderError, (Throwable)e);
        }
        this.fDocumentBuilder.setErrorHandler(new XmlMiValidationErrorHandler());
    }

    private Document getDocumentFromStrings(String[] xmlStrings) throws ExecutionException {
        Document document;
        StringBuilder concatenedString = new StringBuilder();
        String[] stringArray = xmlStrings;
        int n = xmlStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            concatenedString.append(string);
            ++n2;
        }
        InputSource stream = new InputSource(new StringReader(concatenedString.toString()));
        try {
            document = this.fDocumentBuilder.parse(stream);
        }
        catch (IOException | SAXException e) {
            throw new ExecutionException(Messages.TraceControl_XmlParsingError, (Throwable)e);
        }
        return document;
    }

    public void setVersion(String[] xmlOutput) throws ExecutionException {
        String fullVersion;
        String url;
        String description;
        String name;
        String commit;
        String license;
        int patchLevel;
        int minor;
        int major;
        block34: {
            block32: {
                Document doc = this.getDocumentFromStrings(xmlOutput);
                NodeList element = doc.getElementsByTagName("version");
                major = 0;
                minor = 0;
                patchLevel = 0;
                license = "";
                commit = "";
                name = "";
                description = "";
                url = "";
                fullVersion = "";
                if (element.getLength() != 1) break block32;
                NodeList child = element.item(0).getChildNodes();
                int i = 0;
                while (i < child.getLength()) {
                    Node node = child.item(i);
                    switch (node.getNodeName()) {
                        case "major": {
                            major = Integer.parseInt(node.getTextContent());
                            break;
                        }
                        case "minor": {
                            minor = Integer.parseInt(node.getTextContent());
                            break;
                        }
                        case "patchLevel": {
                            patchLevel = Integer.parseInt(node.getTextContent());
                            break;
                        }
                        case "commit": {
                            commit = node.getTextContent();
                            break;
                        }
                        case "description": {
                            description = node.getTextContent();
                            break;
                        }
                        case "license": {
                            license = node.getTextContent();
                            break;
                        }
                        case "name": {
                            name = node.getTextContent();
                            break;
                        }
                        case "string": {
                            fullVersion = node.getTextContent();
                            break;
                        }
                        case "url": {
                            url = node.getTextContent();
                            break;
                        }
                    }
                    ++i;
                }
                break block34;
            }
            throw new ExecutionException(Messages.TraceControl_UnsupportedVersionError);
        }
        this.setVersion(new LttngVersion(major, minor, patchLevel, license, commit, name, description, url, fullVersion));
    }

    @Override
    public String[] getSessionNames(IProgressMonitor monitor) throws ExecutionException {
        List<String> command = this.createCommand("list");
        ICommandResult result = this.executeCommand(command, monitor);
        Document doc = this.getDocumentFromStrings(result.getOutput());
        NodeList elements = doc.getElementsByTagName("name");
        ArrayList<String> retArray = new ArrayList<String>();
        int i = 0;
        while (i < elements.getLength()) {
            Node node = elements.item(i);
            if (node.getParentNode().getNodeName().equalsIgnoreCase("session")) {
                retArray.add(node.getTextContent());
            }
            ++i;
        }
        return retArray.toArray(new String[retArray.size()]);
    }

    @Override
    public ISessionInfo getSession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        List<String> command = this.createCommand("list", sessionName);
        ICommandResult result = this.executeCommand(command, monitor);
        SessionInfo sessionInfo = new SessionInfo(sessionName);
        Document document = this.getDocumentFromStrings(result.getOutput());
        NodeList sessionsNode = document.getElementsByTagName("session");
        if (sessionsNode.getLength() != 1) {
            throw new ExecutionException(NLS.bind((String)Messages.TraceControl_MiInvalidNumberOfElementError, (Object)"session"));
        }
        Node rawSession = sessionsNode.item(0);
        this.parseSession((ISessionInfo)sessionInfo, rawSession);
        if (sessionInfo.isSnapshotSession()) {
            ISnapshotInfo snapshot = this.getSnapshotInfo(sessionName, monitor);
            sessionInfo.setSnapshotInfo(snapshot);
        }
        return sessionInfo;
    }

    /*
     * Exception decompiling
     */
    private void parseSession(ISessionInfo sessionInfo, Node rawSession) throws ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl73 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl73 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IDomainInfo parseDomain(Node rawDomain) throws ExecutionException {
        DomainInfo domain = null;
        Node rawType = LTTngControlServiceMI.getFirstOf(rawDomain.getChildNodes(), "type");
        if (rawType == null) {
            throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
        }
        String rawTypeString = rawType.getTextContent().toLowerCase();
        TraceDomainType domainType = TraceDomainType.valueOfString((String)rawTypeString);
        switch (domainType) {
            case KERNEL: {
                domain = new DomainInfo(Messages.TraceControl_KernelProviderDisplayName);
                domain.setIsKernel(true);
                break;
            }
            case UST: {
                domain = new DomainInfo(Messages.TraceControl_UstGlobalDomainDisplayName);
                domain.setIsKernel(false);
                break;
            }
            case JUL: {
                domain = new DomainInfo(Messages.TraceControl_JULDomainDisplayName);
                domain.setIsKernel(false);
                break;
            }
            case UNKNOWN: {
                domain = new DomainInfo(Messages.TraceControl_UnknownDomainDisplayName);
                domain.setIsKernel(false);
                break;
            }
            default: {
                throw new ExecutionException(Messages.TraceControl_MiInvalidElementError);
            }
        }
        NodeList rawInfos = rawDomain.getChildNodes();
        int i = 0;
        while (i < rawInfos.getLength()) {
            Node rawInfo = rawInfos.item(i);
            switch (rawInfo.getNodeName()) {
                case "buffer_type": {
                    BufferType bufferType = BufferType.valueOfString((String)rawInfo.getTextContent());
                    domain.setBufferType(bufferType);
                    break;
                }
                case "channels": {
                    ArrayList<IChannelInfo> channels = new ArrayList<IChannelInfo>();
                    LTTngControlServiceMI.parseChannels(rawInfo.getChildNodes(), channels);
                    if (channels.size() <= 0) break;
                    domain.setChannels(channels);
                    break;
                }
            }
            ++i;
        }
        return domain;
    }

    /*
     * Exception decompiling
     */
    private static void parseChannels(NodeList rawChannels, ArrayList<IChannelInfo> channels) throws ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[23] lbl139 : CaseStatement: default:\u000a, @NONE, blocks:[23] lbl139 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ISnapshotInfo getSnapshotInfo(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        List<String> command = this.createCommand("snapshot", "list-output", "-s", sessionName);
        ICommandResult result = this.executeCommand(command, monitor);
        Document doc = this.getDocumentFromStrings(result.getOutput());
        NodeList rawSnapshotsOutputs = doc.getElementsByTagName("snapshot");
        SnapshotInfo snapshotInfo = new SnapshotInfo("");
        int i = 0;
        while (i < rawSnapshotsOutputs.getLength()) {
            NodeList rawSnapshotOutput = rawSnapshotsOutputs.item(i).getChildNodes();
            int j = 0;
            while (j < rawSnapshotOutput.getLength()) {
                Node rawInfo = rawSnapshotOutput.item(j);
                switch (rawInfo.getNodeName()) {
                    case "id": {
                        snapshotInfo.setId(Integer.parseInt(rawInfo.getTextContent()));
                        break;
                    }
                    case "name": {
                        snapshotInfo.setName(rawInfo.getTextContent());
                        break;
                    }
                    case "ctrl_url": {
                        snapshotInfo.setSnapshotPath(rawInfo.getTextContent());
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        Matcher matcher2 = LTTngControlServiceConstants.TRACE_NETWORK_PATTERN.matcher(snapshotInfo.getSnapshotPath());
        if (matcher2.matches()) {
            snapshotInfo.setStreamedSnapshot(true);
        }
        return snapshotInfo;
    }

    @Override
    public List<IBaseEventInfo> getKernelProvider(IProgressMonitor monitor) throws ExecutionException {
        List<String> command = this.createCommand("list", "-k");
        ICommandResult result = this.executeCommand(command, monitor, false);
        ArrayList<IBaseEventInfo> events = new ArrayList<IBaseEventInfo>();
        if (this.isError(result) && result.getErrorOutput() != null) {
            if (this.ignoredPattern(result.getErrorOutput(), LTTngControlServiceConstants.LIST_KERNEL_NO_KERNEL_PROVIDER_PATTERN)) {
                return events;
            }
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + LTTngControlServiceMI.toCommandString(command));
        }
        Document document = this.getDocumentFromStrings(result.getOutput());
        NodeList rawEvents = document.getElementsByTagName("event");
        LTTngControlServiceMI.getBaseEventInfo(rawEvents, events);
        return events;
    }

    @Override
    public List<IUstProviderInfo> getUstProvider(IProgressMonitor monitor) throws ExecutionException {
        List<String> command = this.createCommand("list", "-u");
        command.add("-f");
        ICommandResult result = this.executeCommand(command, monitor, false);
        ArrayList<IUstProviderInfo> allProviders = new ArrayList<IUstProviderInfo>();
        if (this.isError(result) && result.getErrorOutput() != null) {
            if (this.ignoredPattern(result.getErrorOutput(), LTTngControlServiceConstants.LIST_UST_NO_UST_PROVIDER_PATTERN)) {
                return allProviders;
            }
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + LTTngControlServiceMI.toCommandString(command));
        }
        Document document = this.getDocumentFromStrings(result.getOutput());
        NodeList rawProviders = document.getElementsByTagName("pid");
        UstProviderInfo providerInfo = null;
        int i = 0;
        while (i < rawProviders.getLength()) {
            Node provider = rawProviders.item(i);
            Node name = LTTngControlServiceMI.getFirstOf(provider.getChildNodes(), "name");
            if (name == null) {
                throw new ExecutionException(Messages.TraceControl_MiInvalidProviderError);
            }
            providerInfo = new UstProviderInfo(name.getTextContent());
            NodeList infos = provider.getChildNodes();
            int j = 0;
            while (j < infos.getLength()) {
                Node info = infos.item(j);
                switch (info.getNodeName()) {
                    case "id": {
                        providerInfo.setPid(Integer.parseInt(info.getTextContent()));
                        break;
                    }
                    case "events": {
                        ArrayList<IBaseEventInfo> events = new ArrayList<IBaseEventInfo>();
                        NodeList rawEvents = info.getChildNodes();
                        LTTngControlServiceMI.getBaseEventInfo(rawEvents, events);
                        providerInfo.setEvents(events);
                        break;
                    }
                }
                ++j;
            }
            allProviders.add((IUstProviderInfo)providerInfo);
            ++i;
        }
        return allProviders;
    }

    @Override
    public ISessionInfo createSession(ISessionInfo sessionInfo, IProgressMonitor monitor) throws ExecutionException {
        if (sessionInfo.isStreamedTrace()) {
            return this.createStreamedSession(sessionInfo, monitor);
        }
        List<String> command = this.prepareSessionCreationCommand(sessionInfo);
        ICommandResult result = this.executeCommand(command, monitor);
        Document document = this.getDocumentFromStrings(result.getOutput());
        NodeList sessions = document.getElementsByTagName("session");
        if (sessions.getLength() != 1) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + NLS.bind((String)Messages.TraceControl_UnexpectedNumberOfElementError, (Object)"session") + " " + sessions.getLength());
        }
        SessionInfo outputSession = new SessionInfo("");
        this.parseSession((ISessionInfo)outputSession, sessions.item(0));
        if (outputSession.getName().equals("") || !"".equals(sessionInfo.getName()) && !outputSession.getName().equals(sessionInfo.getName())) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedNameError + ": " + outputSession.getName());
        }
        if (!sessionInfo.isSnapshotSession() && (outputSession.getSessionPath() == null || sessionInfo.getSessionPath() != null && !outputSession.getSessionPath().contains(sessionInfo.getSessionPath()))) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedPathError + ": " + outputSession.getName());
        }
        if (sessionInfo.isSnapshotSession()) {
            outputSession.setSnapshotInfo((ISnapshotInfo)new SnapshotInfo(""));
        }
        return outputSession;
    }

    private ISessionInfo createStreamedSession(ISessionInfo sessionInfo, IProgressMonitor monitor) throws ExecutionException {
        List<String> command = this.prepareStreamedSessionCreationCommand(sessionInfo);
        ICommandResult result = this.executeCommand(command, monitor);
        Document document = this.getDocumentFromStrings(result.getOutput());
        NodeList sessions = document.getElementsByTagName("session");
        if (sessions.getLength() != 1) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + NLS.bind((String)Messages.TraceControl_UnexpectedNumberOfElementError, (Object)"session") + " " + sessions.getLength());
        }
        SessionInfo outputSession = new SessionInfo("");
        this.parseSession((ISessionInfo)outputSession, sessions.item(0));
        if (outputSession.getName().equals("") || !"".equals(sessionInfo.getName()) && !outputSession.getName().equals(sessionInfo.getName())) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedNameError + ": " + outputSession.getName());
        }
        sessionInfo.setName(outputSession.getName());
        sessionInfo.setStreamedTrace(true);
        if (sessionInfo.getNetworkUrl() != null) {
            if (!sessionInfo.isSnapshotSession() && outputSession.getSessionPath() == null) {
                throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedPathError + ": " + outputSession.getName());
            }
            if (sessionInfo.isSnapshotSession()) {
                sessionInfo.setStreamedTrace(false);
            } else {
                sessionInfo.setSessionPath(outputSession.getSessionPath());
                Matcher matcher = LTTngControlServiceConstants.TRACE_FILE_PROTOCOL_PATTERN.matcher(outputSession.getSessionPath());
                if (matcher.matches()) {
                    sessionInfo.setStreamedTrace(false);
                }
            }
        }
        return sessionInfo;
    }

    @Override
    public void destroySession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        List<String> command = this.createCommand("destroy", sessionName);
        ICommandResult result = this.executeCommand(command, monitor, false);
        String[] errorOutput = result.getErrorOutput();
        if (this.isError(result) && errorOutput != null) {
            if (this.ignoredPattern(errorOutput, LTTngControlServiceConstants.SESSION_NOT_FOUND_ERROR_PATTERN)) {
                return;
            }
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + LTTngControlServiceMI.toCommandString(command) + "\n" + LTTngControlServiceMI.formatOutput(result));
        }
        Document doc = this.getDocumentFromStrings(result.getOutput());
        NodeList sessions = doc.getElementsByTagName("session");
        if (sessions.getLength() != 1) {
            throw new ExecutionException(NLS.bind((String)Messages.TraceControl_MiInvalidNumberOfElementError, (Object)"session"));
        }
        Node rawSessionName = LTTngControlServiceMI.getFirstOf(sessions.item(0).getChildNodes(), "name");
        if (rawSessionName == null) {
            throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
        }
        if (!rawSessionName.getTextContent().equals(sessionName)) {
            throw new ExecutionException(NLS.bind((String)Messages.TraceControl_UnexpectedValueError, (Object)rawSessionName.getTextContent(), (Object)sessionName));
        }
    }

    @Override
    protected List<String> createCommand(String ... strings) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("lttng");
        command.add("--mi");
        command.add("xml");
        String groupOption = this.getTracingGroupOption();
        if (!groupOption.isEmpty()) {
            command.add(groupOption);
        }
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            command.add(string);
            ++n2;
        }
        return command;
    }

    private static void getBaseEventInfo(NodeList xmlBaseEvents, List<IBaseEventInfo> events) throws ExecutionException {
        BaseEventInfo eventInfo = null;
        int i = 0;
        while (i < xmlBaseEvents.getLength()) {
            block16: {
                NodeList rawInfos = xmlBaseEvents.item(i).getChildNodes();
                if (!xmlBaseEvents.item(i).getNodeName().equalsIgnoreCase("event")) break block16;
                Node rawName = LTTngControlServiceMI.getFirstOf(rawInfos, "name");
                if (rawName == null) {
                    throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
                }
                eventInfo = new BaseEventInfo(rawName.getTextContent());
                int j = 0;
                while (j < rawInfos.getLength()) {
                    Node infoNode = rawInfos.item(j);
                    switch (infoNode.getNodeName()) {
                        case "type": {
                            eventInfo.setEventType(infoNode.getTextContent());
                            break;
                        }
                        case "loglevel": {
                            eventInfo.setLogLevel(infoNode.getTextContent());
                            break;
                        }
                        case "event_fields": {
                            ArrayList<IFieldInfo> fields = new ArrayList<IFieldInfo>();
                            LTTngControlServiceMI.getFieldInfo(infoNode.getChildNodes(), fields);
                            eventInfo.setFields(fields);
                            break;
                        }
                    }
                    ++j;
                }
                events.add((IBaseEventInfo)eventInfo);
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    static void getEventInfo(NodeList xmlEvents, List<IEventInfo> events) throws ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl69 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl69 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void getFieldInfo(NodeList fieldsList, List<IFieldInfo> fields) throws ExecutionException {
        FieldInfo fieldInfo = null;
        int i = 0;
        while (i < fieldsList.getLength()) {
            block10: {
                Node field = fieldsList.item(i);
                if (!field.getNodeName().equalsIgnoreCase("event_field")) break block10;
                Node name = LTTngControlServiceMI.getFirstOf(field.getChildNodes(), "name");
                if (name == null) {
                    throw new ExecutionException(Messages.TraceControl_MiMissingRequiredError);
                }
                fieldInfo = new FieldInfo(name.getTextContent());
                NodeList infos = field.getChildNodes();
                int j = 0;
                while (j < infos.getLength()) {
                    Node info = infos.item(j);
                    switch (info.getNodeName()) {
                        case "type": {
                            fieldInfo.setFieldType(info.getTextContent());
                            break;
                        }
                    }
                    ++j;
                }
                fields.add((IFieldInfo)fieldInfo);
            }
            ++i;
        }
    }

    private static Node getFirstOf(NodeList nodeList, String tagName) {
        Node node = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeName() == tagName) {
                node = nodeList.item(i);
                break;
            }
            ++i;
        }
        return node;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$linuxtools$internal$lttng2$control$core$model$TraceEventType() {
        if ($SWITCH_TABLE$org$eclipse$linuxtools$internal$lttng2$control$core$model$TraceEventType != null) {
            return $SWITCH_TABLE$org$eclipse$linuxtools$internal$lttng2$control$core$model$TraceEventType;
        }
        int[] nArray = new int[TraceEventType.values().length];
        try {
            nArray[TraceEventType.FUNCTION.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TraceEventType.PROBE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TraceEventType.SYSCALL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TraceEventType.TRACEPOINT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TraceEventType.UNKNOWN.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$linuxtools$internal$lttng2$control$core$model$TraceEventType = nArray;
        return nArray;
    }
}

