/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.internal.ArchiveText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipFormat
implements ArchiveCommand.Format<ArchiveOutputStream> {
    private static final List<String> SUFFIXES = Collections.unmodifiableList(Arrays.asList(".zip"));

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s) {
        return new ZipArchiveOutputStream(s);
    }

    public void putEntry(ArchiveOutputStream out, String path, FileMode mode, ObjectLoader loader) throws IOException {
        if (path.endsWith("/") && mode != FileMode.TREE) {
            throw new IllegalArgumentException(MessageFormat.format(ArchiveText.get().pathDoesNotMatchMode, path, mode));
        }
        if (!path.endsWith("/") && mode == FileMode.TREE) {
            path = path + "/";
        }
        ZipArchiveEntry entry = new ZipArchiveEntry(path);
        if (mode == FileMode.TREE) {
            out.putArchiveEntry((ArchiveEntry)entry);
            out.closeArchiveEntry();
            return;
        }
        if (mode != FileMode.REGULAR_FILE) {
            if (mode == FileMode.EXECUTABLE_FILE || mode == FileMode.SYMLINK) {
                entry.setUnixMode(mode.getBits());
            } else {
                throw new IllegalArgumentException(MessageFormat.format(ArchiveText.get().unsupportedMode, mode));
            }
        }
        entry.setSize(loader.getSize());
        out.putArchiveEntry((ArchiveEntry)entry);
        loader.copyTo((OutputStream)out);
        out.closeArchiveEntry();
    }

    public Iterable<String> suffixes() {
        return SUFFIXES;
    }

    public boolean equals(Object other) {
        return other instanceof ZipFormat;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

