/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.net.URISyntaxException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.CloneCommand;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasteCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String errorMessage;
        block22: {
            File file;
            String content;
            Clipboard clip;
            block20: {
                block21: {
                    block16: {
                        block19: {
                            URIish cloneURI;
                            block17: {
                                block18: {
                                    block14: {
                                        block15: {
                                            errorMessage = null;
                                            clip = null;
                                            try {
                                                clip = new Clipboard(this.getShell(event).getDisplay());
                                                content = (String)clip.getContents((Transfer)TextTransfer.getInstance());
                                                if (content != null) break block14;
                                                errorMessage = UIText.RepositoriesView_NothingToPasteMessage;
                                                if (clip == null) break block15;
                                            }
                                            catch (Throwable throwable) {
                                                if (clip != null) {
                                                    clip.dispose();
                                                }
                                                if (errorMessage != null) {
                                                    Activator.handleError(errorMessage, null, true);
                                                }
                                                throw throwable;
                                            }
                                            clip.dispose();
                                        }
                                        if (errorMessage != null) {
                                            Activator.handleError(errorMessage, null, true);
                                        }
                                        return null;
                                    }
                                    file = new File(content);
                                    if (file.exists() && file.isDirectory()) break block16;
                                    cloneURI = this.getCloneURI(content);
                                    if (cloneURI != null) break block17;
                                    errorMessage = UIText.RepositoriesView_ClipboardContentNotDirectoryOrURIMessage;
                                    if (clip == null) break block18;
                                    clip.dispose();
                                }
                                if (errorMessage != null) {
                                    Activator.handleError(errorMessage, null, true);
                                }
                                return null;
                            }
                            CloneCommand cmd = new CloneCommand(cloneURI.toString());
                            cmd.execute(event);
                            if (clip == null) break block19;
                            clip.dispose();
                        }
                        if (errorMessage != null) {
                            Activator.handleError(errorMessage, null, true);
                        }
                        return null;
                    }
                    if (RepositoryCache.FileKey.isGitRepository((File)file, (FS)FS.DETECTED) || RepositoryCache.FileKey.isGitRepository((File)(file = new File(file, ".git")), (FS)FS.DETECTED)) break block20;
                    errorMessage = NLS.bind((String)UIText.RepositoriesView_ClipboardContentNoGitRepoMessage, (Object)content);
                    if (clip == null) break block21;
                    clip.dispose();
                }
                if (errorMessage != null) {
                    Activator.handleError(errorMessage, null, true);
                }
                return null;
            }
            if (!this.util.addConfiguredRepository(file)) {
                errorMessage = NLS.bind((String)UIText.RepositoriesView_PasteRepoAlreadyThere, (Object)content);
            }
            if (clip == null) break block22;
            clip.dispose();
        }
        if (errorMessage != null) {
            Activator.handleError(errorMessage, null, true);
        }
        return null;
    }

    private URIish getCloneURI(String content) {
        if (content != null && content.startsWith("git clone")) {
            content = content.substring(9);
        }
        try {
            URIish finalURI = new URIish(content.trim());
            if (RepositorySelectionPage.Protocol.FILE.handles(finalURI) || RepositorySelectionPage.Protocol.GIT.handles(finalURI) || RepositorySelectionPage.Protocol.HTTP.handles(finalURI) || RepositorySelectionPage.Protocol.HTTPS.handles(finalURI) || RepositorySelectionPage.Protocol.SSH.handles(finalURI)) {
                return finalURI;
            }
            return null;
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getLocalizedMessage(), e, true);
            return null;
        }
    }
}

