/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;

public class TmfUiTracer {
    private static String pluginID = "org.eclipse.linuxtools.tmf.ui";
    static boolean ERROR = false;
    static boolean WARNING = false;
    static boolean INFO = false;
    static boolean INDEX = false;
    static boolean DISPLAY = false;
    static boolean SORTING = false;
    private static String LOGNAME = "traceUI.log";
    private static BufferedWriter fTraceLog = null;

    private static BufferedWriter openLogFile(String filename) {
        BufferedWriter outfile = null;
        try {
            outfile = new BufferedWriter(new FileWriter(filename));
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error creating log file " + LOGNAME, e);
        }
        return outfile;
    }

    public static void init() {
        boolean isTracing = false;
        String traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/error"));
        if (traceKey != null) {
            ERROR = Boolean.valueOf(traceKey);
            isTracing |= ERROR;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/warning"))) != null) {
            WARNING = Boolean.valueOf(traceKey);
            isTracing |= WARNING;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/info"))) != null) {
            INFO = Boolean.valueOf(traceKey);
            isTracing |= INFO;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/updateindex"))) != null) {
            INDEX = Boolean.valueOf(traceKey);
            isTracing |= INDEX;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/display"))) != null) {
            DISPLAY = Boolean.valueOf(traceKey);
            isTracing |= DISPLAY;
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/sorting"))) != null) {
            SORTING = Boolean.valueOf(traceKey);
            isTracing |= SORTING;
        }
        if (isTracing) {
            fTraceLog = TmfUiTracer.openLogFile(LOGNAME);
        }
    }

    public static void stop() {
        if (fTraceLog == null) {
            return;
        }
        try {
            fTraceLog.close();
            fTraceLog = null;
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error closing log file " + LOGNAME, e);
        }
    }

    public static boolean isErrorTraced() {
        return ERROR;
    }

    public static boolean isIndexTraced() {
        return INDEX;
    }

    public static boolean isDisplayTraced() {
        return DISPLAY;
    }

    public static boolean isSortingTraced() {
        return SORTING;
    }

    public static void trace(String msg) {
        if (fTraceLog == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        StringBuilder message = new StringBuilder("[");
        message.append(currentTime / 1000L);
        message.append(".");
        message.append(String.format("%1$03d", currentTime % 1000L));
        message.append("] ");
        message.append(msg);
        try {
            fTraceLog.write(message.toString());
            fTraceLog.newLine();
            fTraceLog.flush();
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error writing to log file " + LOGNAME, e);
        }
    }

    public static void traceIndex(String msg) {
        String message = "[INDEX] " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceDisplay(String msg) {
        String message = "[DISPLAY]" + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceSorting(String msg) {
        String message = "[SORT] " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceError(String msg) {
        String message = "[ERR] Thread=" + Thread.currentThread().getId() + " " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceWarning(String msg) {
        String message = "[WARN] Thread=" + Thread.currentThread().getId() + " " + msg;
        TmfUiTracer.trace(message);
    }

    public static void traceInfo(String msg) {
        String message = "[INF] Thread=" + Thread.currentThread().getId() + " " + msg;
        TmfUiTracer.trace(message);
    }
}

