/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.linuxtools.internal.tmf.ui.commands.ExportToTextJob;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.viewers.events.columns.TmfEventTableColumn;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class ExportToTextCommandHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.exportToText";
    public static final String TMF_EVENT_TABLE_COLUMNS_ID = "org.eclipse.linuxtools.tmf.ui.exportToText.columns";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<TmfEventTableColumn> columns = ExportToTextCommandHandler.getColumns(event.getApplicationContext());
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        ITmfFilter filter = TmfTraceManager.getInstance().getCurrentFilter();
        if (trace != null) {
            FileDialog fd = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
            fd.setFilterExtensions(new String[]{"*.csv", "*.*", "*"});
            fd.setOverwrite(true);
            String s = fd.open();
            if (s != null) {
                ExportToTextJob j = new ExportToTextJob(trace, filter, columns, s);
                j.setUser(true);
                j.schedule();
            }
        }
        return null;
    }

    private static List<TmfEventTableColumn> getColumns(Object evaluationContext) {
        Object s;
        if (evaluationContext instanceof IEvaluationContext && (s = ((IEvaluationContext)evaluationContext).getVariable(TMF_EVENT_TABLE_COLUMNS_ID)) instanceof List) {
            return (List)s;
        }
        return null;
    }
}

