/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfAnalysisOutputElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.IHandlerService;

public class OpenAction
extends Action {
    private static final String OPEN_COMMAND_ID = "org.eclipse.ui.navigate.openResource";
    private final IWorkbenchPage page;
    private final ISelectionProvider selectionProvider;
    private TmfProjectModelElement element;

    public OpenAction(IWorkbenchPage page, ISelectionProvider selectionProvider) {
        this.page = page;
        this.selectionProvider = selectionProvider;
    }

    public boolean isEnabled() {
        IStructuredSelection sSelection;
        ISelection selection = this.selectionProvider.getSelection();
        if (!selection.isEmpty() && (sSelection = (IStructuredSelection)selection).size() == 1 && (sSelection.getFirstElement() instanceof TmfTraceElement || sSelection.getFirstElement() instanceof TmfExperimentElement || sSelection.getFirstElement() instanceof TmfAnalysisOutputElement)) {
            this.element = (TmfProjectModelElement)sSelection.getFirstElement();
            return true;
        }
        return false;
    }

    public void run() {
        try {
            boolean executeCommand;
            Object service = this.page.getActivePart().getSite().getService(IHandlerService.class);
            IHandlerService handlerService = (IHandlerService)service;
            boolean bl = executeCommand = this.element instanceof TmfTraceElement || this.element instanceof TmfAnalysisOutputElement;
            if (!executeCommand && this.element instanceof TmfExperimentElement) {
                TmfExperimentElement experiment = (TmfExperimentElement)this.element;
                boolean bl2 = executeCommand = experiment.getTraces().size() > 0;
            }
            if (executeCommand) {
                handlerService.executeCommand(OPEN_COMMAND_ID, null);
            }
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError("Error opening resource " + this.element.getName(), e);
        }
        catch (NotDefinedException e) {
            Activator.getDefault().logError("Error opening resource " + this.element.getName(), e);
        }
        catch (NotEnabledException e) {
            Activator.getDefault().logError("Error opening resource " + this.element.getName(), e);
        }
        catch (NotHandledException e) {
            Activator.getDefault().logError("Error opening resource " + this.element.getName(), e);
        }
    }
}

