/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;

public class TracePropertyTester
extends PropertyTester {
    private static final String IS_IN_TRACE_FOLDER = "isInTraceFolder";
    private static final String IS_EXPERIMENT_TRACE = "isExperimentTrace";
    private static final String HAS_SUPPLEMENTARY_FILES = "hasSupplementaryFiles";
    private static final String TRACE_TYPE = "traceType";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_IN_TRACE_FOLDER.equals(property) && receiver != null && receiver instanceof IStructuredSelection) {
            for (Object item : (IStructuredSelection)receiver) {
                if (item instanceof TmfTraceElement) {
                    TmfTraceElement trace = (TmfTraceElement)item;
                    if (trace.getParent() instanceof TmfTraceFolder) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        if (IS_EXPERIMENT_TRACE.equals(property)) {
            if (receiver != null && receiver instanceof TmfTraceElement) {
                TmfTraceElement trace = (TmfTraceElement)receiver;
                return trace.getParent() instanceof TmfExperimentElement;
            }
            return false;
        }
        if (HAS_SUPPLEMENTARY_FILES.equals(property)) {
            if (receiver == null) {
                return false;
            }
            if (receiver instanceof TmfTraceElement) {
                TmfTraceElement trace = (TmfTraceElement)receiver;
                return trace.hasSupplementaryResources();
            }
            if (receiver instanceof TmfExperimentElement) {
                TmfExperimentElement trace = (TmfExperimentElement)receiver;
                boolean hasHistory = false;
                for (TmfTraceElement aTrace : trace.getTraces()) {
                    hasHistory |= aTrace.hasSupplementaryResources();
                }
                return hasHistory |= trace.hasSupplementaryResources();
            }
            return false;
        }
        if (TRACE_TYPE.equals(property)) {
            if (receiver != null && receiver instanceof TmfTraceElement) {
                TmfTraceElement trace = (TmfTraceElement)receiver;
                if (expectedValue instanceof String && expectedValue.equals(trace.getTraceType())) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

