/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageWizardPage;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageBookmarkElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageLabelProvider;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFileElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.TracePackageExportOperation;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExportTracePackageWizardPage
extends AbstractTracePackageWizardPage {
    private static final int CONTENT_COL_WIDTH = 300;
    private static final int SIZE_COL_WIDTH = 100;
    private static final String ZIP_EXTENSION = ".zip";
    private static final String TAR_EXTENSION = ".tar";
    private static final String TAR_GZ_EXTENSION = ".tar.gz";
    private static final String TGZ_EXTENSION = ".tgz";
    private static final String ICON_PATH = "icons/wizban/export_wiz.png";
    public static final String PAGE_NAME = "ExportTracePackageWizardPage";
    private static final String STORE_COMPRESS_CONTENTS_ID = "ExportTracePackageWizardPage.STORE_COMPRESS_CONTENTS_ID";
    private static final String STORE_FORMAT_ID = "ExportTracePackageWizardPage.STORE_FORMAT_ID";
    private Button fCompressContentsCheckbox;
    private Button fZipFormatButton;
    private Button fTargzFormatButton;
    private Label fApproximateSizeLabel;
    private List<TmfTraceElement> fSelectedTraces;

    public ExportTracePackageWizardPage(IStructuredSelection selection, List<TmfTraceElement> selectedTraces) {
        super(PAGE_NAME, org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_Title, Activator.getDefault().getImageDescripterFromPath(ICON_PATH), selection);
        this.fSelectedTraces = selectedTraces;
    }

    public void setSelectedTraces(List<TmfTraceElement> selectedTraces) {
        if (!this.fSelectedTraces.containsAll(selectedTraces) || !selectedTraces.containsAll(this.fSelectedTraces)) {
            this.fSelectedTraces = selectedTraces;
            CheckboxTreeViewer elementViewer = this.getElementViewer();
            elementViewer.setInput(this.createElementViewerInput());
            elementViewer.expandToLevel(2);
            ExportTracePackageWizardPage.setAllChecked(elementViewer, false, true);
            this.updateApproximateSelectedSize();
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createElementViewer(composite);
        this.createButtonsGroup(composite);
        this.createFilePathGroup(composite, org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_ToArchive, 8192);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.setMessage(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_ChooseContent);
        this.updateApproximateSelectedSize();
        this.updatePageCompletion();
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updatePageCompletion();
        } else {
            this.setPageComplete(false);
        }
    }

    @Override
    protected void restoreWidgetValues() {
        super.restoreWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.getFilePathCombo().getItemCount() > 0) {
                String item = this.getFilePathCombo().getItem(0);
                this.setFilePathValue(item);
            }
            this.fCompressContentsCheckbox.setSelection(settings.getBoolean(STORE_COMPRESS_CONTENTS_ID));
            this.fZipFormatButton.setSelection(settings.getBoolean(STORE_FORMAT_ID));
            this.fTargzFormatButton.setSelection(!settings.getBoolean(STORE_FORMAT_ID));
            this.updateWithFilePathSelection();
        }
    }

    @Override
    protected void createFilePathGroup(Composite parent, String label, int fileDialogStyle) {
        super.createFilePathGroup(parent, label, fileDialogStyle);
        this.getFilePathCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportTracePackageWizardPage.this.updatePageCompletion();
            }
        });
    }

    private void createOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        optionsGroup.setLayout((Layout)new RowLayout(512));
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_Options);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportTracePackageWizardPage.this.updateWithFilePathSelection();
            }
        };
        this.fZipFormatButton = new Button((Composite)optionsGroup, 16400);
        this.fZipFormatButton.setText(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_SaveInZipFormat);
        this.fZipFormatButton.setSelection(true);
        this.fZipFormatButton.addSelectionListener((SelectionListener)listener);
        this.fTargzFormatButton = new Button((Composite)optionsGroup, 16400);
        this.fTargzFormatButton.setText(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_SaveInTarFormat);
        this.fTargzFormatButton.setSelection(false);
        this.fTargzFormatButton.addSelectionListener((SelectionListener)listener);
        this.fCompressContentsCheckbox = new Button((Composite)optionsGroup, 16416);
        this.fCompressContentsCheckbox.setText(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_CompressContents);
        this.fCompressContentsCheckbox.setSelection(true);
        this.fCompressContentsCheckbox.addSelectionListener((SelectionListener)listener);
    }

    @Override
    protected void createElementViewer(Composite parent) {
        super.createElementViewer(parent);
        CheckboxTreeViewer elementViewer = this.getElementViewer();
        elementViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)elementViewer, 0);
        column.getColumn().setWidth(300);
        column.getColumn().setText(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_ContentColumnName);
        column.setLabelProvider((CellLabelProvider)new TracePackageLabelProvider());
        column = new TreeViewerColumn((TreeViewer)elementViewer, 0);
        column.getColumn().setWidth(100);
        column.getColumn().setText(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_SizeColumnName);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TracePackageElement tracePackageElement = (TracePackageElement)((Object)element);
                long size = tracePackageElement.getSize(false);
                if (size == 0L) {
                    return null;
                }
                int level = 0;
                TracePackageElement curElement = tracePackageElement.getParent();
                while (curElement != null) {
                    curElement = curElement.getParent();
                    ++level;
                }
                return this.indent(ExportTracePackageWizardPage.getHumanReadable(size), level);
            }

            private String indent(String humanReadable, int level) {
                StringBuilder s = new StringBuilder(humanReadable);
                int i = 0;
                while (i < level) {
                    String indentStr = "  ";
                    s.insert(0, "  ");
                    ++i;
                }
                return s.toString();
            }
        });
        elementViewer.setInput(this.createElementViewerInput());
        elementViewer.expandToLevel(2);
        ExportTracePackageWizardPage.setAllChecked(elementViewer, false, true);
    }

    @Override
    protected void updateApproximateSelectedSize() {
        TracePackageElement[] tracePackageElements;
        long checkedSize = 0L;
        TracePackageElement[] tracePackageElementArray = tracePackageElements = (TracePackageElement[])this.getElementViewer().getInput();
        int n = tracePackageElements.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            checkedSize += element.getSize(true);
            ++n2;
        }
        checkedSize = Math.max(0L, checkedSize);
        this.fApproximateSizeLabel.setText(MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_ApproximateSizeLbl, ExportTracePackageWizardPage.getHumanReadable(checkedSize)));
    }

    private static String getHumanReadable(long size) {
        String[] humanSuffix = new String[]{org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_SizeByte, org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_SizeKilobyte, org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_SizeMegabyte, org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_SizeGigabyte, org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_SizeTerabyte};
        long curSize = size;
        int suffixIndex = 0;
        while (curSize >= 1024L) {
            curSize /= 1024L;
            ++suffixIndex;
        }
        return String.valueOf(Long.toString(curSize)) + " " + humanSuffix[suffixIndex];
    }

    @Override
    protected Object createElementViewerInput() {
        ArrayList<TracePackageTraceElement> traceElements = new ArrayList<TracePackageTraceElement>();
        for (TmfTraceElement tmfTraceElement : this.fSelectedTraces) {
            TracePackageTraceElement traceElement = new TracePackageTraceElement(null, tmfTraceElement);
            ArrayList<TracePackageElement> children = new ArrayList<TracePackageElement>();
            TracePackageFilesElement filesElement = new TracePackageFilesElement((TracePackageElement)traceElement, tmfTraceElement.getResource());
            filesElement.setChecked(true);
            children.add(filesElement);
            IResource[] supplementaryResources = tmfTraceElement.getSupplementaryResources();
            ArrayList<TracePackageSupplFileElement> suppFilesChildren = new ArrayList<TracePackageSupplFileElement>();
            TracePackageSupplFilesElement suppFilesElement = new TracePackageSupplFilesElement(traceElement);
            children.add(suppFilesElement);
            IResource[] iResourceArray = supplementaryResources;
            int n = supplementaryResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                suppFilesChildren.add(new TracePackageSupplFileElement(res, (TracePackageElement)suppFilesElement));
                ++n2;
            }
            IFile bookmarksFile = tmfTraceElement.getBookmarksFile();
            if (bookmarksFile != null && bookmarksFile.exists()) {
                try {
                    IMarker[] findMarkers = bookmarksFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
                    if (findMarkers.length > 0) {
                        children.add(new TracePackageBookmarkElement(traceElement, null));
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error finding bookmarks", e);
                }
            }
            traceElements.add(traceElement);
        }
        return traceElements.toArray(new TracePackageTraceElement[0]);
    }

    @Override
    protected final Composite createButtonsGroup(Composite parent) {
        Composite buttonGroup = super.createButtonsGroup(parent);
        this.fApproximateSizeLabel = new Label(buttonGroup, 131072);
        GridData layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        this.fApproximateSizeLabel.setLayoutData((Object)layoutData);
        return buttonGroup;
    }

    @Override
    protected void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_COMPRESS_CONTENTS_ID, this.fCompressContentsCheckbox.getSelection());
            settings.put(STORE_FORMAT_ID, this.fZipFormatButton.getSelection());
        }
    }

    private String getOutputExtension() {
        if (this.fZipFormatButton.getSelection()) {
            return ZIP_EXTENSION;
        }
        if (this.fCompressContentsCheckbox.getSelection()) {
            return TAR_GZ_EXTENSION;
        }
        return TAR_EXTENSION;
    }

    @Override
    protected void updateWithFilePathSelection() {
        String filePathValue = this.getFilePathValue();
        if (filePathValue.isEmpty()) {
            return;
        }
        filePathValue = ExportTracePackageWizardPage.stripKnownExtension(filePathValue);
        filePathValue = filePathValue.concat(this.getOutputExtension());
        this.setFilePathValue(filePathValue);
    }

    private static String stripKnownExtension(String str) {
        String ret = str;
        if (str.endsWith(TAR_GZ_EXTENSION)) {
            ret = ret.substring(0, ret.lastIndexOf("."));
        }
        if (ret.endsWith(ZIP_EXTENSION) | ret.endsWith(TAR_EXTENSION) | ret.endsWith(TGZ_EXTENSION)) {
            ret = ret.substring(0, ret.lastIndexOf("."));
        }
        return ret;
    }

    public boolean finish() {
        if (!this.checkForOverwrite()) {
            return false;
        }
        this.saveWidgetValues();
        TracePackageTraceElement[] traceExportElements = (TracePackageTraceElement[])this.getElementViewer().getInput();
        boolean useCompression = this.fCompressContentsCheckbox.getSelection();
        boolean useTar = this.fTargzFormatButton.getSelection();
        String fileName = this.getFilePathValue();
        final TracePackageExportOperation exporter = new TracePackageExportOperation(traceExportElements, useCompression, useTar, fileName);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    exporter.run(monitor);
                }
            });
            IStatus status = exporter.getStatus();
            if (status.getSeverity() == 4) {
                this.handleErrorStatus(status);
            }
        }
        catch (InvocationTargetException e) {
            this.handleError(Messages.TracePackage_ErrorOperation, e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return exporter.getStatus().getSeverity() == 0;
    }

    private boolean checkForOverwrite() {
        File file = new File(this.getFilePathValue());
        if (file.exists()) {
            return MessageDialog.openQuestion((Shell)this.getContainer().getShell(), null, (String)org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ExportTracePackageWizardPage_AlreadyExitst);
        }
        return true;
    }
}

