/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageBookmarkElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFileElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileExportOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TracePackageExportOperation
extends AbstractTracePackageOperation {
    private static final String TRACE_EXPORT_TEMP_FOLDER = ".traceExport";
    private final TracePackageTraceElement[] fTraceExportElements;
    private final boolean fUseCompression;
    private final boolean fUseTar;
    private final Set<IResource> fResources;
    private IFolder fExportFolder;

    public TracePackageExportOperation(TracePackageTraceElement[] traceExportElements, boolean useCompression, boolean useTar, String fileName) {
        super(fileName);
        this.fTraceExportElements = traceExportElements;
        this.fUseCompression = useCompression;
        this.fUseTar = useTar;
        this.fResources = new HashSet<IResource>();
    }

    @Override
    public void run(IProgressMonitor progressMonitor) {
        try {
            int totalWork = this.getNbCheckedElements(this.fTraceExportElements) * 2;
            progressMonitor.beginTask(Messages.TracePackageExportOperation_GeneratingPackage, totalWork);
            this.fExportFolder = this.createExportFolder(progressMonitor);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element createElement = doc.createElement("tmf-export");
            Node tmfNode = doc.appendChild(createElement);
            TracePackageTraceElement[] tracePackageTraceElementArray = this.fTraceExportElements;
            int n = this.fTraceExportElements.length;
            int n2 = 0;
            while (n2 < n) {
                TracePackageTraceElement tracePackageElement = tracePackageTraceElementArray[n2];
                if (TracePackageExportOperation.isFilesChecked(tracePackageElement)) {
                    this.exportTrace(progressMonitor, tmfNode, tracePackageElement);
                }
                ++n2;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StringWriter buffer = new StringWriter();
            StreamResult result = new StreamResult(buffer);
            transformer.transform(source, result);
            String content = buffer.getBuffer().toString();
            ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
            this.exportManifest(content);
            this.setStatus(this.exportToArchive(progressMonitor, totalWork));
            this.fExportFolder.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1, 4));
            progressMonitor.done();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                this.setStatus(Status.CANCEL_STATUS);
            }
            this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.Messages.TracePackage_ErrorOperation, (Throwable)e));
        }
    }

    private IFolder createExportFolder(IProgressMonitor monitor) throws CoreException {
        IFolder folder = this.fTraceExportElements[0].getTraceElement().getProject().getResource().getFolder(TRACE_EXPORT_TEMP_FOLDER);
        if (folder.exists()) {
            folder.delete(true, null);
        }
        folder.create(4097, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
        return folder;
    }

    private void exportTrace(IProgressMonitor monitor, Node tmfNode, TracePackageTraceElement tracePackageElement) throws InterruptedException, CoreException {
        TmfTraceElement traceElement = tracePackageElement.getTraceElement();
        Element traceXmlElement = tmfNode.getOwnerDocument().createElement("trace");
        traceXmlElement.setAttribute("name", traceElement.getResource().getName());
        traceXmlElement.setAttribute("type", traceElement.getTraceType());
        Node traceNode = tmfNode.appendChild(traceXmlElement);
        TracePackageElement[] tracePackageElementArray = tracePackageElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            ModalContext.checkCanceled((IProgressMonitor)monitor);
            if (element.isChecked()) {
                if (element instanceof TracePackageSupplFilesElement) {
                    this.exportSupplementaryFiles(monitor, traceNode, traceElement, (TracePackageSupplFilesElement)element);
                } else if (element instanceof TracePackageBookmarkElement) {
                    TracePackageExportOperation.exportBookmarks(monitor, traceNode, (TracePackageBookmarkElement)element);
                } else if (element instanceof TracePackageFilesElement) {
                    this.exportTraceFiles(monitor, traceNode, (TracePackageFilesElement)element);
                }
                monitor.worked(1);
            }
            ++n2;
        }
    }

    private void exportSupplementaryFiles(IProgressMonitor monitor, Node traceNode, TmfTraceElement traceElement, TracePackageSupplFilesElement element) throws InterruptedException, CoreException {
        Document doc = traceNode.getOwnerDocument();
        if (element.getChildren().length > 0) {
            IPath projectPath = traceElement.getProject().getPath();
            TracePackageElement[] tracePackageElementArray = element.getChildren();
            int n = tracePackageElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                TracePackageElement child = tracePackageElementArray[n2];
                TracePackageSupplFileElement supplFile = (TracePackageSupplFileElement)child;
                ModalContext.checkCanceled((IProgressMonitor)monitor);
                IResource res = supplFile.getResource();
                IPath relativeToExportFolder = res.getFullPath().makeRelativeTo(projectPath);
                IFolder folder = this.fExportFolder.getFolder(relativeToExportFolder.removeLastSegments(1));
                TraceUtils.createFolder(folder, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                res.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                TracePackageExportOperation.createExportResource(folder, res);
                Element suppFileElement = doc.createElement("supplementary-file");
                suppFileElement.setAttribute("name", relativeToExportFolder.toString());
                traceNode.appendChild(suppFileElement);
                ++n2;
            }
            IFolder suppFilesFolder = this.fExportFolder.getFolder(".tracing");
            this.fResources.add((IResource)suppFilesFolder);
        }
    }

    private void exportTraceFiles(IProgressMonitor monitor, Node traceNode, TracePackageFilesElement element) throws CoreException {
        Document doc = traceNode.getOwnerDocument();
        TmfTraceElement traceElement = ((TracePackageTraceElement)element.getParent()).getTraceElement();
        IResource resource = traceElement.getResource();
        IPath traceFolderPath = traceElement.getProject().getTracesFolder().getPath();
        IPath relativeToExportFolder = resource.getFullPath().makeRelativeTo(traceFolderPath);
        IFolder folder = this.fExportFolder.getFolder(relativeToExportFolder.removeLastSegments(1));
        TraceUtils.createFolder(folder, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
        TracePackageExportOperation.createExportResource(folder, resource);
        Element fileElement = doc.createElement("file");
        fileElement.setAttribute("name", relativeToExportFolder.toString());
        traceNode.appendChild(fileElement);
        IResource exportedResource = this.fExportFolder.findMember(relativeToExportFolder.segment(0));
        this.fResources.add(exportedResource);
    }

    private static IResource createExportResource(IFolder exportFolder, IResource res) throws CoreException {
        IFolder ret = null;
        if (res instanceof IFolder) {
            IFolder folder = exportFolder.getFolder(res.getName());
            folder.createLink(res.getLocationURI(), 0, null);
            ret = folder;
        } else if (res instanceof IFile) {
            IFile file = exportFolder.getFile(res.getName());
            file.createLink(res.getLocationURI(), 0, null);
            ret = file;
        }
        return ret;
    }

    private static void exportBookmarks(IProgressMonitor monitor, Node traceNode, TracePackageBookmarkElement element) throws CoreException, InterruptedException {
        IMarker[] findMarkers;
        Document doc = traceNode.getOwnerDocument();
        IFile bookmarksFile = ((TracePackageTraceElement)element.getParent()).getTraceElement().getBookmarksFile();
        if (bookmarksFile != null && bookmarksFile.exists() && (findMarkers = bookmarksFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0)).length > 0) {
            Element bookmarksXmlElement = doc.createElement("bookmarks");
            Node bookmarksNode = traceNode.appendChild(bookmarksXmlElement);
            IMarker[] iMarkerArray = findMarkers;
            int n = findMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                ModalContext.checkCanceled((IProgressMonitor)monitor);
                Element singleBookmarkXmlElement = doc.createElement("bookmark");
                for (String key : marker.getAttributes().keySet()) {
                    singleBookmarkXmlElement.setAttribute(key, marker.getAttribute(key).toString());
                }
                bookmarksNode.appendChild(singleBookmarkXmlElement);
                ++n2;
            }
        }
    }

    private void exportManifest(String content) throws CoreException {
        IFile file = this.fExportFolder.getFile("export-manifest.xml");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        if (file.exists()) {
            file.setContents((InputStream)inputStream, 1, null);
        } else {
            file.create((InputStream)inputStream, 4097, null);
        }
        this.fResources.add((IResource)file);
    }

    private IStatus exportToArchive(IProgressMonitor monitor, int totalWork) throws InvocationTargetException, InterruptedException {
        ArchiveFileExportOperation op = new ArchiveFileExportOperation(new ArrayList<IResource>(this.fResources), this.getFileName());
        op.setCreateLeadupStructure(false);
        op.setUseCompression(this.fUseCompression);
        op.setUseTarFormat(this.fUseTar);
        op.run((IProgressMonitor)new SubProgressMonitor(monitor, totalWork / 2, 4));
        return op.getStatus();
    }
}

