/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.editors;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditor;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.editors.UnsortedPropertySheetPage;
import org.eclipse.linuxtools.tmf.ui.project.model.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.linuxtools.tmf.ui.viewers.events.columns.TmfEventTableColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class TmfEventsEditor
extends TmfEditor
implements ITmfTraceEditor,
IReusableEditor,
IPropertyListener,
IResourceChangeListener,
ISelectionProvider,
ISelectionChangedListener,
IPartListener,
IGotoMarker {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.editors.events";
    private TmfEventsTable fEventsTable;
    private IFile fFile;
    private ITmfTrace fTrace;
    private Composite fParent;
    private ListenerList fSelectionChangedListeners = new ListenerList();
    private boolean fTraceSelected;
    private IMarker fPendingGotoMarker;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IFileEditorInput fileEditorInput;
        if (input instanceof TmfEditorInput) {
            this.fFile = ((TmfEditorInput)input).getFile();
            this.fTrace = ((TmfEditorInput)input).getTrace();
            fileEditorInput = new FileEditorInput(this.fFile);
        } else if (input instanceof IFileEditorInput) {
            fileEditorInput = (IFileEditorInput)input;
            this.fFile = fileEditorInput.getFile();
            if (this.fFile == null) {
                throw new PartInitException("Invalid IFileEditorInput: " + fileEditorInput);
            }
            try {
                String traceTypeId = this.fFile.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (traceTypeId == null) {
                    throw new PartInitException(Messages.TmfOpenTraceHelper_NoTraceType);
                }
                if (traceTypeId.equals(TmfExperiment.class.getCanonicalName())) {
                    TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject(), true);
                    if (project == null) {
                        throw new PartInitException(Messages.TmfOpenTraceHelper_NoTraceType);
                    }
                    for (TmfExperimentElement experimentElement : project.getExperimentsFolder().getExperiments()) {
                        if (!experimentElement.getResource().equals((Object)this.fFile.getParent())) continue;
                        this.setPartName(experimentElement.getName());
                        super.setSite((IWorkbenchPartSite)site);
                        super.setInput((IEditorInput)fileEditorInput);
                        TmfOpenTraceHelper.reopenTraceFromElement(experimentElement, this);
                        return;
                    }
                }
                if (traceTypeId.equals(TmfTrace.class.getCanonicalName())) {
                    TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject(), true);
                    for (TmfTraceElement traceElement : project.getTracesFolder().getTraces()) {
                        if (!traceElement.getResource().equals((Object)this.fFile.getParent())) continue;
                        this.setPartName(traceElement.getName());
                        super.setSite((IWorkbenchPartSite)site);
                        super.setInput((IEditorInput)fileEditorInput);
                        TmfOpenTraceHelper.reopenTraceFromElement(traceElement, this);
                        return;
                    }
                }
                TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject(), true);
                for (TmfTraceElement traceElement : project.getTracesFolder().getTraces()) {
                    if (!traceElement.getResource().equals((Object)this.fFile)) continue;
                    this.setPartName(traceElement.getName());
                    super.setSite((IWorkbenchPartSite)site);
                    super.setInput((IEditorInput)fileEditorInput);
                    TmfOpenTraceHelper.reopenTraceFromElement(traceElement, this);
                    return;
                }
            }
            catch (PartInitException e) {
                throw e;
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError("Error initializing TmfEventsEditor", e);
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error initializing TmfEventsEditor", e);
            }
        } else {
            throw new PartInitException("Invalid IEditorInput: " + input.getClass());
        }
        if (this.fTrace == null) {
            throw new PartInitException("Invalid IEditorInput: " + this.fFile.getName());
        }
        super.setSite((IWorkbenchPartSite)site);
        super.setInput((IEditorInput)fileEditorInput);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.firePropertyChange(258);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258 && this.getEditorInput() instanceof TmfEditorInput) {
            if (this.fTrace != null) {
                this.broadcast((TmfSignal)new TmfTraceClosedSignal((Object)this, this.fTrace));
            }
            this.fTraceSelected = false;
            this.fFile = ((TmfEditorInput)this.getEditorInput()).getFile();
            this.fTrace = ((TmfEditorInput)this.getEditorInput()).getTrace();
            super.setInput((IEditorInput)new FileEditorInput(this.fFile));
            this.fEventsTable.dispose();
            if (this.fTrace != null) {
                this.setPartName(this.fTrace.getName());
                this.fEventsTable = this.createEventsTable(this.fParent, this.fTrace.getCacheSize());
                this.fEventsTable.addSelectionChangedListener(this);
                this.fEventsTable.setTrace(this.fTrace, true);
                this.fEventsTable.refreshBookmarks(this.fFile);
                if (this.fPendingGotoMarker != null) {
                    this.fEventsTable.gotoMarker(this.fPendingGotoMarker);
                    this.fPendingGotoMarker = null;
                }
                ITmfContext context = this.fTrace.seekEvent(0L);
                this.fTrace.getNext(context);
                context.dispose();
                this.broadcast((TmfSignal)new TmfTraceOpenedSignal((Object)this, this.fTrace, this.fFile));
            } else {
                this.setPartName(this.getEditorInput().getName());
                this.fEventsTable = new TmfEventsTable(this.fParent, 0);
                this.fEventsTable.addSelectionChangedListener(this);
            }
            this.fParent.layout();
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        if (this.fTrace != null) {
            this.setPartName(this.fTrace.getName());
            this.fEventsTable = this.createEventsTable(parent, this.fTrace.getCacheSize());
            this.fEventsTable.addSelectionChangedListener(this);
            this.fEventsTable.setTrace(this.fTrace, true);
            this.fEventsTable.refreshBookmarks(this.fFile);
            ITmfContext context = this.fTrace.seekEvent(0L);
            this.fTrace.getNext(context);
            context.dispose();
            this.broadcast((TmfSignal)new TmfTraceOpenedSignal((Object)this, this.fTrace, this.fFile));
        } else {
            this.fEventsTable = new TmfEventsTable(parent, 0);
            this.fEventsTable.addSelectionChangedListener(this);
        }
        IStatusLineManager statusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        this.fEventsTable.setStatusLineManager(statusLineManager);
        this.addPropertyListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    @Override
    public void dispose() {
        if (this.getSite() != null) {
            this.getSite().getPage().removePartListener((IPartListener)this);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.removePropertyListener(this);
        if (this.fTrace != null) {
            this.broadcast((TmfSignal)new TmfTraceClosedSignal((Object)this, this.fTrace));
        }
        if (this.fEventsTable != null) {
            this.fEventsTable.dispose();
        }
        super.dispose();
    }

    @NonNull
    protected TmfEventsTable createEventsTable(Composite parent, int cacheSize) {
        return TmfEventsEditor.getEventTable(this.fTrace, parent, cacheSize);
    }

    @NonNull
    private static TmfEventsTable getEventTable(ITmfTrace trace, Composite parent, int cacheSize) {
        if (trace instanceof TmfExperiment) {
            return TmfEventsEditor.getExperimentEventTable((TmfExperiment)trace, parent, cacheSize);
        }
        TmfEventsTable table = TmfTraceTypeUIUtils.getEventTable(trace, parent, cacheSize);
        if (table != null) {
            return table;
        }
        Collection<? extends TmfEventTableColumn> columns = TmfTraceTypeUIUtils.getEventTableColumns(trace);
        if (columns != null) {
            return new TmfEventsTable(parent, cacheSize, columns);
        }
        return new TmfEventsTable(parent, cacheSize);
    }

    @NonNull
    private static TmfEventsTable getExperimentEventTable(TmfExperiment experiment, Composite parent, int cacheSize) {
        String commonTraceType = TmfEventsEditor.getCommonTraceType(experiment);
        if (commonTraceType != null) {
            return TmfEventsEditor.getEventTable(experiment.getTraces()[0], parent, cacheSize);
        }
        ITmfTrace[] traces = experiment.getTraces();
        LinkedHashSet<? extends TmfEventTableColumn> cols = new LinkedHashSet<TmfEventTableColumn>();
        ITmfTrace[] iTmfTraceArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            Collection<? extends TmfEventTableColumn> traceCols = TmfTraceTypeUIUtils.getEventTableColumns(trace);
            if (traceCols == null) {
                cols.addAll(TmfEventsTable.DEFAULT_COLUMNS);
            } else {
                cols.addAll(traceCols);
            }
            ++n2;
        }
        return new TmfEventsTable(parent, cacheSize, cols);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getCommonTraceType(TmfExperiment experiment) {
        String commonTraceType = null;
        try {
            ITmfTrace[] iTmfTraceArray = experiment.getTraces();
            int n = iTmfTraceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return commonTraceType;
                }
                ITmfTrace trace = iTmfTraceArray[n2];
                IResource resource = trace.getResource();
                if (resource == null) {
                    return null;
                }
                String traceType = resource.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (commonTraceType != null && !commonTraceType.equals(traceType)) {
                    return null;
                }
                commonTraceType = traceType;
                ++n2;
            }
        }
        catch (CoreException e) {
            return null;
        }
    }

    @Override
    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public void setFocus() {
        this.fEventsTable.setFocus();
    }

    public Object getAdapter(Class adapter) {
        if (IGotoMarker.class.equals((Object)adapter)) {
            if (this.fTrace == null || this.fEventsTable == null) {
                return this;
            }
            return this.fEventsTable;
        }
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return new UnsortedPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public void gotoMarker(IMarker marker) {
        if (this.fTrace == null || this.fEventsTable == null) {
            this.fPendingGotoMarker = marker;
        } else {
            this.fEventsTable.gotoMarker(marker);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().equals((Object)this.fFile)) {
                if (delta.getKind() == 2) {
                    final IMarker bookmark = delta.getMarker();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TmfEventsEditor.this.fEventsTable.removeBookmark(bookmark);
                        }
                    });
                } else if (delta.getKind() == 4) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TmfEventsEditor.this.fEventsTable.getTable().refresh();
                        }
                    });
                }
            }
            ++n2;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.fEventsTable == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fEventsTable.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this && this.fTrace != null) {
            if (this.fTraceSelected) {
                return;
            }
            this.fTraceSelected = true;
            this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, this.fTrace));
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (part == this && this.fTrace != null) {
            if (this.fTraceSelected) {
                return;
            }
            this.fTraceSelected = true;
            this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, this.fTrace));
        }
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void addBookmark() {
        this.fEventsTable.addBookmark(this.fFile);
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getSource() != this) {
            if (signal.getTrace().equals(this.fTrace)) {
                this.getSite().getPage().bringToTop((IWorkbenchPart)this);
            } else {
                this.fTraceSelected = false;
            }
        }
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        if (this.fEventsTable != null) {
            this.fEventsTable.refresh();
        }
    }
}

