/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTracesFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class TmfCommonProjectElement
extends TmfProjectModelElement {
    private String fTraceTypeId = null;
    private static final String BOOKMARKS_HIDDEN_FILE = ".bookmarks";

    public TmfCommonProjectElement(String name, IResource resource, TmfProjectModelElement parent) {
        super(name, resource, parent);
        parent.addChild(this);
        this.refreshTraceType();
        TmfSignalManager.register((Object)this);
    }

    @Override
    void refreshChildren() {
        HashMap<String, TmfAnalysisElement> childrenMap = new HashMap<String, TmfAnalysisElement>();
        for (TmfAnalysisElement analysis : this.getAvailableAnalysis()) {
            childrenMap.put(analysis.getAnalysisId(), analysis);
        }
        TraceTypeHelper helper = TmfTraceType.getTraceType((String)this.getTraceType());
        Class traceClass = null;
        if (helper != null) {
            traceClass = helper.getTraceClass();
        }
        if (traceClass == null) {
            for (TmfAnalysisElement analysis : childrenMap.values()) {
                this.removeChild(analysis);
            }
            return;
        }
        IPath path = this.fResource.getFullPath();
        for (IAnalysisModuleHelper module : TmfAnalysisManager.getAnalysisModules((Class)traceClass).values()) {
            TmfAnalysisElement analysis = (TmfAnalysisElement)childrenMap.remove(module.getId());
            if (analysis == null) {
                IFolder newresource = ResourcesPlugin.getWorkspace().getRoot().getFolder(path.append(module.getId()));
                analysis = new TmfAnalysisElement(module.getName(), (IResource)newresource, this, module.getId());
            }
            analysis.refreshChildren();
        }
        for (TmfAnalysisElement analysis : childrenMap.values()) {
            this.removeChild(analysis);
        }
    }

    public String getTraceType() {
        return this.fTraceTypeId;
    }

    public void refreshTraceType() {
        try {
            this.fTraceTypeId = TmfTraceType.getTraceTypeId((IResource)this.getResource());
        }
        catch (CoreException e) {
            Activator.getDefault().logError(NLS.bind((String)Messages.TmfCommonProjectElement_ErrorRefreshingProperty, (Object)this.getName()), e);
        }
    }

    public abstract ITmfTrace instantiateTrace();

    protected String getSupplementaryFolderPath() {
        return String.valueOf(this.getElementPath()) + this.getSuffix();
    }

    public String getElementPath() {
        ITmfProjectModelElement parent = this.getParent();
        while (!(parent instanceof TmfTracesFolder || parent instanceof TmfExperimentElement || parent instanceof TmfExperimentFolder)) {
            parent = parent.getParent();
        }
        IPath path = this.fResource.getFullPath().makeRelativeTo(parent.getPath());
        return path.toString();
    }

    protected String getSuffix() {
        return "";
    }

    public List<TmfTraceElement> getTraces() {
        return new ArrayList<TmfTraceElement>();
    }

    public ITmfTrace getTrace() {
        for (ITmfTrace trace : TmfTraceManager.getInstance().getOpenedTraces()) {
            if (!trace.getResource().equals((Object)this.getResource())) continue;
            return trace;
        }
        return null;
    }

    public abstract IFile createBookmarksFile() throws CoreException;

    protected IFile createBookmarksFile(IFolder bookmarksFolder, String traceType) throws CoreException {
        IFile file = this.getBookmarksFile();
        if (!file.exists()) {
            IFile bookmarksFile = bookmarksFolder.getFile(BOOKMARKS_HIDDEN_FILE);
            if (!bookmarksFile.exists()) {
                ByteArrayInputStream source = new ByteArrayInputStream(new byte[0]);
                bookmarksFile.create((InputStream)source, 4097, null);
            }
            file.createLink(bookmarksFile.getLocation(), 4352, null);
            file.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceType);
        }
        return file;
    }

    public abstract String getEditorId();

    public IFile getBookmarksFile() {
        IFolder folder = (IFolder)this.fResource;
        IFile file = folder.getFile(String.valueOf(this.getName()) + '_');
        return file;
    }

    public void closeEditors() {
        IFile file = this.getBookmarksFile();
        FileEditorInput input = new FileEditorInput(file);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = wbPage.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    try {
                        if (editorReference.getEditorInput().equals(input)) {
                            wbPage.closeEditor(editorReference.getEditor(false), false);
                        }
                    }
                    catch (PartInitException e) {
                        Activator.getDefault().logError(NLS.bind((String)Messages.TmfCommonProjectElement_ErrorClosingEditor, (Object)this.getName()), e);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public abstract String getTypeName();

    public IResource copy(String newName, boolean copySuppFiles) {
        IPath newPath = this.getParent().getResource().getFullPath().addTrailingSeparator().append(newName);
        if (copySuppFiles) {
            String newElementPath = new Path(this.getElementPath()).removeLastSegments(1).append(newName).toString();
            this.copySupplementaryFolder(newElementPath);
        }
        try {
            this.getResource().copy(newPath, 33, null);
            IResource trace = ((IFolder)this.getParent().getResource()).findMember(newName);
            if (trace instanceof IFolder) {
                IFolder folderTrace = (IFolder)trace;
                IResource[] iResourceArray = folderTrace.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    String traceTypeId = TmfTraceType.getTraceTypeId((IResource)member);
                    if (TmfTrace.class.getCanonicalName().equals(traceTypeId)) {
                        member.delete(true, null);
                    } else if (TmfExperiment.class.getCanonicalName().equals(traceTypeId)) {
                        member.delete(true, null);
                    }
                    ++n2;
                }
            }
            return trace;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public List<TmfAnalysisElement> getAvailableAnalysis() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfAnalysisElement> analysis = new ArrayList<TmfAnalysisElement>();
        for (ITmfProjectModelElement child : children) {
            if (!(child instanceof TmfAnalysisElement)) continue;
            analysis.add((TmfAnalysisElement)child);
        }
        return analysis;
    }

    public void deleteSupplementaryFolder() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        try {
            TmfCommonProjectElement.deleteFolder(supplFolder);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error deleting supplementary folder " + supplFolder, e);
        }
    }

    private static void deleteFolder(IFolder folder) throws CoreException {
        IContainer parent;
        if (folder.exists()) {
            folder.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        if ((parent = folder.getParent()) instanceof IFolder && (!parent.exists() || parent.members().length == 0)) {
            TmfCommonProjectElement.deleteFolder((IFolder)parent);
        }
    }

    public void renameSupplementaryFolder(String newElementPath) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        try {
            if (oldSupplFolder.exists()) {
                IFolder newSupplFolder = this.prepareTraceSupplementaryFolder(String.valueOf(newElementPath) + this.getSuffix(), false);
                oldSupplFolder.move(newSupplFolder.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            TmfCommonProjectElement.deleteFolder(oldSupplFolder);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error renaming supplementary folder " + oldSupplFolder, e);
        }
    }

    public void copySupplementaryFolder(String newElementPath) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        if (oldSupplFolder.exists()) {
            try {
                IFolder newSupplFolder = this.prepareTraceSupplementaryFolder(String.valueOf(newElementPath) + this.getSuffix(), false);
                oldSupplFolder.copy(newSupplFolder.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error renaming supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void copySupplementaryFolder(IFolder destination) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        if (oldSupplFolder.exists()) {
            try {
                TraceUtils.createFolder((IFolder)destination.getParent(), (IProgressMonitor)new NullProgressMonitor());
                oldSupplFolder.copy(destination.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error copying supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void refreshSupplementaryFolder() {
        IFolder supplFolder = this.createSupplementaryFolder();
        try {
            supplFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error refreshing supplementary folder " + supplFolder, e);
        }
    }

    public boolean hasSupplementaryResources() {
        IResource[] resources = this.getSupplementaryResources();
        return resources.length > 0;
    }

    public IResource[] getSupplementaryResources() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.getSupplementaryFolderPath());
        if (supplFolder.exists()) {
            try {
                return supplFolder.members();
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary folder " + supplFolder, e);
            }
        }
        return new IResource[0];
    }

    public void deleteSupplementaryResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            try {
                resources[i].delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary resource " + resources[i], e);
            }
            ++i;
        }
    }

    public void deleteSupplementaryResources() {
        this.deleteSupplementaryResources(this.getSupplementaryResources());
    }

    private IFolder createSupplementaryFolder() {
        IFolder supplFolder = this.prepareTraceSupplementaryFolder(this.getSupplementaryFolderPath(), true);
        try {
            this.fResource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocationURI().getPath());
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error setting persistant property " + TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, e);
        }
        return supplFolder;
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        IResource resource = signal.getTrace().getResource();
        if (resource == null || !resource.equals((Object)this.getResource())) {
            return;
        }
        this.getParent().refresh();
    }
}

