/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceUtils;
import org.eclipse.linuxtools.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfExperimentElement
extends TmfCommonProjectElement
implements IPropertySource2 {
    private static final String sfInfoCategory = "Info";
    private static final String sfName = "name";
    private static final String sfPath = "path";
    private static final String sfLocation = "location";
    private static final String sfFolderSuffix = "_exp";
    private static final String sfExperimentType = "type";
    private static final ReadOnlyTextPropertyDescriptor sfNameDescriptor = new ReadOnlyTextPropertyDescriptor("name", "name");
    private static final ReadOnlyTextPropertyDescriptor sfPathDescriptor = new ReadOnlyTextPropertyDescriptor("path", "path");
    private static final ReadOnlyTextPropertyDescriptor sfLocationDescriptor = new ReadOnlyTextPropertyDescriptor("location", "location");
    private static final ReadOnlyTextPropertyDescriptor sfTypeDescriptor = new ReadOnlyTextPropertyDescriptor("type", "type");
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{sfNameDescriptor, sfPathDescriptor, sfLocationDescriptor, sfTypeDescriptor};
    private static final Map<String, IConfigurationElement> sfTraceTypeAttributes;
    private static final Map<String, IConfigurationElement> sfTraceTypeUIAttributes;
    private static final Map<String, IConfigurationElement> sfTraceCategories;

    static {
        sfNameDescriptor.setCategory(sfInfoCategory);
        sfPathDescriptor.setCategory(sfInfoCategory);
        sfLocationDescriptor.setCategory(sfInfoCategory);
        sfTypeDescriptor.setCategory(sfInfoCategory);
        sfTraceTypeAttributes = new HashMap<String, IConfigurationElement>();
        sfTraceTypeUIAttributes = new HashMap<String, IConfigurationElement>();
        sfTraceCategories = new HashMap<String, IConfigurationElement>();
    }

    public static void init() {
        IConfigurationElement ce;
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.core.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals("experiment")) {
                String traceTypeId = ce.getAttribute("id");
                sfTraceTypeAttributes.put(traceTypeId, ce);
            } else if (elementName.equals("category")) {
                String categoryId = ce.getAttribute("id");
                sfTraceCategories.put(categoryId, ce);
            }
            ++n2;
        }
        iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.ui.tracetypeui");
        n = config.length;
        n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            String elemName = ce.getName();
            if ("experiment".equals(elemName)) {
                String traceType = ce.getAttribute("tracetype");
                sfTraceTypeUIAttributes.put(traceType, ce);
            }
            ++n2;
        }
    }

    public TmfExperimentElement(String name, IFolder folder, TmfExperimentFolder parent) {
        super(name, (IResource)folder, parent);
    }

    public IFolder getResource() {
        return (IFolder)this.fResource;
    }

    @Override
    void refreshChildren() {
        IFolder folder = this.getResource();
        HashMap<String, TmfTraceElement> childrenMap = new HashMap<String, TmfTraceElement>();
        for (TmfTraceElement trace : this.getTraces()) {
            childrenMap.put(trace.getElementPath(), trace);
        }
        List<IResource> members = this.getTraceResources();
        for (IResource resource : members) {
            String name = resource.getName();
            String elementPath = resource.getFullPath().makeRelativeTo(folder.getFullPath()).toString();
            ITmfProjectModelElement element = (ITmfProjectModelElement)childrenMap.get(elementPath);
            if (element instanceof TmfTraceElement) {
                childrenMap.remove(elementPath);
                continue;
            }
            element = new TmfTraceElement(name, resource, this);
        }
        for (ITmfProjectModelElement danglingChild : childrenMap.values()) {
            this.removeChild(danglingChild);
        }
        super.refreshChildren();
    }

    private List<IResource> getTraceResources() {
        IFolder folder = this.getResource();
        final ArrayList<IResource> list = new ArrayList<IResource>();
        try {
            folder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy resource) throws CoreException {
                    if (resource.isLinked()) {
                        list.add(resource.requestResource());
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return list;
    }

    @Override
    public void refreshTraceType() {
        IConfigurationElement ce;
        super.refreshTraceType();
        if (this.getTraceType() == null && (ce = TmfTraceType.getTraceAttributes((String)"org.eclipse.linuxtools.tmf.core.experiment.generic")) != null) {
            try {
                IFolder experimentFolder = this.getResource();
                experimentFolder.setPersistentProperty(TmfCommonConstants.TRACETYPE, ce.getAttribute("id"));
                super.refreshTraceType();
            }
            catch (CoreException | InvalidRegistryObjectException throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public List<TmfTraceElement> getTraces() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        for (ITmfProjectModelElement child : children) {
            if (!(child instanceof TmfTraceElement)) continue;
            traces.add((TmfTraceElement)child);
        }
        return traces;
    }

    public void addTrace(TmfTraceElement trace) {
        this.addTrace(trace, true);
    }

    public void addTrace(TmfTraceElement trace, boolean refresh) {
        IFolder experiment = this.getResource();
        IResource resource = trace.getResource();
        IPath location = resource.getLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            String traceTypeId = TmfTraceType.getTraceTypeId((IResource)trace.getResource());
            TraceTypeHelper traceType = TmfTraceType.getTraceType((String)traceTypeId);
            if (resource instanceof IFolder) {
                IFolder folder = experiment.getFolder(trace.getElementPath());
                TraceUtils.createFolder((IFolder)folder.getParent(), (IProgressMonitor)new NullProgressMonitor());
                IStatus result = workspace.validateLinkLocation((IResource)folder, location);
                if (result.isOK() || result.matches(3)) {
                    folder.createLink(location, 256, null);
                    if (traceType != null) {
                        TmfTraceTypeUIUtils.setTraceType((IResource)folder, traceType, refresh);
                    }
                } else {
                    Activator.getDefault().logError("Error creating link. Invalid trace location " + location);
                }
            } else {
                IFile file = experiment.getFile(trace.getElementPath());
                TraceUtils.createFolder((IFolder)file.getParent(), (IProgressMonitor)new NullProgressMonitor());
                IStatus result = workspace.validateLinkLocation((IResource)file, location);
                if (result.isOK() || result.matches(3)) {
                    file.createLink(location, 256, null);
                    if (traceType != null) {
                        TmfTraceTypeUIUtils.setTraceType((IResource)file, traceType, refresh);
                    }
                } else {
                    Activator.getDefault().logError("Error creating link. Invalid trace location " + location);
                }
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error creating link to location " + location, e);
        }
    }

    public void removeTrace(TmfTraceElement trace) throws CoreException {
        this.closeEditors();
        this.removeChild(trace);
        this.deleteTraceResource(trace.getResource());
        this.deleteSupplementaryResources();
    }

    private void deleteTraceResource(IResource resource) throws CoreException {
        resource.delete(true, null);
        IContainer parent = resource.getParent();
        if (!parent.equals((Object)this.getResource()) && parent.members().length == 0) {
            this.deleteTraceResource((IResource)parent);
        }
    }

    @Override
    public IFile createBookmarksFile() throws CoreException {
        return this.createBookmarksFile(this.getProject().getExperimentsFolder().getResource(), TmfExperiment.class.getCanonicalName());
    }

    @Override
    public String getEditorId() {
        IConfigurationElement[] defaultEditorCE;
        IConfigurationElement ce;
        if (this.getTraceType() != null && (ce = sfTraceTypeUIAttributes.get(this.getTraceType())) != null && (defaultEditorCE = ce.getChildren("defaultEditor")).length == 1) {
            return defaultEditorCE[0].getAttribute("id");
        }
        List<TmfTraceElement> traceEntries = this.getTraces();
        String commonEditorId = null;
        for (TmfTraceElement element : traceEntries) {
            String editorId = element.getEditorId();
            if (commonEditorId == null) {
                commonEditorId = editorId != null ? editorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                continue;
            }
            if (commonEditorId.equals(editorId)) continue;
            commonEditorId = "org.eclipse.linuxtools.tmf.ui.editors.events";
        }
        return null;
    }

    public TmfExperiment instantiateTrace() {
        block3: {
            IConfigurationElement ce;
            block4: {
                this.refreshSupplementaryFolder();
                if (this.getTraceType() == null) break block3;
                ce = sfTraceTypeAttributes.get(this.getTraceType());
                if (ce != null) break block4;
                return null;
            }
            try {
                TmfExperiment experiment = (TmfExperiment)ce.createExecutableExtension("experiment_type");
                return experiment;
            }
            catch (CoreException e) {
                Activator.getDefault().logError(NLS.bind((String)Messages.TmfExperimentElement_ErrorInstantiatingTrace, (Object)this.getName()), e);
            }
        }
        return null;
    }

    @Override
    public String getTypeName() {
        return Messages.TmfExperimentElement_TypeName;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(sfDescriptors, sfDescriptors.length);
    }

    public Object getPropertyValue(Object id) {
        if (sfName.equals(id)) {
            return this.getName();
        }
        if (sfPath.equals(id)) {
            return this.getPath().toString();
        }
        if (sfLocation.equals(id)) {
            return this.getLocation().toString();
        }
        if (sfExperimentType.equals(id) && this.getTraceType() != null) {
            IConfigurationElement category;
            IConfigurationElement ce = sfTraceTypeAttributes.get(this.getTraceType());
            if (ce == null) {
                return "";
            }
            String categoryId = ce.getAttribute("category");
            if (categoryId != null && (category = sfTraceCategories.get(categoryId)) != null) {
                return String.valueOf(category.getAttribute(sfName)) + ':' + ce.getAttribute(sfName);
            }
            return ce.getAttribute(sfName);
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    @Override
    public String getSuffix() {
        return sfFolderSuffix;
    }
}

