/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers;

import org.eclipse.linuxtools.tmf.core.component.ITmfComponent;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalThrottler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.viewers.ITmfTimeProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.TmfViewer;
import org.eclipse.swt.widgets.Composite;

public abstract class TmfTimeViewer
extends TmfViewer
implements ITmfTimeProvider {
    private long fStartTime;
    private long fEndTime;
    private long fWindowStartTime;
    private long fWindowEndTime;
    private long fWindowDuration;
    private long fSelectionBeginTime;
    private long fSelectionEndTime;
    private ITmfTrace fTrace;
    private final TmfSignalThrottler fTimeRangeSyncThrottle = new TmfSignalThrottler((ITmfComponent)this, 200L);

    public TmfTimeViewer() {
    }

    public TmfTimeViewer(Composite parent) {
        this(parent, "");
    }

    public TmfTimeViewer(Composite parent, String name) {
        this.init(parent, name);
    }

    protected void setStartTime(long startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(long endTime) {
        this.fEndTime = endTime;
    }

    protected void setWindowStartTime(long windowStartTime) {
        this.fWindowStartTime = windowStartTime;
    }

    protected void setWindowEndTime(long windowEndTime) {
        this.fWindowEndTime = windowEndTime;
    }

    protected void setWindowDuration(long windowDuration) {
        this.fWindowDuration = windowDuration;
    }

    protected void setSelectionBeginTime(long selectionBeginTime) {
        this.fSelectionBeginTime = selectionBeginTime;
    }

    protected void setSelectionEndTime(long selectionEndTime) {
        this.fSelectionEndTime = selectionEndTime;
    }

    protected void setTrace(ITmfTrace trace) {
        this.fTrace = trace;
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    @Override
    public long getWindowStartTime() {
        return this.fWindowStartTime;
    }

    @Override
    public long getWindowEndTime() {
        return this.fWindowEndTime;
    }

    @Override
    public long getWindowDuration() {
        return this.fWindowDuration;
    }

    @Override
    public long getSelectionBeginTime() {
        return this.fSelectionBeginTime;
    }

    @Override
    public long getSelectionEndTime() {
        return this.fSelectionEndTime;
    }

    @Override
    public void updateSelectionRange(long currentBeginTime, long currentEndTime) {
        if (this.fTrace != null) {
            this.setSelectionBeginTime(currentBeginTime);
            this.setSelectionEndTime(currentEndTime);
            TmfTimestamp startTimestamp = new TmfTimestamp(this.getSelectionBeginTime(), -9);
            TmfTimestamp endTimestamp = new TmfTimestamp(this.getSelectionEndTime(), -9);
            TmfTimeSynchSignal signal = new TmfTimeSynchSignal((Object)this, (ITmfTimestamp)startTimestamp, (ITmfTimestamp)endTimestamp);
            this.broadcast((TmfSignal)signal);
        }
    }

    @Override
    public void updateWindow(long windowStartTime, long windowEndTime) {
        this.setWindowStartTime(windowStartTime);
        this.setWindowEndTime(windowEndTime);
        this.setWindowDuration(windowEndTime - windowStartTime);
        TmfTimeRange timeRange = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(this.getWindowStartTime(), -9), (ITmfTimestamp)new TmfTimestamp(this.getWindowEndTime(), -9));
        TmfRangeSynchSignal signal = new TmfRangeSynchSignal((Object)this, timeRange);
        this.fTimeRangeSyncThrottle.queue((TmfSignal)signal);
    }

    public void loadTrace(ITmfTrace trace) {
        this.fTrace = trace;
        long timestamp = TmfTraceManager.getInstance().getSelectionBeginTime().normalize(0L, -9).getValue();
        TmfTimeRange currentRange = TmfTraceManager.getInstance().getCurrentRange();
        long windowStartTime = currentRange.getStartTime().normalize(0L, -9).getValue();
        long windowEndTime = currentRange.getEndTime().normalize(0L, -9).getValue();
        long windowDuration = windowEndTime - windowStartTime;
        long startTime = this.fTrace.getStartTime().normalize(0L, -9).getValue();
        long endTime = this.fTrace.getEndTime().normalize(0L, -9).getValue();
        this.setSelectionBeginTime(timestamp);
        this.setSelectionEndTime(timestamp);
        this.setStartTime(startTime);
        this.setWindowStartTime(windowStartTime);
        this.setWindowEndTime(windowEndTime);
        this.setWindowDuration(windowDuration);
        this.setEndTime(endTime);
    }

    public void reset() {
        this.setSelectionBeginTime(0L);
        this.setSelectionEndTime(0L);
        this.setStartTime(0L);
        this.setWindowStartTime(0L);
        this.setWindowDuration(0L);
        this.setEndTime(0L);
        this.setWindowEndTime(0L);
        this.setTrace(null);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.loadTrace(this.getTrace());
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (this.fTrace != signal.getTrace()) {
            this.fTrace = signal.getTrace();
            this.loadTrace(this.getTrace());
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        this.fTrace = null;
        this.reset();
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfTimeSynchSignal signal) {
        if (signal.getSource() != this && this.fTrace != null) {
            ITmfTimestamp selectedTime = signal.getBeginTime().normalize(0L, -9);
            ITmfTimestamp selectedEndTime = signal.getEndTime().normalize(0L, -9);
            this.setSelectionBeginTime(selectedTime.getValue());
            this.setSelectionEndTime(selectedEndTime.getValue());
        }
    }

    @TmfSignalHandler
    public void timeRangeUpdated(TmfRangeSynchSignal signal) {
        if (this.fTrace != null) {
            TmfTimeRange range = signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange());
            if (range == null) {
                return;
            }
            if (signal.getSource() != this) {
                long windowStartTime = range.getStartTime().normalize(0L, -9).getValue();
                long windowEndTime = range.getEndTime().normalize(0L, -9).getValue();
                long windowDuration = windowEndTime - windowStartTime;
                this.setWindowStartTime(windowStartTime);
                this.setWindowEndTime(windowEndTime);
                this.setWindowDuration(windowDuration);
            }
        }
    }

    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getRange();
        long traceStartTime = fullRange.getStartTime().normalize(0L, -9).getValue();
        long traceEndTime = fullRange.getEndTime().normalize(0L, -9).getValue();
        this.setStartTime(traceStartTime);
        this.setEndTime(traceEndTime);
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getTrace().getTimeRange();
        long traceStartTime = fullRange.getStartTime().normalize(0L, -9).getValue();
        long traceEndTime = fullRange.getEndTime().normalize(0L, -9).getValue();
        this.setStartTime(traceStartTime);
        this.setEndTime(traceEndTime);
    }
}

