/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.xycharts.barcharts;

import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.TmfChartTimeStampFormat;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.barcharts.TmfHistogramTooltipProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.swtchart.Chart;
import org.swtchart.IAxisTick;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public abstract class TmfBarChartViewer
extends TmfXYChartViewer {
    public static final int MINIMUM_BAR_WIDTH = 1;
    private final List<String> seriesNames = new ArrayList<String>();
    private final List<RGB> colors = new ArrayList<RGB>();
    private int fBarWidth = 1;

    public TmfBarChartViewer(Composite parent, String title, String xLabel, String yLabel, int barWidth) {
        super(parent, title, xLabel, yLabel);
        this.fBarWidth = barWidth;
        this.setTooltipProvider(new TmfHistogramTooltipProvider(this));
    }

    @Override
    protected void updateContent() {
        TmfBarChartViewer.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Chart swtChart = TmfBarChartViewer.this.getSwtChart();
                int numRequests = swtChart.getPlotArea().getBounds().width / TmfBarChartViewer.this.fBarWidth;
                int i = 0;
                while (i < TmfBarChartViewer.this.seriesNames.size()) {
                    ISeries series = swtChart.getSeriesSet().getSeries((String)TmfBarChartViewer.this.seriesNames.get(i));
                    if (series == null) {
                        series = TmfBarChartViewer.this.initSeries((String)TmfBarChartViewer.this.seriesNames.get(i), (RGB)TmfBarChartViewer.this.colors.get(i));
                    }
                    TmfBarChartViewer.this.readData(series, TmfBarChartViewer.this.getWindowStartTime(), TmfBarChartViewer.this.getWindowEndTime(), numRequests);
                    ++i;
                }
            }
        });
    }

    protected void addSeries(String name, RGB color) {
        this.seriesNames.add(name);
        this.colors.add(color);
    }

    protected void clearSeries() {
        this.seriesNames.clear();
        this.colors.clear();
    }

    protected void drawChart(final ISeries series, final double[] x, final double[] y) {
        final Display display = TmfBarChartViewer.getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Chart swtChart = TmfBarChartViewer.this.getSwtChart();
                IAxisTick xTick = swtChart.getAxisSet().getXAxis(0).getTick();
                xTick.setFormat((Format)new TmfChartTimeStampFormat(TmfBarChartViewer.this.getTimeOffset()));
                series.setXSeries(x);
                series.setYSeries(y);
                xTick.setTickMarkStepHint(256);
                swtChart.getAxisSet().adjustRange();
                swtChart.redraw();
            }
        });
    }

    protected final double[] getXAxis(long start, long end, int nb) {
        this.setTimeOffset(start - 1L);
        double[] timestamps = new double[nb];
        long steps = end - start;
        double step = (double)steps / (double)nb;
        double curTime = 1.0;
        int i = 0;
        while (i < nb) {
            timestamps[i] = curTime;
            curTime += step;
            ++i;
        }
        return timestamps;
    }

    protected abstract void readData(ISeries var1, long var2, long var4, int var6);

    private IBarSeries initSeries(String name, RGB color) {
        IBarSeries bs = (IBarSeries)this.getSwtChart().getSeriesSet().createSeries(ISeries.SeriesType.BAR, name);
        bs.enableStack(true);
        bs.setBarColor(new Color((Device)Display.getDefault(), color));
        bs.setBarPadding(0);
        return bs;
    }
}

