/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import java.util.Arrays;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IImage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;

public class ExecutionOccurrence
extends BasicExecutionOccurrence
implements ITimeRange {
    private int[] fFillRGB;
    private int[] fStrokeRGB;
    private IImage fImage;
    private IImage fEllipsesImage;
    private ITmfTimestamp fStartTime;
    private ITmfTimestamp fEndTime;
    private boolean fHasTimeInfo;

    @Override
    public void setLifeline(Lifeline theLifeline) {
        super.setLifeline(theLifeline);
        if (this.getLifeline() != null && this.fHasTimeInfo) {
            this.getLifeline().setTimeInfo(true);
            if (this.getLifeline().getFrame() != null) {
                this.getLifeline().getFrame().setHasTimeInfo(true);
            }
        }
    }

    public void setFillColor(int red, int green, int blue) {
        this.fFillRGB = new int[3];
        this.fFillRGB[0] = red;
        this.fFillRGB[1] = green;
        this.fFillRGB[2] = blue;
    }

    public void setStrokeColor(int red, int green, int blue) {
        this.fStrokeRGB = new int[3];
        this.fStrokeRGB[0] = red;
        this.fStrokeRGB[1] = green;
        this.fStrokeRGB[2] = blue;
    }

    public void setImage(IImage image) {
        this.fImage = image;
    }

    public void setTopEllipsesImage(IImage image) {
        this.fEllipsesImage = image;
    }

    public void setStartTime(ITmfTimestamp time) {
        this.fStartTime = time;
        this.fHasTimeInfo = true;
        if (this.getLifeline() != null) {
            this.getLifeline().setTimeInfo(true);
        }
    }

    public void setEndTime(ITmfTimestamp time) {
        this.fEndTime = time;
        this.fHasTimeInfo = true;
        if (this.getLifeline() != null) {
            this.getLifeline().setTimeInfo(true);
        }
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    @Override
    public boolean hasTimeInfo() {
        return this.fHasTimeInfo;
    }

    public int[] getFillRGB() {
        if (this.fFillRGB == null) {
            return null;
        }
        return Arrays.copyOf(this.fFillRGB, this.fFillRGB.length);
    }

    public int[] getStrokeRGB() {
        if (this.fStrokeRGB == null) {
            return null;
        }
        return Arrays.copyOf(this.fStrokeRGB, this.fStrokeRGB.length);
    }

    protected IImage getImage() {
        return this.fImage;
    }

    protected IImage getEllipsesImage() {
        return this.fEllipsesImage;
    }

    @Override
    public void draw(IGC context) {
        super.draw(context);
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.fImage != null) {
            context.drawImage(this.fImage, x + width - 4, y + height - 11, 8, 11);
        }
        if (this.fEllipsesImage != null) {
            context.drawImage(this.fEllipsesImage, x + width, y, 40, 10);
        }
    }

    @Override
    protected IColor setUnselectedFillColor(IGC context) {
        SDViewPref pref = SDViewPref.getInstance();
        if (this.fFillRGB != null) {
            IColor tempFillColor = context.createColor(this.fFillRGB[0], this.fFillRGB[1], this.fFillRGB[2]);
            if (pref.useGradienColor()) {
                context.setGradientColor(tempFillColor);
                context.setForeground(pref.getForeGroundColor("PREF_EXEC"));
                context.setBackground(pref.getBackGroundColor("PREF_FRAME"));
            } else {
                context.setBackground(tempFillColor);
            }
            return tempFillColor;
        }
        return super.setUnselectedFillColor(context);
    }

    @Override
    protected IColor setUnselectedStrokeColor(IGC context) {
        if (this.fStrokeRGB != null) {
            IColor tempStrokeColor = context.createColor(this.fStrokeRGB[0], this.fStrokeRGB[1], this.fStrokeRGB[2]);
            context.setForeground(tempStrokeColor);
            return tempStrokeColor;
        }
        return super.setUnselectedStrokeColor(context);
    }

    public void setHasTimeInfo(boolean hasTimeInfo) {
        this.fHasTimeInfo = hasTimeInfo;
    }
}

