/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs;

import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDGraphNodeSupporter;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TabContents
extends Composite {
    private Button fLifelineButton;
    private Button fStopButton = null;
    private Button fSynMessageButton = null;
    private Button fSynMessageReturnButton = null;
    private Button fAsynMessageButton = null;
    private Button fAsynMessageReturnButton = null;
    private Combo fSearchText = null;
    private Button fCaseSensitive = null;
    private Label fResult = null;
    private Button fParentOkButton = null;

    public TabContents(Composite parent, ISDGraphNodeSupporter provider, Button okButton, String[] expressionList) {
        super(parent, 0);
        String nodeName;
        this.fParentOkButton = okButton;
        this.setLayout((Layout)new GridLayout());
        GraphNodeTypeListener graphNodeTypeListener = new GraphNodeTypeListener();
        ExpressionListener expressionListener = new ExpressionListener();
        Label searchTitle = new Label((Composite)this, 16384);
        searchTitle.setText(Messages.SequenceDiagram_MatchingString);
        Composite searchPart = new Composite((Composite)this, 0);
        GridData searchPartData = new GridData(272);
        GridLayout searchPartLayout = new GridLayout();
        searchPartLayout.numColumns = 2;
        searchPart.setLayout((Layout)searchPartLayout);
        searchPart.setLayoutData((Object)searchPartData);
        this.fSearchText = new Combo(searchPart, 4);
        GridData comboData = new GridData(1808);
        this.fSearchText.setLayoutData((Object)comboData);
        if (expressionList != null) {
            int i = 0;
            while (i < expressionList.length) {
                this.fSearchText.add(expressionList[i]);
                ++i;
            }
        }
        this.fSearchText.addModifyListener((ModifyListener)expressionListener);
        this.fCaseSensitive = new Button(searchPart, 32);
        this.fCaseSensitive.setText(Messages.SequenceDiagram_CaseSensitive);
        Group kindSelection = new Group((Composite)this, 32);
        kindSelection.setText(Messages.SequenceDiagram_SearchFor);
        GridLayout kindSelectionLayout = new GridLayout();
        kindSelectionLayout.numColumns = 1;
        kindSelection.setLayout((Layout)kindSelectionLayout);
        GridData kindSelectionData = new GridData(784);
        kindSelection.setLayoutData((Object)kindSelectionData);
        if (provider != null && provider.isNodeSupported(0)) {
            this.fLifelineButton = new Button((Composite)kindSelection, 32);
            nodeName = provider.getNodeName(0, null);
            if (nodeName != null) {
                this.fLifelineButton.setText(nodeName);
            } else {
                this.fLifelineButton.setText(Messages.SequenceDiagram_Lifeline);
            }
            this.fLifelineButton.setEnabled(true);
            this.fLifelineButton.addSelectionListener((SelectionListener)graphNodeTypeListener);
        }
        if (provider != null && provider.isNodeSupported(5)) {
            this.fStopButton = new Button((Composite)kindSelection, 32);
            nodeName = provider.getNodeName(5, null);
            if (nodeName != null) {
                this.fStopButton.setText(nodeName);
            } else {
                this.fStopButton.setText(Messages.SequenceDiagram_Stop);
            }
            this.fStopButton.setEnabled(true);
            this.fStopButton.addSelectionListener((SelectionListener)graphNodeTypeListener);
        }
        if (provider != null && provider.isNodeSupported(1)) {
            this.fSynMessageButton = new Button((Composite)kindSelection, 32);
            nodeName = provider.getNodeName(1, null);
            if (nodeName != null) {
                this.fSynMessageButton.setText(nodeName);
            } else {
                this.fSynMessageButton.setText(Messages.SequenceDiagram_SynchronousMessage);
            }
            this.fSynMessageButton.setEnabled(true);
            this.fSynMessageButton.addSelectionListener((SelectionListener)graphNodeTypeListener);
        }
        if (provider != null && provider.isNodeSupported(2)) {
            this.fSynMessageReturnButton = new Button((Composite)kindSelection, 32);
            nodeName = provider.getNodeName(2, null);
            if (nodeName != null) {
                this.fSynMessageReturnButton.setText(nodeName);
            } else {
                this.fSynMessageReturnButton.setText(Messages.SequenceDiagram_SynchronousMessageReturn);
            }
            this.fSynMessageReturnButton.setEnabled(true);
            this.fSynMessageReturnButton.addSelectionListener((SelectionListener)graphNodeTypeListener);
        }
        if (provider != null && provider.isNodeSupported(3)) {
            this.fAsynMessageButton = new Button((Composite)kindSelection, 32);
            nodeName = provider.getNodeName(3, null);
            if (nodeName != null) {
                this.fAsynMessageButton.setText(nodeName);
            } else {
                this.fAsynMessageButton.setText(Messages.SequenceDiagram_AsynchronousMessage);
            }
            this.fAsynMessageButton.setEnabled(true);
            this.fAsynMessageButton.addSelectionListener((SelectionListener)graphNodeTypeListener);
        }
        if (provider != null && provider.isNodeSupported(4)) {
            this.fAsynMessageReturnButton = new Button((Composite)kindSelection, 32);
            nodeName = provider.getNodeName(4, null);
            if (nodeName != null) {
                this.fAsynMessageReturnButton.setText(nodeName);
            } else {
                this.fAsynMessageReturnButton.setText(Messages.SequenceDiagram_AsynchronousMessageReturn);
            }
            this.fAsynMessageReturnButton.setEnabled(true);
            this.fAsynMessageReturnButton.addSelectionListener((SelectionListener)graphNodeTypeListener);
        }
        this.fResult = new Label((Composite)this, 16384);
        this.fResult.setText(Messages.SequenceDiagram_StringNotFound);
        this.fResult.setVisible(false);
    }

    public void setResult(boolean found) {
        this.fResult.setVisible(!found);
    }

    public void updateOkButton() {
        if (this.fParentOkButton == null) {
            return;
        }
        boolean enabled = this.fSearchText.getText() != null && !this.fSearchText.getText().equals("") && (this.isLifelineButtonSelected() || this.isStopButtonSelected() || this.isSynMessageButtonSelected() || this.isSynMessageReturnButtonSelected() || this.isAsynMessageButtonSelected() || this.isAsynMessageReturnButtonSelected());
        this.fParentOkButton.setEnabled(enabled);
    }

    public void setOkButton(Button okButton) {
        this.fParentOkButton = okButton;
    }

    public boolean isAsynMessageButtonSelected() {
        if (this.fAsynMessageButton != null) {
            return this.fAsynMessageButton.getSelection();
        }
        return false;
    }

    public boolean isAsynMessageReturnButtonSelected() {
        if (this.fAsynMessageReturnButton != null) {
            return this.fAsynMessageReturnButton.getSelection();
        }
        return false;
    }

    public boolean isCaseSensitiveSelected() {
        if (this.fCaseSensitive != null) {
            return this.fCaseSensitive.getSelection();
        }
        return false;
    }

    public boolean isLifelineButtonSelected() {
        if (this.fLifelineButton != null) {
            return this.fLifelineButton.getSelection();
        }
        return false;
    }

    public String getSearchText() {
        return this.fSearchText.getText();
    }

    public boolean isStopButtonSelected() {
        if (this.fStopButton != null) {
            return this.fStopButton.getSelection();
        }
        return false;
    }

    public boolean isSynMessageButtonSelected() {
        if (this.fSynMessageButton != null) {
            return this.fSynMessageButton.getSelection();
        }
        return false;
    }

    public boolean isSynMessageReturnButtonSelected() {
        if (this.fSynMessageReturnButton != null) {
            return this.fSynMessageReturnButton.getSelection();
        }
        return false;
    }

    public void setAsynMessageButtonSelection(boolean state) {
        if (this.fAsynMessageButton != null) {
            this.fAsynMessageButton.setSelection(state);
        }
    }

    public void setAsynMessageReturnButtonSelection(boolean state) {
        if (this.fAsynMessageReturnButton != null) {
            this.fAsynMessageReturnButton.setSelection(state);
        }
    }

    public void setCaseSensitiveSelection(boolean state) {
        if (this.fCaseSensitive != null) {
            this.fCaseSensitive.setSelection(state);
        }
    }

    public void setLifelineButtonSelection(boolean state) {
        if (this.fLifelineButton != null) {
            this.fLifelineButton.setSelection(state);
        }
    }

    public void setSearchText(String text) {
        this.fSearchText.setText(text);
    }

    public void setStopButtonSelection(boolean state) {
        if (this.fStopButton != null) {
            this.fStopButton.setSelection(state);
        }
    }

    public void setSynMessageButtonSelection(boolean state) {
        if (this.fSynMessageButton != null) {
            this.fSynMessageButton.setSelection(state);
        }
    }

    public void setSynMessageReturnButtonSelection(boolean state) {
        if (this.fSynMessageReturnButton != null) {
            this.fSynMessageReturnButton.setSelection(state);
        }
    }

    protected class ExpressionListener
    implements ModifyListener {
        protected ExpressionListener() {
        }

        public void modifyText(ModifyEvent e) {
            TabContents.this.updateOkButton();
        }
    }

    protected class GraphNodeTypeListener
    implements SelectionListener {
        protected GraphNodeTypeListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TabContents.this.updateOkButton();
        }
    }
}

