/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.BaseSDAction;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;

public class Zoom
extends BaseSDAction {
    public static final String ZOOM_IN_ID = "org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ZoomInCoolBar";
    public static final String ZOOM_OUT_ID = "org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ZoomOutCoolBar";
    public static final String RESET_ZOOM_ID = "org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ResetZoom";
    public static final String NO_ZOOM_ID = "org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.NoZoom";
    private boolean fLastZoomIn = false;
    private boolean fLastZoomOut = false;
    private final Cursor fZoomInCursor = new Cursor((Device)Display.getCurrent(), Activator.getDefault().getImageFromImageRegistry("icons/obj16/zoomin_obj.bmp").getImageData(), Activator.getDefault().getImageFromImageRegistry("icons/obj16/zoom_mask.bmp").getImageData(), 0, 0);
    private final Cursor fZoomOutCursor = new Cursor((Device)Display.getCurrent(), Activator.getDefault().getImageFromImageRegistry("icons/obj16/zoomout_obj.bmp").getImageData(), Activator.getDefault().getImageFromImageRegistry("icons/obj16/zoom_mask.bmp").getImageData(), 0, 0);

    public Zoom(SDView view, ZoomType type) {
        super(view, "", 8);
        switch (type) {
            case ZOOM_IN: {
                this.setText(Messages.SequenceDiagram_ZoomIn);
                this.setToolTipText(Messages.SequenceDiagram_ZoomInTheDiagram);
                this.setId(ZOOM_IN_ID);
                this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomin_nav.gif"));
                break;
            }
            case ZOOM_OUT: {
                this.setText(Messages.SequenceDiagram_ZoomOut);
                this.setToolTipText(Messages.SequenceDiagram_ZoomOutTheDiagram);
                this.setId(ZOOM_OUT_ID);
                this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomout_nav.gif"));
                break;
            }
            case ZOOM_RESET: {
                this.setText(Messages.SequenceDiagram_ResetZoomFactor);
                this.setToolTipText(Messages.SequenceDiagram_ResetZoomFactor);
                this.setId(RESET_ZOOM_ID);
                this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/home_nav.gif"));
                break;
            }
            default: {
                this.setText(Messages.SequenceDiagram_Select);
                this.setToolTipText(Messages.SequenceDiagram_Select);
                this.setId(NO_ZOOM_ID);
                this.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/select_menu.gif"));
            }
        }
    }

    public void run() {
        if (this.getView() == null || this.getView().getSDWidget() == null) {
            return;
        }
        SDWidget viewer = this.getView().getSDWidget();
        if (this.getId().equals(ZOOM_OUT_ID)) {
            if (this.fLastZoomOut == this.isChecked()) {
                this.setChecked(!this.isChecked());
            }
            viewer.setZoomOutMode(this.isChecked());
            this.fLastZoomOut = this.isChecked();
            if (this.isChecked()) {
                viewer.setCursor(this.fZoomOutCursor);
                this.setActionChecked(NO_ZOOM_ID, false);
            } else {
                viewer.setCursor(new Cursor((Device)Display.getDefault(), 0));
                this.setActionChecked(NO_ZOOM_ID, true);
            }
        } else if (this.getId().equals(ZOOM_IN_ID)) {
            if (this.fLastZoomIn == this.isChecked()) {
                this.setChecked(!this.isChecked());
            }
            viewer.setZoomInMode(this.isChecked());
            this.fLastZoomIn = this.isChecked();
            if (this.isChecked()) {
                viewer.setCursor(this.fZoomInCursor);
                this.setActionChecked(NO_ZOOM_ID, false);
            } else {
                viewer.setCursor(new Cursor((Device)Display.getDefault(), 0));
                this.setActionChecked(NO_ZOOM_ID, true);
            }
        } else if (this.getId().equals(RESET_ZOOM_ID)) {
            viewer.resetZoomFactor();
            this.setChecked(false);
            this.setActionChecked(NO_ZOOM_ID, true);
        } else if (this.getId().equals(NO_ZOOM_ID)) {
            this.setChecked(true);
            viewer.setZoomInMode(false);
            viewer.setZoomInMode(false);
            viewer.setCursor(new Cursor((Device)Display.getDefault(), 0));
        }
    }

    protected void setActionChecked(String id, boolean checked) {
        if (this.getView() != null) {
            IAction action;
            IActionBars bar = this.getView().getViewSite().getActionBars();
            if (bar == null) {
                return;
            }
            IToolBarManager barManager = bar.getToolBarManager();
            if (barManager == null) {
                return;
            }
            IContributionItem nextPage = barManager.find(id);
            if (nextPage instanceof ActionContributionItem && (action = ((ActionContributionItem)nextPage).getAction()) != null) {
                action.setChecked(checked);
            }
        }
    }

    public void dispose() {
        this.fZoomInCursor.dispose();
        this.fZoomOutCursor.dispose();
    }

    public static enum ZoomType {
        ZOOM_NONE,
        ZOOM_IN,
        ZOOM_OUT,
        ZOOM_RESET;

    }
}

