/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.breakpoints;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.dsf.debug.ui.actions.AbstractDisassemblyBreakpointsTarget;
import org.eclipse.cdt.dsf.gdb.internal.ui.breakpoints.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;

public class DisassemblyToggleDynamicPrintfTarget
extends AbstractDisassemblyBreakpointsTarget {
    protected void createLineBreakpoint(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        String printfStr = NLS.bind((String)Messages.Default_LineDynamicPrintf_String, (Object)DisassemblyToggleDynamicPrintfTarget.escapeBackslashes(sourceHandle), (Object)lineNumber);
        CDIDebugModel.createLineDynamicPrintf((String)sourceHandle, (IResource)resource, (int)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"", (String)printfStr, (boolean)true);
    }

    protected void createLineBreakpointInteractive(IWorkbenchPart part, String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        ICDynamicPrintf dprintf = (ICDynamicPrintf)CDIDebugModel.createBlankLineDynamicPrintf();
        HashMap<String, String> attributes = new HashMap<String, String>();
        CDIDebugModel.setLineBreakpointAttributes(attributes, (String)sourceHandle, (Integer)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"");
        attributes.put("org.eclipse.cdt.debug.core.printf_string", NLS.bind((String)Messages.Default_LineDynamicPrintf_String, (Object)DisassemblyToggleDynamicPrintfTarget.escapeBackslashes(sourceHandle), (Object)lineNumber));
        this.openBreakpointPropertiesDialog((ICBreakpoint)dprintf, part, resource, attributes);
    }

    protected void createAddressBreakpoint(IResource resource, IAddress address) throws CoreException {
        String printfStr = NLS.bind((String)Messages.Default_AddressDynamicPrintf_String, (Object)address);
        CDIDebugModel.createAddressDynamicPrintf(null, null, (IResource)resource, (int)this.getBreakpointType(), (int)-1, (IAddress)address, (boolean)true, (int)0, (String)"", (String)printfStr, (boolean)true);
    }

    protected void createAddressBreakpointInteractive(IWorkbenchPart part, IResource resource, IAddress address) throws CoreException {
        ICDynamicPrintf dprintf = (ICDynamicPrintf)CDIDebugModel.createBlankAddressDynamicPrintf();
        HashMap<String, String> attributes = new HashMap<String, String>();
        CDIDebugModel.setAddressBreakpointAttributes(attributes, null, null, (int)this.getBreakpointType(), (int)-1, (IAddress)address, (boolean)true, (int)0, (String)"");
        attributes.put("org.eclipse.cdt.debug.core.printf_string", NLS.bind((String)Messages.Default_AddressDynamicPrintf_String, (Object)address));
        this.openBreakpointPropertiesDialog((ICBreakpoint)dprintf, part, resource, attributes);
    }

    protected int getBreakpointType() {
        return 0;
    }

    private static String escapeBackslashes(String str) {
        return str.replaceAll(Pattern.quote("\\"), "\\\\\\\\");
    }
}

