/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ctf.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.CTFCallsite;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.tmf.core.event.ITmfCustomAttributes;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.event.lookup.ITmfModelLookup;
import org.eclipse.linuxtools.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfCallsite;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfEventField;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfEventType;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTrace;

public class CtfTmfEvent
extends TmfEvent
implements ITmfSourceLookup,
ITmfModelLookup,
ITmfCustomAttributes {
    private static final String EMPTY_CTF_EVENT_NAME = "Empty CTF event";
    private final int fSourceCPU;
    private final long fTypeId;
    private final String fEventName;
    private final IEventDeclaration fEventDeclaration;
    @NonNull
    private final EventDefinition fEvent;
    private ITmfEventField fContent;

    CtfTmfEvent(CtfTmfTrace trace, long rank, CtfTmfTimestamp timestamp, String fileName, int cpu, IEventDeclaration declaration, @NonNull EventDefinition eventDefinition) {
        super((ITmfTrace)trace, rank, (ITmfTimestamp)timestamp, String.valueOf(cpu), null, null, fileName);
        this.fEventDeclaration = declaration;
        this.fSourceCPU = cpu;
        this.fTypeId = declaration.getId();
        this.fEventName = declaration.getName();
        this.fEvent = eventDefinition;
    }

    public CtfTmfEvent() {
        super(null, -1L, (ITmfTimestamp)new CtfTmfTimestamp(-1L), null, null, (ITmfEventField)new TmfEventField("", null, (ITmfEventField[])new CtfTmfEventField[0]), null);
        this.fSourceCPU = -1;
        this.fTypeId = -1L;
        this.fEventName = EMPTY_CTF_EVENT_NAME;
        this.fEventDeclaration = null;
        this.fEvent = EventDefinition.NULL_EVENT;
    }

    public int getCPU() {
        return this.fSourceCPU;
    }

    public long getID() {
        return this.fTypeId;
    }

    public CtfTmfTrace getTrace() {
        return (CtfTmfTrace)super.getTrace();
    }

    public ITmfEventType getType() {
        CtfTmfEventType ctfTmfEventType = CtfTmfEventType.get(this.getTrace(), this.fEventName);
        if (ctfTmfEventType == null) {
            ctfTmfEventType = new CtfTmfEventType(this.fEventName, (ITmfTrace)this.getTrace(), this.getContent());
        }
        return ctfTmfEventType;
    }

    public Set<String> listCustomAttributes() {
        if (this.fEventDeclaration == null) {
            return new HashSet<String>();
        }
        return this.fEventDeclaration.getCustomAttributes();
    }

    public String getCustomAttribute(String name) {
        if (this.fEventDeclaration == null) {
            return null;
        }
        return this.fEventDeclaration.getCustomAttribute(name);
    }

    public CtfTmfCallsite getCallsite() {
        ITmfEventField ipField;
        CTFCallsite callsite = null;
        CtfTmfTrace trace = this.getTrace();
        if (trace == null) {
            return null;
        }
        CTFTrace ctfTrace = trace.getCTFTrace();
        if (ctfTrace == null) {
            return null;
        }
        if (this.getContent() != null && (ipField = this.getContent().getField("context._ip")) != null && ipField.getValue() instanceof Long) {
            long ip = (Long)ipField.getValue();
            callsite = ctfTrace.getCallsite(this.fEventName, ip);
        }
        if (callsite == null) {
            callsite = ctfTrace.getCallsite(this.fEventName);
        }
        if (callsite != null) {
            return new CtfTmfCallsite(callsite);
        }
        return null;
    }

    public String getModelUri() {
        return this.getCustomAttribute("model.emf.uri");
    }

    public synchronized ITmfEventField getContent() {
        if (this.fContent == null) {
            this.fContent = new TmfEventField(":root:", null, (ITmfEventField[])CtfTmfEvent.parseFields(this.fEvent));
        }
        return this.fContent;
    }

    private static CtfTmfEventField[] parseFields(@NonNull EventDefinition eventDef) {
        StructDefinition structContext;
        ArrayList<CtfTmfEventField> fields = new ArrayList<CtfTmfEventField>();
        StructDefinition structFields = eventDef.getFields();
        if (structFields != null && structFields.getFieldNames() != null) {
            for (String curFieldName : structFields.getFieldNames()) {
                fields.add(CtfTmfEventField.parseField((IDefinition)structFields.getDefinition(curFieldName), curFieldName));
            }
        }
        if ((structContext = eventDef.getContext()) != null) {
            for (String contextName : structContext.getFieldNames()) {
                String curContextName = "context." + contextName;
                fields.add(CtfTmfEventField.parseField((IDefinition)structContext.getDefinition(contextName), curContextName));
            }
        }
        return fields.toArray(new CtfTmfEventField[fields.size()]);
    }
}

