/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.eclipse.EclipseVPG;
import org.eclipse.photran.internal.core.vpg.eclipse.VPGSchedulingRule;
import org.eclipse.photran.internal.ui.actions.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class VPGWindowActionDelegate
implements IWorkbenchWindowActionDelegate,
IRunnableWithProgress {
    private EclipseVPG vpg = null;
    protected IWorkbenchWindow activeWindow = null;
    protected Shell activeShell = null;

    public final void init(IWorkbenchWindow window) {
        this.activeWindow = window;
        if (this.activeWindow != null) {
            this.activeShell = this.activeWindow.getShell();
        }
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public final void run(IAction action) {
        this.vpg = PhotranVPG.getInstance();
        this.scheduleThisUsingVPGSchedulingRule();
    }

    private void scheduleThisUsingVPGSchedulingRule() {
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        IWorkspaceRoot lockEntireWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        VPGSchedulingRule vpgSched = VPGSchedulingRule.getInstance();
        ISchedulingRule schedulingRule = MultiRule.combine((ISchedulingRule)lockEntireWorkspace, (ISchedulingRule)vpgSched);
        try {
            context.runInUI((IRunnableContext)context, (IRunnableWithProgress)this, schedulingRule);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.activeShell, (String)Messages.VPGWindowActionDelegate_UnhandledExceptionTitle, (String)e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    public final void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                this.run(this.vpg, progressMonitor);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    protected abstract void run(EclipseVPG var1, IProgressMonitor var2) throws Exception;

    protected Shell getShell() {
        return this.activeShell;
    }
}

