/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public final class EnumDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    private final EnumTable fTable = new EnumTable();
    private final IntegerDeclaration fContainerType;
    private final Set<String> fLabels = new HashSet<String>();

    public EnumDeclaration(IntegerDeclaration containerType) {
        this.fContainerType = containerType;
    }

    public IntegerDeclaration getContainerType() {
        return this.fContainerType;
    }

    @Override
    public long getAlignment() {
        return this.getContainerType().getAlignment();
    }

    @Override
    public int getMaximumSize() {
        return this.fContainerType.getMaximumSize();
    }

    @Override
    public EnumDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        IntegerDefinition value = this.getContainerType().createDefinition(definitionScope, fieldName, input);
        return new EnumDefinition(this, definitionScope, fieldName, value);
    }

    public boolean add(long low, long high, String label) {
        this.fLabels.add(label);
        return this.fTable.add(low, high, label);
    }

    public String query(long value) {
        return this.fTable.query(value);
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.fLabels);
    }

    public String toString() {
        return "[declaration] enum[" + Integer.toHexString(this.hashCode()) + ']';
    }

    private class EnumTable {
        private final List<LabelAndRange> ranges = new LinkedList<LabelAndRange>();

        public boolean add(long low, long high, String label) {
            LabelAndRange newRange = new LabelAndRange(low, high, label);
            for (LabelAndRange r : this.ranges) {
                if (!r.intersects(newRange)) continue;
                return false;
            }
            this.ranges.add(newRange);
            return true;
        }

        public String query(long value) {
            for (LabelAndRange r : this.ranges) {
                if (!r.intersects(value)) continue;
                return r.getLabel();
            }
            return null;
        }
    }

    private static class LabelAndRange {
        private final long low;
        private final long high;
        private final String fLabel;

        public String getLabel() {
            return this.fLabel;
        }

        public LabelAndRange(long low, long high, String str) {
            this.low = low;
            this.high = high;
            this.fLabel = str;
        }

        public boolean intersects(long i) {
            return i >= this.low && i <= this.high;
        }

        public boolean intersects(LabelAndRange other) {
            return this.intersects(other.low) || this.intersects(other.high);
        }
    }
}

