/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.math.BigInteger;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.Encoding;
import org.eclipse.linuxtools.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

@NonNullByDefault
public class IntegerDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    public static final IntegerDeclaration UINT_32B_DECL = new IntegerDeclaration(32, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_32L_DECL = new IntegerDeclaration(32, false, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration INT_32B_DECL = new IntegerDeclaration(32, true, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration INT_32L_DECL = new IntegerDeclaration(32, true, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration UINT_64B_DECL = new IntegerDeclaration(64, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_64L_DECL = new IntegerDeclaration(64, false, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration INT_64B_DECL = new IntegerDeclaration(64, true, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration INT_64L_DECL = new IntegerDeclaration(64, true, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration UINT_8_DECL = new IntegerDeclaration(8, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration INT_8_DECL = new IntegerDeclaration(8, true, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_5B_DECL = new IntegerDeclaration(5, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_5L_DECL = new IntegerDeclaration(5, false, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration UINT_27B_DECL = new IntegerDeclaration(27, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_27L_DECL = new IntegerDeclaration(27, false, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration UINT_16B_DECL = new IntegerDeclaration(16, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_16L_DECL = new IntegerDeclaration(16, false, ByteOrder.LITTLE_ENDIAN);
    private final int fLength;
    private final boolean fSigned;
    private final int fBase;
    private final ByteOrder fByteOrder;
    private final Encoding fEncoding;
    private final long fAlignment;
    private final String fClock;

    public static IntegerDeclaration createDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment) {
        if (encoding.equals((Object)Encoding.NONE) && alignment == 8L && clock.equals("") && base == 10) {
            switch (len) {
                case 5: {
                    if (signed) break;
                    if (byteOrder != null && byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
                        return UINT_5B_DECL;
                    }
                    return UINT_5L_DECL;
                }
                case 8: {
                    return signed ? INT_8_DECL : UINT_8_DECL;
                }
                case 16: {
                    if (signed) break;
                    if (byteOrder != null && byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
                        return UINT_16B_DECL;
                    }
                    return UINT_16L_DECL;
                }
                case 27: {
                    if (signed) break;
                    if (byteOrder != null && byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
                        return UINT_27B_DECL;
                    }
                    return UINT_27L_DECL;
                }
                case 32: {
                    if (signed) {
                        if (byteOrder != null && byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
                            return INT_32B_DECL;
                        }
                        return INT_32L_DECL;
                    }
                    if (byteOrder != null && byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
                        return UINT_32B_DECL;
                    }
                    return UINT_32L_DECL;
                }
                case 64: {
                    if (signed) {
                        if (byteOrder != null && byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
                            return INT_64B_DECL;
                        }
                        return INT_64L_DECL;
                    }
                    if (byteOrder != null && byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
                        return UINT_64B_DECL;
                    }
                    return UINT_64L_DECL;
                }
            }
        }
        return new IntegerDeclaration(len, signed, base, byteOrder, encoding, clock, alignment);
    }

    private IntegerDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment) {
        ByteOrder actualByteOrder;
        if (len <= 0 || len == 1 && signed) {
            throw new IllegalArgumentException();
        }
        this.fLength = len;
        this.fSigned = signed;
        this.fBase = base;
        this.fByteOrder = actualByteOrder = byteOrder == null ? ByteOrder.nativeOrder() : byteOrder;
        this.fEncoding = encoding;
        this.fClock = clock;
        this.fAlignment = Math.max(alignment, 1L);
    }

    private IntegerDeclaration(int len, boolean signed, @Nullable ByteOrder byteOrder) {
        this(len, signed, 10, byteOrder, Encoding.NONE, "", 8L);
    }

    public boolean isSigned() {
        return this.fSigned;
    }

    public int getBase() {
        return this.fBase;
    }

    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public Encoding getEncoding() {
        return this.fEncoding;
    }

    public boolean isCharacter() {
        return this.fLength == 8 && this.fEncoding != Encoding.NONE;
    }

    public boolean isUnsignedByte() {
        return this.fLength == 8 && !this.fSigned;
    }

    public int getLength() {
        return this.fLength;
    }

    @Override
    public long getAlignment() {
        return this.fAlignment;
    }

    public String getClock() {
        return this.fClock;
    }

    @Override
    public int getMaximumSize() {
        return this.fLength;
    }

    @Override
    public IntegerDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFReaderException {
        ByteOrder byteOrder = input.getByteOrder();
        input.setByteOrder(this.fByteOrder);
        long value = this.read(input);
        input.setByteOrder(byteOrder);
        return new IntegerDefinition(this, definitionScope, fieldName, value);
    }

    public String toString() {
        return "[declaration] integer[" + Integer.toHexString(this.hashCode()) + ']';
    }

    public BigInteger getMaxValue() {
        int significantBits = this.fLength - (this.fSigned ? 1 : 0);
        BigInteger ret = BigInteger.ONE.shiftLeft(significantBits).subtract(BigInteger.ONE);
        return ret;
    }

    public BigInteger getMinValue() {
        if (!this.fSigned) {
            BigInteger ret = BigInteger.ZERO;
            return ret;
        }
        int significantBits = this.fLength - 1;
        BigInteger ret = BigInteger.ONE.shiftLeft(significantBits).negate();
        return ret;
    }

    private long read(BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        boolean signed = this.isSigned();
        int length = this.getLength();
        long bits = 0L;
        ByteOrder previousByteOrder = input.getByteOrder();
        if (this.getByteOrder() != input.getByteOrder()) {
            input.setByteOrder(this.getByteOrder());
        }
        if (length > 64) {
            throw new CTFReaderException("Cannot read an integer with over 64 bits. Length given: " + length);
        }
        bits = input.get(length, signed);
        if (previousByteOrder != input.getByteOrder()) {
            input.setByteOrder(previousByteOrder);
        }
        return bits;
    }
}

