/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;

public class StructDeclaration
extends Declaration {
    @NonNull
    private final Map<String, IDeclaration> fFieldMap = new LinkedHashMap<String, IDeclaration>();
    private long fMaxAlign;

    public StructDeclaration(long align) {
        this.fMaxAlign = Math.max(align, 1L);
    }

    public StructDeclaration(String[] names, Declaration[] declarations) {
        this.fMaxAlign = 1L;
        int i = 0;
        while (i < names.length) {
            this.addField(names[i], declarations[i]);
            ++i;
        }
    }

    public long getMaxAlign() {
        return this.fMaxAlign;
    }

    public boolean hasField(String name) {
        return this.fFieldMap.containsKey(name);
    }

    public Map<String, IDeclaration> getFields() {
        return this.fFieldMap;
    }

    @Nullable
    public IDeclaration getField(String fieldName) {
        return this.fFieldMap.get(fieldName);
    }

    public Iterable<String> getFieldsList() {
        return this.fFieldMap.keySet();
    }

    @Override
    public long getAlignment() {
        return this.fMaxAlign;
    }

    @Override
    public int getMaximumSize() {
        int maxSize = 0;
        for (IDeclaration field : this.fFieldMap.values()) {
            maxSize += field.getMaximumSize();
        }
        return Math.min(maxSize, Integer.MAX_VALUE);
    }

    @Override
    public StructDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        Definition[] myFields = new Definition[this.fFieldMap.size()];
        StructDefinition structDefinition = new StructDefinition(this, definitionScope, fieldName, this.fFieldMap.keySet(), myFields);
        this.fillStruct(input, myFields, structDefinition);
        return structDefinition;
    }

    public StructDefinition createDefinition(IDefinitionScope definitionScope, LexicalScope fieldScope, @NonNull BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        Definition[] myFields = new Definition[this.fFieldMap.size()];
        StructDefinition structDefinition = new StructDefinition(this, definitionScope, fieldScope, fieldScope.getName(), this.fFieldMap.keySet(), myFields);
        this.fillStruct(input, myFields, structDefinition);
        return structDefinition;
    }

    public void addField(String name, IDeclaration declaration) {
        this.fFieldMap.put(name, declaration);
        this.fMaxAlign = Math.max(this.fMaxAlign, declaration.getAlignment());
    }

    private void fillStruct(@NonNull BitBuffer input, Definition[] myFields, StructDefinition structDefinition) throws CTFReaderException {
        Iterator<Map.Entry<String, IDeclaration>> iter = this.fFieldMap.entrySet().iterator();
        int i = 0;
        while (i < this.fFieldMap.size()) {
            Map.Entry<String, IDeclaration> entry = iter.next();
            myFields[i] = entry.getValue().createDefinition(structDefinition, entry.getKey(), input);
            ++i;
        }
    }

    public String toString() {
        return "[declaration] struct[" + Integer.toHexString(this.hashCode()) + ']';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fFieldMap.entrySet().hashCode();
        result = 31 * result + (int)(this.fMaxAlign ^ this.fMaxAlign >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructDeclaration)) {
            return false;
        }
        StructDeclaration other = (StructDeclaration)obj;
        if (!this.fFieldMap.entrySet().equals(other.fFieldMap.entrySet())) {
            return false;
        }
        return this.fMaxAlign == other.fMaxAlign;
    }
}

