/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class SafeMappedByteBuffer {
    private static final boolean IS_WIN32 = System.getProperty("os.name").startsWith("Windows");

    public static ByteBuffer map(FileChannel fc, FileChannel.MapMode mode, long position, long size) throws IOException {
        ByteBuffer byteBuffer;
        if (IS_WIN32) {
            byteBuffer = ByteBuffer.allocate((int)size);
            fc.read(byteBuffer, position);
        } else {
            byteBuffer = fc.map(mode, position, size);
        }
        return byteBuffer;
    }
}

