/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event.types;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.internal.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.internal.ctf.core.event.types.ByteArrayDefinition;

public final class ArrayDeclaration
extends CompoundDeclaration {
    private final int fLength;
    private final IDeclaration fElemType;
    private final ArrayListMultimap<String, String> fChildrenNames = ArrayListMultimap.create();

    public ArrayDeclaration(int length, IDeclaration elemType) {
        this.fLength = length;
        this.fElemType = elemType;
    }

    @Override
    public IDeclaration getElementType() {
        return this.fElemType;
    }

    public int getLength() {
        return this.fLength;
    }

    @Override
    public AbstractArrayDefinition createDefinition(IDefinitionScope definitionScope, @NonNull String fieldName, BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        if (this.isString()) {
            byte[] data = new byte[this.fLength];
            input.get(data);
            return new ByteArrayDefinition(this, definitionScope, fieldName, data);
        }
        List<Definition> definitions = this.read(input, definitionScope, fieldName);
        return new ArrayDefinition(this, definitionScope, fieldName, definitions);
    }

    public String toString() {
        return "[declaration] array[" + Integer.toHexString(this.hashCode()) + ']';
    }

    @NonNull
    private List<Definition> read(@NonNull BitBuffer input, IDefinitionScope definitionScope, String fieldName) throws CTFReaderException {
        ImmutableList.Builder definitions = new ImmutableList.Builder();
        if (!this.fChildrenNames.containsKey((Object)fieldName)) {
            int i = 0;
            while (i < this.fLength) {
                this.fChildrenNames.put((Object)fieldName, (Object)(String.valueOf(fieldName) + '[' + i + ']'));
                ++i;
            }
        }
        List elemNames = this.fChildrenNames.get((Object)fieldName);
        int i = 0;
        while (i < this.fLength) {
            String name = (String)elemNames.get(i);
            if (name == null) {
                throw new IllegalStateException();
            }
            definitions.add((Object)this.fElemType.createDefinition(definitionScope, name, input));
            ++i;
        }
        ImmutableList ret = definitions.build();
        return ret;
    }

    @Override
    public int getMaximumSize() {
        long val = (long)this.fLength * (long)this.fElemType.getMaximumSize();
        return (int)Math.min(Integer.MAX_VALUE, val);
    }
}

