/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;

@NonNullByDefault
public final class ArrayDefinition
extends AbstractArrayDefinition {
    private final ImmutableList<Definition> fDefinitions;

    public ArrayDefinition(CompoundDeclaration declaration, @Nullable IDefinitionScope definitionScope, String fieldName, List<Definition> definitions) {
        super(declaration, definitionScope, fieldName);
        ImmutableList list;
        this.fDefinitions = list = ImmutableList.copyOf(definitions);
    }

    @Override
    public List<Definition> getDefinitions() {
        return this.fDefinitions;
    }

    public int getLength() {
        return this.fDefinitions.size();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        Joiner joiner = Joiner.on((String)", ").skipNulls();
        b.append(joiner.join(this.fDefinitions));
        b.append(']');
        String ret = b.toString();
        return ret;
    }
}

