/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event.types;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;

@NonNullByDefault
public final class ByteArrayDefinition
extends AbstractArrayDefinition {
    private final byte[] fContent;
    @Nullable
    private transient List<Definition> fDefs;

    public ByteArrayDefinition(CompoundDeclaration declaration, @Nullable IDefinitionScope definitionScope, String fieldName, byte[] content) {
        super(declaration, definitionScope, fieldName);
        this.fContent = content;
    }

    @Override
    public synchronized List<Definition> getDefinitions() {
        List<Definition> defs = this.fDefs;
        if (defs == null) {
            ImmutableList ret;
            ImmutableList.Builder builder = new ImmutableList.Builder();
            int i = 0;
            while (i < this.fContent.length) {
                IntegerDeclaration charDecl = IntegerDeclaration.UINT_8_DECL;
                String fieldName = String.valueOf(this.getFieldName()) + '[' + i + ']';
                byte fieldValue = this.fContent[i];
                builder.add((Object)new IntegerDefinition(charDecl, this.getDefinitionScope(), fieldName, fieldValue));
                ++i;
            }
            this.fDefs = ret = builder.build();
            return ret;
        }
        return defs;
    }

    @Override
    public String toString() {
        int pos = -1;
        int i = 0;
        while (i < this.fContent.length) {
            if (this.fContent[i] == 0) {
                pos = i;
                break;
            }
            ++i;
        }
        byte[] bytes = pos != -1 ? Arrays.copyOf(this.fContent, pos) : this.fContent;
        return new String(bytes);
    }
}

