/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.analysis.xml.core.model;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.linuxtools.tmf.analysis.xml.core.model.ITmfXmlStateValue;
import org.eclipse.linuxtools.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.w3c.dom.Element;

public abstract class TmfXmlStateValue
implements ITmfXmlStateValue {
    private final TmfXmlStateValueBase fStateValue;
    private final List<ITmfXmlStateAttribute> fPath;
    private final String fEventField;
    private final boolean fIncrement;
    private final ValueTypeStack fStackType;
    private final ITmfStateValue.Type fForcedType;
    private final IXmlStateSystemContainer fContainer;

    protected TmfXmlStateValue(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container, List<ITmfXmlStateAttribute> attributes, String eventField) {
        this.fPath = attributes;
        this.fContainer = container;
        this.fEventField = eventField;
        if (!node.getNodeName().equals("stateValue")) {
            throw new IllegalArgumentException("TmfXmlStateValue constructor: Element is not a stateValue");
        }
        this.fIncrement = Boolean.parseBoolean(node.getAttribute("increment"));
        this.fStateValue = this.initializeStateValue(modelFactory, node);
        switch (node.getAttribute("forcedType")) {
            case "string": {
                this.fForcedType = ITmfStateValue.Type.STRING;
                break;
            }
            case "int": {
                this.fForcedType = ITmfStateValue.Type.INTEGER;
                break;
            }
            case "long": {
                this.fForcedType = ITmfStateValue.Type.LONG;
                break;
            }
            default: {
                this.fForcedType = ITmfStateValue.Type.NULL;
            }
        }
        String stack = node.getAttribute("stack");
        this.fStackType = ValueTypeStack.getTypeFromString(stack);
    }

    protected TmfXmlStateValueBase initializeStateValue(ITmfXmlModelFactory modelFactory, Element node) {
        return new TmfXmlStateValueNull();
    }

    protected IXmlStateSystemContainer getSsContainer() {
        return this.fContainer;
    }

    protected ITmfStateSystem getStateSystem() {
        return this.fContainer.getStateSystem();
    }

    protected boolean isIncrement() {
        return this.fIncrement;
    }

    protected ValueTypeStack getStackType() {
        return this.fStackType;
    }

    protected ITmfStateValue.Type getForcedType() {
        return this.fForcedType;
    }

    @Override
    public ITmfStateValue getValue(@Nullable ITmfEvent event) throws AttributeNotFoundException {
        return this.fStateValue.getValue(event);
    }

    @Override
    public ITmfStateValue getEventFieldValue(@NonNull ITmfEvent event) {
        return this.getEventFieldValue(event, this.fEventField);
    }

    protected ITmfStateValue getEventFieldValue(@NonNull ITmfEvent event, String fieldName) {
        TmfStateValue value = TmfStateValue.nullValue();
        ITmfEventField content = event.getContent();
        if (fieldName.equals("cpu")) {
            return TmfStateValue.newValueInt((int)Integer.valueOf(event.getSource()));
        }
        if (fieldName.equals("timestamp")) {
            return TmfStateValue.newValueLong((long)event.getTimestamp().getValue());
        }
        if (content.getField(fieldName) == null) {
            return value;
        }
        Object field = content.getField(fieldName).getValue();
        if (field instanceof String) {
            String fieldString = (String)field;
            switch (this.fForcedType) {
                case INTEGER: {
                    value = TmfStateValue.newValueInt((int)Integer.parseInt(fieldString));
                    break;
                }
                case LONG: {
                    value = TmfStateValue.newValueLong((long)Long.parseLong(fieldString));
                    break;
                }
                case DOUBLE: {
                    value = TmfStateValue.newValueDouble((double)Double.parseDouble(fieldString));
                    break;
                }
                default: {
                    value = TmfStateValue.newValueString((String)fieldString);
                    break;
                }
            }
        } else if (field instanceof Long) {
            Long fieldLong = (Long)field;
            switch (this.fForcedType) {
                case INTEGER: {
                    value = TmfStateValue.newValueInt((int)fieldLong.intValue());
                    break;
                }
                case STRING: {
                    value = TmfStateValue.newValueString((String)fieldLong.toString());
                    break;
                }
                case DOUBLE: {
                    value = TmfStateValue.newValueDouble((double)fieldLong.doubleValue());
                    break;
                }
                default: {
                    value = TmfStateValue.newValueLong((long)fieldLong);
                    break;
                }
            }
        } else if (field instanceof Integer) {
            Integer fieldInteger = (Integer)field;
            switch (this.fForcedType) {
                case LONG: {
                    value = TmfStateValue.newValueLong((long)fieldInteger.longValue());
                    break;
                }
                case STRING: {
                    value = TmfStateValue.newValueString((String)fieldInteger.toString());
                    break;
                }
                case DOUBLE: {
                    value = TmfStateValue.newValueDouble((double)fieldInteger.doubleValue());
                    break;
                }
                default: {
                    value = TmfStateValue.newValueInt((int)fieldInteger);
                    break;
                }
            }
        } else if (field instanceof Double) {
            Double fieldDouble = (Double)field;
            switch (this.fForcedType) {
                case LONG: {
                    value = TmfStateValue.newValueLong((long)fieldDouble.longValue());
                    break;
                }
                case STRING: {
                    value = TmfStateValue.newValueString((String)fieldDouble.toString());
                    break;
                }
                case INTEGER: {
                    value = TmfStateValue.newValueInt((int)fieldDouble.intValue());
                    break;
                }
                default: {
                    value = TmfStateValue.newValueDouble((double)fieldDouble);
                }
            }
        }
        return value;
    }

    @Override
    public List<ITmfXmlStateAttribute> getAttributes() {
        return this.fPath;
    }

    @Override
    public void handleEvent(@NonNull ITmfEvent event) throws AttributeNotFoundException, StateValueTypeException, TimeRangeException {
        int quark = -1;
        for (ITmfXmlStateAttribute attribute : this.fPath) {
            quark = attribute.getAttributeQuark(event, quark);
            if (quark != -1) continue;
            throw new AttributeNotFoundException("Not found XML attribute " + attribute);
        }
        long ts = event.getTimestamp().getValue();
        this.fStateValue.handleEvent(event, quark, ts);
    }

    public String toString() {
        return "TmfXmlStateValue: " + this.fStateValue;
    }

    protected abstract class TmfXmlStateValueBase {
        protected TmfXmlStateValueBase() {
        }

        public abstract ITmfStateValue getValue(@Nullable ITmfEvent var1) throws AttributeNotFoundException;

        public void handleEvent(@NonNull ITmfEvent event, int quark, long timestamp) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            if (TmfXmlStateValue.this.fIncrement) {
                this.incrementValue(event, quark, timestamp);
            } else {
                ITmfStateValue value = this.getValue(event);
                this.processValue(quark, timestamp, value);
            }
        }

        protected void processValue(int quark, long timestamp, ITmfStateValue value) throws TimeRangeException, StateValueTypeException, AttributeNotFoundException {
        }

        protected void incrementValue(ITmfEvent event, int quark, long timestamp) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
        }
    }

    private class TmfXmlStateValueNull
    extends TmfXmlStateValueBase {
        private TmfXmlStateValueNull() {
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event) throws AttributeNotFoundException {
            return TmfStateValue.nullValue();
        }
    }

    protected static enum ValueTypeStack {
        NULL,
        PEEK,
        POP,
        PUSH;


        public static ValueTypeStack getTypeFromString(String input) {
            switch (input) {
                case "push": {
                    return PUSH;
                }
                case "pop": {
                    return POP;
                }
                case "peek": {
                    return PEEK;
                }
            }
            return NULL;
        }
    }
}

