/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.statesystem.core.backend.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.eclipse.linuxtools.internal.statesystem.core.backend.historytree.CoreNode;
import org.eclipse.linuxtools.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.linuxtools.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.linuxtools.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.linuxtools.internal.statesystem.core.backend.historytree.HistoryTree;
import org.eclipse.linuxtools.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;

public class HistoryTreeBackend
implements IStateHistoryBackend {
    final HistoryTree sht;
    protected boolean isFinishedBuilding = false;

    public HistoryTreeBackend(File newStateFile, int blockSize, int maxChildren, int providerVersion, long startTime) throws IOException {
        HTConfig conf = new HTConfig(newStateFile, blockSize, maxChildren, providerVersion, startTime);
        this.sht = new HistoryTree(conf);
    }

    public HistoryTreeBackend(File newStateFile, int providerVersion, long startTime) throws IOException {
        this(newStateFile, 65536, 50, providerVersion, startTime);
    }

    public HistoryTreeBackend(File existingStateFile, int providerVersion) throws IOException {
        this.sht = new HistoryTree(existingStateFile, providerVersion);
        this.isFinishedBuilding = true;
    }

    @Override
    public long getStartTime() {
        return this.sht.getTreeStart();
    }

    @Override
    public long getEndTime() {
        return this.sht.getTreeEnd();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, (TmfStateValue)value);
        this.sht.insertInterval(interval);
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.sht.closeTree(endTime);
        this.isFinishedBuilding = true;
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return this.sht.supplyATReader();
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return this.sht.supplyATWriterFile();
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return this.sht.supplyATWriterFilePos();
    }

    @Override
    public void removeFiles() {
        this.sht.deleteFile();
    }

    @Override
    public void dispose() {
        if (this.isFinishedBuilding) {
            this.sht.closeFile();
        } else {
            this.sht.deleteFile();
        }
    }

    @Override
    public void doQuery(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        HTNode currentNode = this.sht.getRootNode();
        currentNode.writeInfoFromNode(stateInfo, t);
        try {
            while (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                currentNode = this.sht.selectNextChild((CoreNode)currentNode, t);
                currentNode.writeInfoFromNode(stateInfo, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        return this.getRelevantInterval(t, attributeQuark);
    }

    @Override
    public boolean checkValidTime(long t) {
        return t >= this.sht.getTreeStart() && t <= this.sht.getTreeEnd();
    }

    private HTInterval getRelevantInterval(long t, int key) throws TimeRangeException, StateSystemDisposedException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        HTNode currentNode = this.sht.getRootNode();
        HTInterval interval = currentNode.getRelevantInterval(key, t);
        try {
            while (interval == null && currentNode.getNodeType() == HTNode.NodeType.CORE) {
                currentNode = this.sht.selectNextChild((CoreNode)currentNode, t);
                interval = currentNode.getRelevantInterval(key, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
        assert (interval != null);
        return interval;
    }

    public long getFileSize() {
        return this.sht.getFileSize();
    }

    public int getAverageNodeUsage() {
        long total = 0L;
        try {
            int seq = 0;
            while (seq < this.sht.getNodeCount()) {
                HTNode node = this.sht.readNode(seq);
                total += node.getNodeUsagePercent();
                ++seq;
            }
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
        }
        long ret = total / (long)this.sht.getNodeCount();
        assert (ret >= 0L && ret <= 100L);
        return (int)ret;
    }

    @Override
    public void debugPrint(PrintWriter writer) {
        this.debugPrint(writer, false);
    }

    public void debugPrint(PrintWriter writer, boolean printIntervals) {
        writer.println("------------------------------");
        writer.println("State History Tree:\n");
        writer.println(this.sht.toString());
        writer.println("Average node utilization: " + this.getAverageNodeUsage());
        writer.println("");
        this.sht.debugPrintFullTree(writer, printIntervals);
    }
}

