/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.eclipse.photran.internal.core.vpg.IVPGNode;
import org.eclipse.photran.internal.core.vpg.VPG;
import org.eclipse.photran.internal.core.vpg.VPGWriter;

final class ASTRepository<A> {
    protected HashMap<String, A> permanentASTs;
    protected HashMap<String, WeakReference<A>> transientASTs;
    protected Object[] transientASTCache;
    private int transientASTCacheIndex = 0;

    public ASTRepository(int transientASTCacheSize) {
        assert (transientASTCacheSize > 0);
        this.transientASTs = new HashMap();
        this.permanentASTs = new HashMap();
        this.transientASTCache = new Object[transientASTCacheSize];
    }

    public <T, R extends IVPGNode<T>> A acquireTransientAST(String filename, boolean forceRecomputationOfEdgesAndAnnotations, VPG<A, T, R> vpg) {
        boolean shouldComputeEdgesAndAnnotations;
        if (vpg.isVirtualFile(filename) || !vpg.shouldProcessFile(filename)) {
            return null;
        }
        Object ast = null;
        if (!forceRecomputationOfEdgesAndAnnotations) {
            if (this.permanentASTs.containsKey(filename)) {
                ast = this.permanentASTs.get(filename);
            } else if (this.transientASTs.containsKey(filename)) {
                ast = this.transientASTs.get(filename).get();
            }
            if (ast != null) {
                return ast;
            }
        }
        boolean bl = shouldComputeEdgesAndAnnotations = forceRecomputationOfEdgesAndAnnotations || vpg.isOutOfDate(filename);
        if (shouldComputeEdgesAndAnnotations) {
            vpg.getLog().clearEntriesFor(filename);
        }
        if ((ast = (Object)vpg.parse(filename)) != null) {
            WeakReference<Object> astRef = new WeakReference<Object>(ast);
            this.transientASTs.put(filename, astRef);
            this.transientASTCache[this.transientASTCacheIndex] = ast;
            this.transientASTCacheIndex = (this.transientASTCacheIndex + 1) % this.transientASTCache.length;
        }
        if (shouldComputeEdgesAndAnnotations) {
            ((VPGWriter)vpg.getVPGWriter()).computeEdgesAndAnnotations(filename, ast);
        }
        return ast;
    }

    public <T, R extends IVPGNode<T>> A acquirePermanentAST(String filename, VPG<A, T, R> vpg) {
        A ast = this.acquireTransientAST(filename, false, vpg);
        return this.makeTransientASTPermanent(filename, ast);
    }

    public <T, R extends IVPGNode<T>> A makeTransientASTPermanent(String filename, VPG<A, T, R> vpg) {
        return this.makeTransientASTPermanent(filename, this.acquireTransientAST(filename, false, vpg));
    }

    public A makeTransientASTPermanent(String filename, A ast) {
        this.transientASTs.remove(filename);
        this.permanentASTs.put(filename, ast);
        return ast;
    }

    public void releaseAST(String filename) {
        this.transientASTs.remove(filename);
        this.permanentASTs.remove(filename);
    }

    public void releaseAllASTs() {
        this.transientASTs.clear();
        this.permanentASTs.clear();
    }

    public String getFilenameCorrespondingTo(A ast) {
        for (String filename : this.transientASTs.keySet()) {
            if (this.transientASTs.get(filename).get() != ast) continue;
            return filename;
        }
        for (String filename : this.permanentASTs.keySet()) {
            if (this.permanentASTs.get(filename) != ast) continue;
            return filename;
        }
        return null;
    }
}

