/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.filter;

import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.collapse.ITmfCollapsibleEvent;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;

public class TmfCollapseFilter
implements ITmfFilterTreeNode {
    private static final String COLLAPSE_NODE_NAME = "Collapse";
    private ITmfCollapsibleEvent fPrevEvent = null;

    @Override
    public boolean matches(ITmfEvent event) {
        if (this.fPrevEvent != null) {
            if (event instanceof ITmfCollapsibleEvent) {
                boolean isCollapsible = this.fPrevEvent.isCollapsibleWith(event);
                this.fPrevEvent = (ITmfCollapsibleEvent)((Object)event);
                if (isCollapsible) {
                    return false;
                }
            } else {
                this.fPrevEvent = null;
            }
        } else if (event instanceof ITmfCollapsibleEvent) {
            this.fPrevEvent = (ITmfCollapsibleEvent)((Object)event);
        }
        return true;
    }

    @Override
    public ITmfFilterTreeNode getParent() {
        return null;
    }

    @Override
    public String getNodeName() {
        return COLLAPSE_NODE_NAME;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public int getChildrenCount() {
        return 0;
    }

    @Override
    public ITmfFilterTreeNode[] getChildren() {
        return new ITmfFilterTreeNode[0];
    }

    @Override
    public ITmfFilterTreeNode getChild(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITmfFilterTreeNode remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITmfFilterTreeNode removeChild(ITmfFilterTreeNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int addChild(ITmfFilterTreeNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITmfFilterTreeNode replaceChild(int index, ITmfFilterTreeNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParent(ITmfFilterTreeNode parent) {
    }

    @Override
    public List<String> getValidChildren() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITmfFilterTreeNode clone() {
        return new TmfCollapseFilter();
    }
}

