/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace.indexer;

import org.eclipse.linuxtools.internal.tmf.core.trace.indexer.IBTreeVisitor;
import org.eclipse.linuxtools.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;

public class BTreeCheckpointVisitor
implements IBTreeVisitor {
    private long rank = -1L;
    private ITmfCheckpoint found;
    private ITmfCheckpoint search;
    private boolean exactFound = false;

    public BTreeCheckpointVisitor(ITmfCheckpoint search) {
        this.search = search;
    }

    @Override
    public int compare(ITmfCheckpoint currentCheckpoint) {
        int compareTo = currentCheckpoint.compareTo(this.search);
        if (compareTo <= 0 && !this.exactFound) {
            this.rank = currentCheckpoint.getCheckpointRank();
            this.found = currentCheckpoint;
            if (compareTo == 0) {
                this.exactFound = true;
            }
        }
        return compareTo;
    }

    public ITmfCheckpoint getCheckpoint() {
        return this.found;
    }

    public long getCheckpointRank() {
        if (!this.exactFound) {
            long insertionPoint = this.rank + 1L;
            return -insertionPoint - 1L;
        }
        return this.rank;
    }
}

