/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.analysis;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModule;
import org.eclipse.linuxtools.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.linuxtools.tmf.core.analysis.Messages;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.linuxtools.tmf.core.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class TmfAnalysisModuleHelperConfigElement
implements IAnalysisModuleHelper {
    private final IConfigurationElement fCe;

    public TmfAnalysisModuleHelperConfigElement(IConfigurationElement ce) {
        this.fCe = ce;
    }

    @Override
    public String getId() {
        return this.fCe.getAttribute("id");
    }

    @Override
    public String getName() {
        return this.fCe.getAttribute("name");
    }

    @Override
    public boolean isAutomatic() {
        return Boolean.parseBoolean(this.fCe.getAttribute("automatic"));
    }

    @Override
    public String getHelpText() {
        return new String("The trace must be opened to get the help message");
    }

    @Override
    public String getIcon() {
        return this.fCe.getAttribute("icon");
    }

    @Override
    public Bundle getBundle() {
        return ContributorFactoryOSGi.resolve((IContributor)this.fCe.getContributor());
    }

    @Override
    public boolean appliesToTraceType(Class<? extends ITmfTrace> traceclass) {
        IConfigurationElement[] tracetypeCE;
        boolean applies = false;
        IConfigurationElement[] iConfigurationElementArray = tracetypeCE = this.fCe.getChildren("tracetype");
        int n = tracetypeCE.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Class applyclass = this.getBundle().loadClass(element.getAttribute("class"));
                String classAppliesVal = element.getAttribute("applies");
                boolean classApplies = true;
                if (classAppliesVal != null) {
                    classApplies = Boolean.parseBoolean(classAppliesVal);
                }
                if (classApplies) {
                    applies |= applyclass.isAssignableFrom(traceclass);
                } else if (applyclass.isAssignableFrom(traceclass)) {
                    applies = false;
                }
            }
            catch (ClassNotFoundException e) {
                Activator.logError("Error in applies to trace", e);
            }
            catch (InvalidRegistryObjectException e) {
                Activator.logError("Error in applies to trace", e);
            }
            ++n2;
        }
        return applies;
    }

    @Override
    public Iterable<Class<? extends ITmfTrace>> getValidTraceTypes() {
        HashSet<Class<? extends ITmfTrace>> traceTypes = new HashSet<Class<? extends ITmfTrace>>();
        for (TraceTypeHelper tth : TmfTraceType.getTraceTypeHelpers()) {
            if (!this.appliesToTraceType(tth.getTraceClass())) continue;
            traceTypes.add(tth.getTraceClass());
        }
        return traceTypes;
    }

    @Override
    public Iterable<TmfAnalysisRequirement> getAnalysisRequirements() {
        IAnalysisModule module = this.createModule();
        if (module != null) {
            return module.getAnalysisRequirements();
        }
        return Collections.EMPTY_SET;
    }

    private IAnalysisModule createModule() {
        IAnalysisModule module = null;
        try {
            module = (IAnalysisModule)this.fCe.createExecutableExtension("analysis_module");
            module.setName(this.getName());
            module.setId(this.getId());
        }
        catch (CoreException e) {
            Activator.logError("Error getting analysis modules from configuration files", e);
        }
        return module;
    }

    @Override
    public IAnalysisModule newModule(ITmfTrace trace) throws TmfAnalysisException {
        IConfigurationElement[] parametersCE;
        if (!this.appliesToTraceType(trace.getClass())) {
            throw new TmfAnalysisException(NLS.bind((String)Messages.TmfAnalysisModuleHelper_AnalysisDoesNotApply, (Object)this.getName()));
        }
        IAnalysisModule module = this.createModule();
        if (module == null) {
            return null;
        }
        module.setAutomatic(this.isAutomatic());
        IConfigurationElement[] iConfigurationElementArray = parametersCE = this.fCe.getChildren("parameter");
        int n = parametersCE.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            module.addParameter(element.getAttribute("name"));
            String defaultValue = element.getAttribute("default_value");
            if (defaultValue != null) {
                module.setParameter(element.getAttribute("name"), defaultValue);
            }
            ++n2;
        }
        module.setTrace(trace);
        TmfAnalysisManager.analysisModuleCreated(module);
        return module;
    }

    @Override
    public String getHelpText(@NonNull ITmfTrace trace) {
        IAnalysisModule module = this.createModule();
        if (module != null) {
            String ret = module.getHelpText(trace);
            module.dispose();
            return ret;
        }
        return this.getHelpText();
    }
}

